/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.gui.plaf.palette;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTextFieldUI;
import javax.swing.text.JTextComponent;
import org.jhotdraw.gui.plaf.palette.BackdropBorder;
import org.jhotdraw.gui.plaf.palette.PaletteLookAndFeel;

public class PaletteTextFieldUI
extends BasicTextFieldUI {
    public static ComponentUI createUI(JComponent c) {
        return new PaletteTextFieldUI();
    }

    @Override
    protected void installDefaults() {
        Insets margin;
        Border b;
        Color dfg;
        Color sfg;
        Color s;
        Color color;
        Color fg;
        Color bg;
        JTextComponent editor = this.getComponent();
        PaletteLookAndFeel plaf = PaletteLookAndFeel.getInstance();
        String prefix = this.getPropertyPrefix();
        Font f = editor.getFont();
        if (f == null || f instanceof UIResource) {
            editor.setFont(plaf.getFont(prefix + ".font"));
        }
        if ((bg = editor.getBackground()) == null || bg instanceof UIResource) {
            editor.setBackground(plaf.getColor(prefix + ".background"));
        }
        if ((fg = editor.getForeground()) == null || fg instanceof UIResource) {
            editor.setForeground(plaf.getColor(prefix + ".foreground"));
        }
        if ((color = editor.getCaretColor()) == null || color instanceof UIResource) {
            editor.setCaretColor(plaf.getColor(prefix + ".caretForeground"));
        }
        if ((s = editor.getSelectionColor()) == null || s instanceof UIResource) {
            editor.setSelectionColor(plaf.getColor(prefix + ".selectionBackground"));
        }
        if ((sfg = editor.getSelectedTextColor()) == null || sfg instanceof UIResource) {
            editor.setSelectedTextColor(plaf.getColor(prefix + ".selectionForeground"));
        }
        if ((dfg = editor.getDisabledTextColor()) == null || dfg instanceof UIResource) {
            editor.setDisabledTextColor(plaf.getColor(prefix + ".inactiveForeground"));
        }
        if ((b = editor.getBorder()) == null || b instanceof UIResource) {
            editor.setBorder(plaf.getBorder(prefix + ".border"));
        }
        if ((margin = editor.getMargin()) == null || margin instanceof UIResource) {
            editor.setMargin(plaf.getInsets(prefix + ".margin"));
        }
        editor.setOpaque(plaf.getBoolean(prefix + ".opaque"));
    }

    @Override
    protected void paintSafely(Graphics gr) {
        Graphics2D g = (Graphics2D)gr;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        super.paintSafely(g);
    }

    @Override
    public void paintBackground(Graphics g) {
        JTextComponent c = this.getComponent();
        if (c.getBorder() instanceof BackdropBorder) {
            BackdropBorder bb = (BackdropBorder)c.getBorder();
            bb.getBackdropBorder().paintBorder(c, g, 0, 0, c.getWidth(), c.getHeight());
        } else {
            super.paintBackground(g);
        }
    }
}

