/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Container;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jhotdraw.draw.AbstractTool;
import org.jhotdraw.draw.DragTracker;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.Figure;

public class DnDTracker
extends AbstractTool
implements DragTracker {
    protected Figure anchorFigure;
    protected Rectangle2D.Double dragRect;
    protected Point2D.Double previousOrigin;
    protected Point2D.Double anchorOrigin;
    protected Point2D.Double previousPoint;
    protected Point2D.Double anchorPoint;
    private boolean isDragging;

    public DnDTracker() {
    }

    public DnDTracker(Figure figure) {
        this.anchorFigure = figure;
    }

    @Override
    public void mouseMoved(MouseEvent evt) {
        this.updateCursor(this.editor.findView((Container)evt.getSource()), evt.getPoint());
    }

    @Override
    public void mousePressed(MouseEvent evt) {
        super.mousePressed(evt);
        DrawingView view = this.getView();
        if (evt.isShiftDown()) {
            view.setHandleDetailLevel(0);
            view.toggleSelection(this.anchorFigure);
            if (!view.isFigureSelected(this.anchorFigure)) {
                this.anchorFigure = null;
            }
        } else if (!view.isFigureSelected(this.anchorFigure)) {
            view.setHandleDetailLevel(0);
            view.clearSelection();
            view.addToSelection(this.anchorFigure);
        }
        if (!view.getSelectedFigures().isEmpty()) {
            this.dragRect = null;
            for (Figure f : view.getSelectedFigures()) {
                if (this.dragRect == null) {
                    this.dragRect = f.getBounds();
                    continue;
                }
                this.dragRect.add(f.getBounds());
            }
            this.anchorPoint = this.previousPoint = view.viewToDrawing(this.anchor);
            this.anchorOrigin = this.previousOrigin = new Point2D.Double(this.dragRect.x, this.dragRect.y);
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        DrawingView v = this.getView();
        Figure f = v.findFigure(e.getPoint());
        if (f != null) {
            if (!v.getSelectedFigures().contains(f)) {
                v.clearSelection();
                v.addToSelection(f);
            }
            v.getComponent().getTransferHandler().exportAsDrag(v.getComponent(), e, 2);
        }
        this.fireToolDone();
    }

    @Override
    public void mouseReleased(MouseEvent evt) {
        this.updateCursor(this.editor.findView((Container)evt.getSource()), evt.getPoint());
        this.fireToolDone();
    }

    @Override
    public void setDraggedFigure(Figure f) {
        this.anchorFigure = f;
    }
}

