/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.network;

import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ProxyDetector {
    private static final String PROXY_PROPERTY = "java.net.useSystemProxies";
    private final List<Proxy> proxies = this.initProxies();
    private final Proxy proxyToUse = this.determineProxy();
    private static final Log log = LogFactory.getLog(ProxyDetector.class);

    private ProxyDetector() {
    }

    public static ProxyDetector getInstance() {
        return ProxyDetectorHolder.INSTANCE;
    }

    private List<Proxy> initProxies() {
        String valuePropertyBefore = System.getProperty(PROXY_PROPERTY);
        try {
            System.setProperty(PROXY_PROPERTY, "true");
            List<Proxy> list = ProxySelector.getDefault().select(new URI("http://www.google.com"));
            return list;
        }
        catch (Exception e) {
            log.error(null, (Throwable)e);
        }
        finally {
            if (valuePropertyBefore != null) {
                System.setProperty(PROXY_PROPERTY, valuePropertyBefore);
            }
        }
        return Collections.emptyList();
    }

    public boolean directConnectionAvailable() {
        for (Proxy proxy : this.proxies) {
            if (!Proxy.NO_PROXY.equals(proxy)) continue;
            return true;
        }
        return false;
    }

    public boolean proxyDetected() {
        return this.proxyToUse != null;
    }

    private Proxy determineProxy() {
        if (!this.directConnectionAvailable()) {
            for (Proxy proxy : this.proxies) {
                if (!proxy.type().equals((Object)Proxy.Type.HTTP)) continue;
                return proxy;
            }
        }
        return null;
    }

    public String getHostname() {
        SocketAddress socketAddress;
        if (this.proxyToUse != null && (socketAddress = this.proxyToUse.address()) instanceof InetSocketAddress) {
            InetSocketAddress address = (InetSocketAddress)socketAddress;
            return address.getHostName();
        }
        return null;
    }

    public int getPort() {
        SocketAddress socketAddress;
        if (this.proxyToUse != null && (socketAddress = this.proxyToUse.address()) instanceof InetSocketAddress) {
            InetSocketAddress address = (InetSocketAddress)socketAddress;
            return address.getPort();
        }
        return -1;
    }

    private static class ProxyDetectorHolder {
        private static final ProxyDetector INSTANCE = new ProxyDetector();

        private ProxyDetectorHolder() {
        }
    }
}

