/*
 * Decompiled with CFR 0.152.
 */
package jlibs.core.util.i18n;

import jlibs.core.util.i18n.I18N;

public enum Hint {
    DISPLAY_NAME("displayName"),
    DESCRIPTION("description"),
    ADVANCED("advanced", "false"),
    NONE(null);

    private String key;
    private String defaultValue;

    private Hint(String key) {
        this(key, null);
    }

    private Hint(String key, String defaultValue) {
        this.key = key;
        this.defaultValue = defaultValue;
    }

    public String key() {
        return this.key;
    }

    public String defaultValue() {
        return this.defaultValue;
    }

    public String stringValue(Class clazz, String member) {
        String value = I18N.getHint(clazz, member, this.key, new Object[0]);
        return value == null ? this.defaultValue : value;
    }

    public String stringValue(Class clazz) {
        String value = I18N.getHint(clazz, this.key, new Object[0]);
        return value == null ? this.defaultValue : value;
    }

    public boolean booleanValue(Class clazz, String member) {
        return Boolean.parseBoolean(this.stringValue(clazz, member));
    }

    public boolean booleanValue(Class clazz) {
        return Boolean.parseBoolean(this.stringValue(clazz));
    }

    public int intValue(Class clazz, String member) {
        return Integer.parseInt(this.stringValue(clazz, member));
    }

    public int intValue(Class clazz) {
        return Integer.parseInt(this.stringValue(clazz));
    }
}

