/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.core.buffer;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import org.apache.mina.core.buffer.IoBuffer;

public class IoBufferWrapper
extends IoBuffer {
    private final IoBuffer buf;

    protected IoBufferWrapper(IoBuffer ioBuffer) {
        if (ioBuffer == null) {
            throw new IllegalArgumentException("buf");
        }
        this.buf = ioBuffer;
    }

    public ByteBuffer buf() {
        return this.buf.buf();
    }

    public int capacity() {
        return this.buf.capacity();
    }

    public int position() {
        return this.buf.position();
    }

    public IoBuffer position(int n) {
        this.buf.position(n);
        return this;
    }

    public int limit() {
        return this.buf.limit();
    }

    public IoBuffer limit(int n) {
        this.buf.limit(n);
        return this;
    }

    public IoBuffer mark() {
        this.buf.mark();
        return this;
    }

    public IoBuffer reset() {
        this.buf.reset();
        return this;
    }

    public IoBuffer clear() {
        this.buf.clear();
        return this;
    }

    public IoBuffer flip() {
        this.buf.flip();
        return this;
    }

    public IoBuffer rewind() {
        this.buf.rewind();
        return this;
    }

    public int remaining() {
        return this.buf.remaining();
    }

    public boolean hasRemaining() {
        return this.buf.hasRemaining();
    }

    public byte get() {
        return this.buf.get();
    }

    public IoBuffer put(byte by) {
        this.buf.put(by);
        return this;
    }

    public byte get(int n) {
        return this.buf.get(n);
    }

    public IoBuffer get(byte[] byArray, int n, int n2) {
        this.buf.get(byArray, n, n2);
        return this;
    }

    public IoBuffer get(byte[] byArray) {
        this.buf.get(byArray);
        return this;
    }

    public IoBuffer put(IoBuffer ioBuffer) {
        this.buf.put(ioBuffer);
        return this;
    }

    public IoBuffer put(byte[] byArray, int n, int n2) {
        this.buf.put(byArray, n, n2);
        return this;
    }

    public IoBuffer put(byte[] byArray) {
        this.buf.put(byArray);
        return this;
    }

    public IoBuffer compact() {
        this.buf.compact();
        return this;
    }

    public String toString() {
        return this.buf.toString();
    }

    public int hashCode() {
        return this.buf.hashCode();
    }

    public boolean equals(Object object) {
        return this.buf.equals(object);
    }

    public int compareTo(IoBuffer ioBuffer) {
        return this.buf.compareTo(ioBuffer);
    }

    public ByteOrder order() {
        return this.buf.order();
    }

    public IoBuffer order(ByteOrder byteOrder) {
        this.buf.order(byteOrder);
        return this;
    }

    public short getShort() {
        return this.buf.getShort();
    }

    public IoBuffer putShort(short s) {
        this.buf.putShort(s);
        return this;
    }

    public int getInt() {
        return this.buf.getInt();
    }

    public IoBuffer putInt(int n) {
        this.buf.putInt(n);
        return this;
    }

    public double getDouble() {
        return this.buf.getDouble();
    }

    public IoBuffer putDouble(double d) {
        this.buf.putDouble(d);
        return this;
    }

    public String getHexDump() {
        return this.buf.getHexDump();
    }

    public String getString(CharsetDecoder charsetDecoder) throws CharacterCodingException {
        return this.buf.getString(charsetDecoder);
    }

    public boolean isAutoExpand() {
        return this.buf.isAutoExpand();
    }

    public IoBuffer setAutoExpand(boolean bl) {
        this.buf.setAutoExpand(bl);
        return this;
    }

    public void free() {
        this.buf.free();
    }
}

