/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.binding.beans;

import com.jgoodies.binding.beans.PropertyNotBindableException;
import com.jgoodies.binding.beans.PropertyUnboundException;
import com.jgoodies.common.base.Preconditions;
import com.jgoodies.common.bean.ObservableBean;
import com.jgoodies.common.bean.ObservableBean2;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public final class BeanUtils {
    private static final Class<?>[] PCL_PARAMS = new Class[]{PropertyChangeListener.class};
    private static final Class<?>[] NAMED_PCL_PARAMS = new Class[]{String.class, PropertyChangeListener.class};

    private BeanUtils() {
    }

    public static boolean supportsBoundProperties(Class<?> clazz) {
        return BeanUtils.getPCLAdder(clazz) != null && BeanUtils.getPCLRemover(clazz) != null;
    }

    public static Method getPCLAdder(Class<?> clazz) {
        try {
            return clazz.getMethod("addPropertyChangeListener", PCL_PARAMS);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public static Method getPCLRemover(Class<?> clazz) {
        try {
            return clazz.getMethod("removePropertyChangeListener", PCL_PARAMS);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public static Method getNamedPCLAdder(Class<?> clazz) {
        try {
            return clazz.getMethod("addPropertyChangeListener", NAMED_PCL_PARAMS);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public static Method getNamedPCLRemover(Class<?> clazz) {
        try {
            return clazz.getMethod("removePropertyChangeListener", NAMED_PCL_PARAMS);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public static void addPropertyChangeListener(Object bean, Class<?> beanClass, PropertyChangeListener listener) {
        Preconditions.checkNotNull((Object)listener, (String)"The listener must not be null.");
        if (beanClass == null) {
            beanClass = bean.getClass();
        } else {
            Preconditions.checkArgument((boolean)beanClass.isInstance(bean), (String)"The bean %s must be an instance of %s", (Object[])new Object[]{bean, beanClass});
        }
        if (bean instanceof ObservableBean) {
            ((ObservableBean)bean).addPropertyChangeListener(listener);
            return;
        }
        if (!BeanUtils.supportsBoundProperties(beanClass)) {
            throw new PropertyUnboundException("Bound properties unsupported by bean class=" + beanClass + "\nThe Bean class must provide a pair of methods:" + "\npublic void addPropertyChangeListener(PropertyChangeListener x);" + "\npublic void removePropertyChangeListener(PropertyChangeListener x);");
        }
        Method multicastPCLAdder = BeanUtils.getPCLAdder(beanClass);
        try {
            multicastPCLAdder.invoke(bean, listener);
        }
        catch (InvocationTargetException e) {
            throw new PropertyNotBindableException("Due to an InvocationTargetException we failed to add a multicast PropertyChangeListener to bean: " + bean, e.getCause());
        }
        catch (IllegalAccessException e) {
            throw new PropertyNotBindableException("Due to an IllegalAccessException we failed to add a multicast PropertyChangeListener to bean: " + bean, e);
        }
    }

    public static void addPropertyChangeListener(Object bean, Class<?> beanClass, String propertyName, PropertyChangeListener listener) {
        Preconditions.checkNotNull((Object)propertyName, (String)"The property name must not be null.");
        Preconditions.checkNotNull((Object)listener, (String)"The listener must not be null.");
        if (beanClass == null) {
            beanClass = bean.getClass();
        } else {
            Preconditions.checkArgument((boolean)beanClass.isInstance(bean), (String)"The bean %s must be an instance of %s", (Object[])new Object[]{bean, beanClass});
        }
        if (bean instanceof ObservableBean2) {
            ((ObservableBean2)bean).addPropertyChangeListener(propertyName, listener);
            return;
        }
        Method namedPCLAdder = BeanUtils.getNamedPCLAdder(beanClass);
        if (namedPCLAdder == null) {
            throw new PropertyNotBindableException("Could not find the bean method\npublic void addPropertyChangeListener(String, PropertyChangeListener);\nin bean: " + bean);
        }
        try {
            namedPCLAdder.invoke(bean, propertyName, listener);
        }
        catch (InvocationTargetException e) {
            throw new PropertyNotBindableException("Due to an InvocationTargetException we failed to add a named PropertyChangeListener to bean: " + bean, e.getCause());
        }
        catch (IllegalAccessException e) {
            throw new PropertyNotBindableException("Due to an IllegalAccessException we failed to add a named PropertyChangeListener to bean: " + bean, e);
        }
    }

    public static void addPropertyChangeListener(Object bean, PropertyChangeListener listener) {
        BeanUtils.addPropertyChangeListener(bean, (Class)null, listener);
    }

    public static void addPropertyChangeListener(Object bean, String propertyName, PropertyChangeListener listener) {
        BeanUtils.addPropertyChangeListener(bean, null, propertyName, listener);
    }

    public static void removePropertyChangeListener(Object bean, Class<?> beanClass, PropertyChangeListener listener) {
        Preconditions.checkNotNull((Object)listener, (String)"The listener must not be null.");
        if (beanClass == null) {
            beanClass = bean.getClass();
        } else {
            Preconditions.checkArgument((boolean)beanClass.isInstance(bean), (String)"The bean %s must be an instance of %s", (Object[])new Object[]{bean, beanClass});
        }
        if (bean instanceof ObservableBean) {
            ((ObservableBean)bean).removePropertyChangeListener(listener);
            return;
        }
        Method multicastPCLRemover = BeanUtils.getPCLRemover(beanClass);
        if (multicastPCLRemover == null) {
            throw new PropertyUnboundException("Could not find the method:\npublic void removePropertyChangeListener(String, PropertyChangeListener x);\nfor bean:" + bean);
        }
        try {
            multicastPCLRemover.invoke(bean, listener);
        }
        catch (InvocationTargetException e) {
            throw new PropertyNotBindableException("Due to an InvocationTargetException we failed to remove a multicast PropertyChangeListener from bean: " + bean, e.getCause());
        }
        catch (IllegalAccessException e) {
            throw new PropertyNotBindableException("Due to an IllegalAccessException we failed to remove a multicast PropertyChangeListener from bean: " + bean, e);
        }
    }

    public static void removePropertyChangeListener(Object bean, Class<?> beanClass, String propertyName, PropertyChangeListener listener) {
        Preconditions.checkNotNull((Object)propertyName, (String)"The property name must not be null.");
        Preconditions.checkNotNull((Object)listener, (String)"The listener must not be null.");
        if (beanClass == null) {
            beanClass = bean.getClass();
        } else {
            Preconditions.checkArgument((boolean)beanClass.isInstance(bean), (String)"The bean %s must be an instance of %s", (Object[])new Object[]{bean, beanClass});
        }
        if (bean instanceof ObservableBean2) {
            ((ObservableBean2)bean).removePropertyChangeListener(propertyName, listener);
            return;
        }
        Method namedPCLRemover = BeanUtils.getNamedPCLRemover(beanClass);
        if (namedPCLRemover == null) {
            throw new PropertyNotBindableException("Could not find the bean method\npublic void removePropertyChangeListener(String, PropertyChangeListener);\nin bean: " + bean);
        }
        try {
            namedPCLRemover.invoke(bean, propertyName, listener);
        }
        catch (InvocationTargetException e) {
            throw new PropertyNotBindableException("Due to an InvocationTargetException we failed to remove a named PropertyChangeListener from bean: " + bean, e.getCause());
        }
        catch (IllegalAccessException e) {
            throw new PropertyNotBindableException("Due to an IllegalAccessException we failed to remove a named PropertyChangeListener from bean: " + bean, e);
        }
    }

    public static void removePropertyChangeListener(Object bean, PropertyChangeListener listener) {
        BeanUtils.removePropertyChangeListener(bean, (Class)null, listener);
    }

    public static void removePropertyChangeListener(Object bean, String propertyName, PropertyChangeListener listener) {
        BeanUtils.removePropertyChangeListener(bean, null, propertyName, listener);
    }
}

