/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.appframework.swingx;

import com.jgoodies.common.collect.ArrayListModel;
import java.awt.Component;
import java.beans.DefaultPersistenceDelegate;
import java.beans.Encoder;
import java.beans.Expression;
import java.beans.PersistenceDelegate;
import java.beans.XMLEncoder;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.session.PropertySupport;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.table.TableColumnExt;

public class XProperties {
    public void registerPersistenceDelegates(ApplicationContext context) {
        Map<Class<?>, PersistenceDelegate> persistentDelegates = context.getLocalStorage().getPersistentDelegates();
        persistentDelegates.put(SortKeyState.class, new DefaultPersistenceDelegate(new String[]{"sortOrder", "modelIndex"}));
        persistentDelegates.put(ColumnState.class, new DefaultPersistenceDelegate(new String[]{"width", "preferredWidth", "modelIndex", "visible", "viewIndex"}));
        persistentDelegates.put(XTableState.class, new DefaultPersistenceDelegate(new String[]{"sortOrder", "modelIndex"}));
        persistentDelegates.put(XTableState.class, new DefaultPersistenceDelegate(new String[]{"columnStates", "sortKeyState", "horizontalScrollEnabled"}));
        persistentDelegates.put(ArrayListModel.class, new XMLEncoder(System.out).getPersistenceDelegate(List.class));
        PrimitivePersistenceDelegate primitivePersistenceDelegate = new PrimitivePersistenceDelegate();
        persistentDelegates.put(URL.class, new PrimitivePersistenceDelegate());
        persistentDelegates.put(File.class, primitivePersistenceDelegate);
    }

    public static class VisibleColumnIndexComparator
    implements Comparator<ColumnState> {
        @Override
        public int compare(ColumnState o1, ColumnState o2) {
            return o1.getViewIndex() - o2.getViewIndex();
        }
    }

    public static class ColumnState {
        private int width;
        private int preferredWidth;
        private int modelIndex;
        private boolean visible;
        private int viewIndex;

        public ColumnState(int width, int preferredWidth, int modelColumn, boolean visible, int viewIndex) {
            this.width = width;
            this.preferredWidth = preferredWidth;
            this.modelIndex = modelColumn;
            this.visible = visible;
            this.viewIndex = viewIndex;
        }

        public ColumnState(TableColumnExt columnExt, int viewIndex) {
            this(columnExt.getWidth(), columnExt.getPreferredWidth(), columnExt.getModelIndex(), columnExt.isVisible(), viewIndex);
        }

        public void configureColumn(TableColumnExt columnExt) {
            if (this.modelIndex != columnExt.getModelIndex()) {
                return;
            }
            columnExt.setPreferredWidth(this.preferredWidth);
            columnExt.setWidth(this.width);
            columnExt.setVisible(this.visible);
        }

        public int getModelIndex() {
            return this.modelIndex;
        }

        public int getViewIndex() {
            return this.viewIndex;
        }

        public boolean getVisible() {
            return this.visible;
        }

        public int getWidth() {
            return this.width;
        }

        public int getPreferredWidth() {
            return this.preferredWidth;
        }
    }

    public static class SortKeyState {
        int modelIndex;
        int sortOrder;

        public SortKeyState(int sortOrder, int modelIndex) {
            this.sortOrder = sortOrder;
            this.modelIndex = modelIndex;
        }

        public SortKeyState(RowSorter.SortKey sortKey) {
            this(sortKey.getSortOrder().ordinal(), sortKey.getColumn());
        }

        protected RowSorter.SortKey getSortKey() {
            return new RowSorter.SortKey(this.getModelIndex(), SortOrder.values()[this.getSortOrder()]);
        }

        public int getSortOrder() {
            return this.sortOrder;
        }

        public int getModelIndex() {
            return this.modelIndex;
        }
    }

    public static class XTableState {
        ColumnState[] columnStates = new ColumnState[0];
        boolean horizontalScrollEnabled;
        SortKeyState sortKeyState;

        public XTableState() {
        }

        public XTableState(ColumnState[] columnStates, SortKeyState sortKeyState, boolean horizontalScrollEnabled) {
            this.columnStates = this.copyColumnStates(columnStates);
            this.sortKeyState = sortKeyState;
            this.setHorizontalScrollEnabled(horizontalScrollEnabled);
        }

        public void setSortKey(RowSorter.SortKey sortKey) {
            this.sortKeyState = new SortKeyState(sortKey);
        }

        private RowSorter.SortKey getSortKey() {
            if (this.sortKeyState != null) {
                return this.sortKeyState.getSortKey();
            }
            return null;
        }

        public XTableState(ColumnState[] columnStates) {
            this.columnStates = this.copyColumnStates(columnStates);
        }

        public ColumnState[] getColumnStates() {
            return this.copyColumnStates(this.columnStates);
        }

        public boolean getHorizontalScrollEnabled() {
            return this.horizontalScrollEnabled;
        }

        public void setHorizontalScrollEnabled(boolean horizontalScrollEnabled) {
            this.horizontalScrollEnabled = horizontalScrollEnabled;
        }

        private ColumnState[] copyColumnStates(ColumnState[] states) {
            if (states == null) {
                throw new IllegalArgumentException("invalid columnWidths");
            }
            ColumnState[] copy = new ColumnState[states.length];
            System.arraycopy(states, 0, copy, 0, states.length);
            return copy;
        }

        public SortKeyState getSortKeyState() {
            return this.sortKeyState;
        }
    }

    public static class XTableProperty
    implements PropertySupport {
        @Override
        public Object getSessionState(Component c) {
            this.checkComponent(c);
            JXTable table = (JXTable)c;
            ArrayList<ColumnState> columnStates = new ArrayList<ColumnState>();
            List<TableColumn> columns = table.getColumns(true);
            List<TableColumn> visibleColumns = table.getColumns();
            for (TableColumn column : columns) {
                columnStates.add(new ColumnState((TableColumnExt)column, visibleColumns.indexOf(column)));
            }
            XTableState tableState = new XTableState(columnStates.toArray(new ColumnState[columnStates.size()]));
            tableState.setHorizontalScrollEnabled(table.isHorizontalScrollEnabled());
            List<RowSorter.SortKey> keys = table.getRowSorter().getSortKeys();
            RowSorter.SortKey sortKey = null;
            for (RowSorter.SortKey key : keys) {
                if (SortOrder.UNSORTED.equals((Object)key.getSortOrder())) continue;
                sortKey = key;
                break;
            }
            if (sortKey != null) {
                tableState.setSortKey(sortKey);
            }
            return tableState;
        }

        @Override
        public void setSessionState(Component c, Object state) {
            this.checkComponent(c);
            JXTable table = (JXTable)c;
            XTableState tableState = (XTableState)state;
            ColumnState[] columnState = tableState.getColumnStates();
            List<TableColumn> columns = table.getColumns(true);
            if (this.canRestore(columnState, columns)) {
                for (int i = 0; i < columnState.length; ++i) {
                    columnState[i].configureColumn((TableColumnExt)columns.get(i));
                }
                this.restoreVisibleSequence(columnState, table.getColumnModel());
            }
            table.setHorizontalScrollEnabled(tableState.getHorizontalScrollEnabled());
            if (tableState.getSortKey() != null) {
                table.getRowSorter().setSortKeys(Collections.singletonList(tableState.getSortKey()));
            }
        }

        private void restoreVisibleSequence(ColumnState[] columnStates, TableColumnModel model) {
            List<ColumnState> visibleStates = this.getSortedVisibleColumnStates(columnStates);
            for (int i = 0; i < visibleStates.size(); ++i) {
                TableColumn column = model.getColumn(i);
                int modelIndex = visibleStates.get(i).getModelIndex();
                if (modelIndex == column.getModelIndex()) continue;
                int currentIndex = -1;
                for (int j = i + 1; j < model.getColumnCount(); ++j) {
                    TableColumn current = model.getColumn(j);
                    if (current.getModelIndex() != modelIndex) continue;
                    currentIndex = j;
                    break;
                }
                model.moveColumn(currentIndex, i);
            }
        }

        private List<ColumnState> getSortedVisibleColumnStates(ColumnState[] columnStates) {
            ArrayList<ColumnState> visibleStates = new ArrayList<ColumnState>();
            for (ColumnState columnState : columnStates) {
                if (!columnState.getVisible()) continue;
                visibleStates.add(columnState);
            }
            Collections.sort(visibleStates, new VisibleColumnIndexComparator());
            return visibleStates;
        }

        private boolean canRestore(ColumnState[] columnState, List<TableColumn> columns) {
            if (columnState == null || columnState.length > columns.size()) {
                return false;
            }
            for (int i = 0; i < columnState.length; ++i) {
                if (columnState[i].getModelIndex() == columns.get(i).getModelIndex()) continue;
                return false;
            }
            return true;
        }

        private void checkComponent(Component component) {
            if (component == null) {
                throw new IllegalArgumentException("null component");
            }
            if (!(component instanceof JXTable)) {
                throw new IllegalArgumentException("invalid component - expected JXTable");
            }
        }
    }

    class PrimitivePersistenceDelegate
    extends PersistenceDelegate {
        PrimitivePersistenceDelegate() {
        }

        @Override
        protected Expression instantiate(Object oldInstance, Encoder out) {
            return new Expression(oldInstance, oldInstance.getClass(), "new", new Object[]{oldInstance.toString()});
        }
    }
}

