/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.utilities.os;

import com.sun.jna.Native;
import com.sun.jna.platform.win32.Advapi32;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.win32.StdCallLibrary;

final class WindowsShutdownUtils {
    private static final int EWX_LOGOFF = 0;
    private static final int EWX_POWEROFF = 8;
    private static final int EWX_REBOOT = 2;
    private static final int EWX_FORCE = 4;
    private static final int EWX_FORCEIFHUNG = 16;
    private static final int SHTDN_REASON_FLAG_PLANNED = Integer.MIN_VALUE;

    private WindowsShutdownUtils() {
    }

    public static boolean shutdown(boolean force) {
        return WindowsShutdownUtils.exitWindowsEx(8, force);
    }

    public static boolean reboot(boolean force) {
        return WindowsShutdownUtils.exitWindowsEx(2, force);
    }

    public static boolean logout(boolean force) {
        return WindowsShutdownUtils.exitWindowsEx(0, force);
    }

    public static boolean standby() {
        return WindowsShutdownUtils.setSuspendState(false);
    }

    public static boolean hibernate() {
        return WindowsShutdownUtils.setSuspendState(true);
    }

    private static boolean setSuspendState(boolean hibernate) {
        return WindowsShutdownUtils.loadPowrProf().SetSuspendState(hibernate, false, false);
    }

    private static boolean exitWindowsEx(int flags, boolean force) {
        flags |= 0x10;
        if (force) {
            flags |= 4;
        }
        WindowsShutdownUtils.setShutdownPrivileges();
        return WindowsShutdownUtils.loadUser32().ExitWindowsEx(flags, Integer.MIN_VALUE);
    }

    private static void setShutdownPrivileges() {
        WinNT.HANDLEByReference token = new WinNT.HANDLEByReference();
        Advapi32.INSTANCE.OpenProcessToken(Kernel32.INSTANCE.GetCurrentProcess(), 32, token);
        WinNT.LUID luid = new WinNT.LUID();
        Advapi32.INSTANCE.LookupPrivilegeValue(null, "SeShutdownPrivilege", luid);
        WinNT.TOKEN_PRIVILEGES tp = new WinNT.TOKEN_PRIVILEGES(1);
        tp.Privileges[0] = new WinNT.LUID_AND_ATTRIBUTES(luid, new WinDef.DWORD(2L));
        Advapi32.INSTANCE.AdjustTokenPrivileges(token.getValue(), false, tp, 0, null, new IntByReference(0));
    }

    private static User32 loadUser32() {
        return (User32)Native.loadLibrary("user32", User32.class);
    }

    private static PowrProf loadPowrProf() {
        return (PowrProf)Native.loadLibrary("powrprof", PowrProf.class);
    }

    private static interface PowrProf
    extends StdCallLibrary {
        public boolean SetSuspendState(boolean var1, boolean var2, boolean var3);
    }

    private static interface User32
    extends StdCallLibrary {
        public boolean ExitWindowsEx(int var1, int var2);
    }
}

