/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.swing.components;

import cz.vity.freerapid.core.AppPrefs;
import cz.vity.freerapid.swing.Swinger;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Position;
import org.jdesktop.application.ResourceMap;

abstract class FindOnDemandAction
extends AbstractAction
implements DocumentListener,
KeyListener {
    protected JPanel searchPanel;
    protected JTextField searchField;
    protected JPopupMenu popup;
    private final ResourceMap map;
    private boolean initialized = false;
    protected JComponent comp = null;
    protected boolean ignoreCase;
    protected boolean shiftDown = false;
    protected boolean controlDown = false;

    public FindOnDemandAction(ResourceMap map) {
        super("Incremental Search");
        this.map = map;
    }

    private void initPanels() {
        this.searchPanel = new JPanel(new FlowLayout(0, 0, 0));
        this.searchField = new JTextField();
        this.popup = new JPopupMenu();
        this.searchPanel.setBackground(UIManager.getColor("ToolTip.background"));
        this.searchField.setOpaque(false);
        JLabel label = new JLabel();
        label.setName("labelQuickSearch");
        label.setFont(new Font("DialogInput", 1, 12));
        this.map.injectComponent(label);
        this.searchPanel.add(label);
        this.searchPanel.add(this.searchField);
        label.setLabelFor(this.searchField);
        this.popup.setName("quickSearchPopup");
        this.map.injectComponent(this.popup);
        this.searchField.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        this.searchPanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        this.popup.setBorder(BorderFactory.createLineBorder(Color.black));
        this.popup.add(this.searchPanel);
        this.initialized = true;
        this.searchField.setFont(new Font("DialogInput", 0, 12));
        this.searchField.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FindOnDemandAction.this.popup.setVisible(false);
            }
        }, KeyStroke.getKeyStroke(27, 0), 0);
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.searchField) {
            this.popup.setVisible(false);
        } else {
            if (!this.initialized) {
                this.initPanels();
            }
            this.comp = (JComponent)ae.getSource();
            this.ignoreCase = (ae.getModifiers() & 1) == 0;
            this.searchField.removeActionListener(this);
            this.searchField.removeKeyListener(this);
            this.searchField.getDocument().removeDocumentListener(this);
            this.initSearch(ae);
            this.searchField.addActionListener(this);
            this.searchField.addKeyListener(this);
            this.searchField.getDocument().addDocumentListener(this);
            Rectangle rect = this.comp.getVisibleRect();
            this.popup.show(this.comp, rect.x, rect.y - this.popup.getPreferredSize().height - 5);
            Swinger.inputFocus(this.searchField);
        }
    }

    protected void initSearch(ActionEvent ae) {
        this.searchField.setText("");
        this.searchField.setForeground(Color.black);
    }

    private void changed(Position.Bias bias) {
        this.popup.setVisible(false);
        this.popup.setVisible(true);
        this.searchField.requestFocus();
        this.searchField.setForeground(this.changed(this.comp, this.searchField.getText(), bias) ? Color.black : Color.red);
    }

    protected abstract boolean changed(JComponent var1, String var2, Position.Bias var3);

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.changed(null);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.changed(null);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent ke) {
        if (ke.getSource() != this.searchField) {
            return;
        }
        this.shiftDown = ke.isShiftDown();
        this.controlDown = ke.isControlDown();
        switch (ke.getKeyCode()) {
            case 38: {
                this.changed(Position.Bias.Backward);
                break;
            }
            case 40: {
                this.changed(Position.Bias.Forward);
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
        if (AppPrefs.getProperty("searchOnType", true)) {
            if (e.getSource().equals(this.searchField)) {
                return;
            }
            if (e.isActionKey()) {
                return;
            }
            String s = String.valueOf(e.getKeyChar());
            if ((e.getModifiers() == 0 || e.isShiftDown()) && (Character.isLetterOrDigit(e.getKeyChar()) || s.matches("\\p{Punct}"))) {
                this.actionPerformed(new ActionEvent(e.getSource(), e.getID(), "press"));
                this.searchField.setText(s);
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    public void install(JComponent comp) {
        comp.addKeyListener(this);
        comp.registerKeyboardAction(this, KeyStroke.getKeyStroke(70, 2), 0);
        comp.registerKeyboardAction(this, KeyStroke.getKeyStroke(70, 3), 0);
    }

    public void uninstall(JComponent comp) {
        comp.removeKeyListener(this);
    }
}

