/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.swing;

import cz.vity.freerapid.core.AppPrefs;
import cz.vity.freerapid.core.MainApp;
import cz.vity.freerapid.core.QuietMode;
import cz.vity.freerapid.swing.Swinger;
import cz.vity.freerapid.utilities.Utils;
import java.awt.AWTException;
import java.awt.CheckboxMenuItem;
import java.awt.Font;
import java.awt.Image;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.ResourceMap;

public class TrayIconSupport
implements PropertyChangeListener {
    private static final Logger logger = Logger.getLogger(TrayIconSupport.class.getName());
    private TrayIcon trayIcon;
    private boolean enabled;
    private WindowAdapter windowAdapter;
    private static final String TITLE_PROPERTY = "title";
    private String toolTip;

    public TrayIconSupport() {
        AppPrefs.getPreferences().addPreferenceChangeListener(new PreferenceChangeListener(){

            @Override
            public void preferenceChange(PreferenceChangeEvent evt) {
                if ("showTray".equals(evt.getKey())) {
                    TrayIconSupport.this.setVisibleByDefault();
                }
            }
        });
    }

    public synchronized void setVisible(boolean visible) {
        if (visible && !this.isEnabled()) {
            this.enable();
        } else if (this.isEnabled()) {
            this.disable();
        }
    }

    public synchronized void setVisibleByDefault() {
        this.setVisible(AppPrefs.getProperty("showTray", true));
    }

    private synchronized void enable() {
        if (!SystemTray.isSupported()) {
            logger.log(Level.WARNING, "Cannot enable tray icon - Tray icon is not supported on this system");
            return;
        }
        MainApp app = MainApp.getInstance(MainApp.class);
        ApplicationContext context = app.getContext();
        ResourceMap map = context.getResourceMap();
        final JFrame frame = app.getMainFrame();
        this.windowAdapter = new WindowAdapter(){

            @Override
            public void windowIconified(WindowEvent e) {
                if (TrayIconSupport.this.minimizeToTray()) {
                    frame.setVisible(false);
                }
            }
        };
        frame.addWindowListener(this.windowAdapter);
        if (this.minimizeToTray() && frame.getExtendedState() == 1) {
            frame.setVisible(false);
        }
        Image image = Utils.isWindows() ? Swinger.getResourceMap().getImageIcon("trayIconImageWin").getImage() : frame.getIconImage();
        frame.addPropertyChangeListener(TITLE_PROPERTY, this);
        MouseAdapter mouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e)) {
                    if (e.getClickCount() == 2) {
                        TrayIconSupport.this.windowPlay(frame, true);
                    } else if (e.getClickCount() == 1) {
                        TrayIconSupport.this.windowPlay(frame, false);
                    }
                    e.consume();
                }
            }
        };
        PopupMenu popup = this.buildPopmenu(app, map);
        Font font = frame.getFont().deriveFont(11.0f);
        popup.setFont(font);
        this.trayIcon = new TrayIcon(image, frame.getTitle(), popup);
        this.trayIcon.setImageAutoSize(AppPrefs.getProperty("trayIconAutoImageSize", true));
        this.trayIcon.addMouseListener(mouseListener);
        try {
            SystemTray tray = SystemTray.getSystemTray();
            tray.add(this.trayIcon);
            this.setEnabled(true);
        }
        catch (AWTException e) {
            logger.log(Level.WARNING, "Cannot enable Tray icon - Tray icon is not supported on this system");
        }
    }

    private boolean minimizeToTray() {
        return AppPrefs.getProperty("showTray", true) && AppPrefs.getProperty("minimizeToTray", false);
    }

    private void windowPlay(JFrame frame, boolean toFront) {
        int state = frame.getExtendedState();
        if ((state & 1) == 1) {
            frame.setExtendedState(state &= 0xFFFFFFFE);
            frame.setVisible(true);
            frame.toFront();
        } else if (!toFront) {
            frame.setExtendedState(state |= 1);
        }
    }

    private void windowRestore(JFrame frame) {
        int state = frame.getExtendedState();
        frame.setExtendedState(state &= 0xFFFFFFFE);
        frame.setVisible(true);
        frame.toFront();
    }

    private PopupMenu buildPopmenu(final MainApp app, ResourceMap map) {
        PopupMenu popup = new PopupMenu();
        MenuItem defaultItem = new MenuItem(map.getString("trayQuit", new Object[0]));
        MenuItem restoreItem = new MenuItem(map.getString("trayRestore", new Object[0]));
        final CheckboxMenuItem clipboardMonitoring = new CheckboxMenuItem(map.getString("monitorClipboardActionTray", new Object[0]));
        clipboardMonitoring.setState(AppPrefs.getProperty("clipboardMonitoring", true));
        clipboardMonitoring.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean b = clipboardMonitoring.getState();
                AppPrefs.storeProperty("clipboardMonitoring", b);
            }
        });
        final CheckboxMenuItem quietMode = new CheckboxMenuItem(map.getString("quietModeActionTray", new Object[0]));
        quietMode.setState(QuietMode.getInstance().isEnabled());
        quietMode.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean b = quietMode.getState();
                QuietMode.getInstance().setEnabled(b);
            }
        });
        final CheckboxMenuItem hideWhenMinimizedItem = new CheckboxMenuItem(map.getString("trayHideWhenMinimized", new Object[0]));
        hideWhenMinimizedItem.setState(AppPrefs.getProperty("minimizeToTray", false));
        AppPrefs.getPreferences().addPreferenceChangeListener(new PreferenceChangeListener(){

            @Override
            public void preferenceChange(PreferenceChangeEvent evt) {
                if ("minimizeToTray".equals(evt.getKey())) {
                    hideWhenMinimizedItem.setState(AppPrefs.getProperty("minimizeToTray", false));
                } else if ("clipboardMonitoring".equals(evt.getKey())) {
                    clipboardMonitoring.setState(AppPrefs.getProperty("clipboardMonitoring", true));
                } else if ("quietModeEnabled".equals(evt.getKey())) {
                    quietMode.setState(QuietMode.getInstance().isEnabled());
                }
            }
        });
        defaultItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                app.exit(e);
            }
        });
        restoreItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TrayIconSupport.this.windowRestore(app.getMainFrame());
                    }
                });
            }
        });
        hideWhenMinimizedItem.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean b = hideWhenMinimizedItem.getState();
                AppPrefs.storeProperty("minimizeToTray", b);
            }
        });
        popup.add(restoreItem);
        popup.addSeparator();
        popup.add(clipboardMonitoring);
        popup.add(quietMode);
        popup.addSeparator();
        popup.add(hideWhenMinimizedItem);
        popup.addSeparator();
        popup.add(defaultItem);
        return popup;
    }

    public synchronized void disable() {
        if (!SystemTray.isSupported()) {
            logger.log(Level.WARNING, "Cannot disable Tray icon - Tray icon is not supported on this system");
            return;
        }
        SystemTray tray = SystemTray.getSystemTray();
        tray.remove(this.trayIcon);
        MainApp app = MainApp.getInstance(MainApp.class);
        JFrame frame = app.getMainFrame();
        this.windowRestore(frame);
        frame.removeWindowFocusListener(this.windowAdapter);
        frame.removePropertyChangeListener(TITLE_PROPERTY, this);
        this.trayIcon = null;
        this.setEnabled(false);
    }

    private boolean isEnabled() {
        return this.enabled;
    }

    private void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (this.toolTip != null && this.isEnabled() && TITLE_PROPERTY.equals(evt.getPropertyName()) && this.trayIcon != null) {
            JFrame w = (JFrame)evt.getSource();
            this.trayIcon.setToolTip(w.getTitle());
        }
    }

    public void setToolTip(String toolTip) {
        this.toolTip = toolTip;
        if (this.isEnabled()) {
            this.trayIcon.setToolTip(toolTip);
        }
    }

    public void setImage(Image iconImage) {
        if (this.isEnabled()) {
            this.trayIcon.setImage(iconImage);
        }
    }
}

