/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.gui.dialogs;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.FormSpecs;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Sizes;
import com.l2fprod.common.swing.JDirectoryChooser;
import cz.vity.freerapid.core.AppPrefs;
import cz.vity.freerapid.gui.FRDUtils;
import cz.vity.freerapid.gui.content.ContentPanel;
import cz.vity.freerapid.gui.dialogs.AppFrame;
import cz.vity.freerapid.gui.dialogs.CompoundUndoManager;
import cz.vity.freerapid.model.DownloadFile;
import cz.vity.freerapid.plugins.webclient.DownloadState;
import cz.vity.freerapid.swing.ComponentFactory;
import cz.vity.freerapid.swing.Swinger;
import cz.vity.freerapid.swing.models.RecentsFilesComboModel;
import cz.vity.freerapid.utilities.FileUtils;
import cz.vity.freerapid.utilities.LogUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Frame;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.text.NumberFormat;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import org.jdesktop.application.Action;
import org.jdesktop.swinghelper.buttonpanel.JXButtonPanel;

public class MultipleSettingsDialog
extends AppFrame
implements PropertyChangeListener {
    private static final Logger logger = Logger.getLogger(MultipleSettingsDialog.class.getName());
    private final List<DownloadFile> files;
    private final DownloadFile file;
    private JLabel titleLabel;
    private JTextField fieldSize;
    private JTextArea descriptionArea;
    private JComboBox comboPath;
    private JButton btnSelectPath;
    private JButton okButton;
    private JButton cancelButton;

    public MultipleSettingsDialog(Frame owner, List<DownloadFile> files) throws Exception {
        super(owner);
        this.files = files;
        this.file = files.get(0);
        this.setName("MultipleSettingsDialog");
        try {
            this.initComponents();
            this.build();
        }
        catch (Exception e) {
            LogUtils.processException(logger, e);
            this.doClose();
            throw e;
        }
    }

    @Override
    protected AbstractButton getBtnOK() {
        return this.okButton;
    }

    @Override
    protected AbstractButton getBtnCancel() {
        return this.cancelButton;
    }

    @Action
    public void cancelBtnAction() {
        this.setResult(1);
        this.doClose();
    }

    private void build() {
        this.inject();
        this.buildGUI();
        this.buildModels();
        this.setAction(this.okButton, "okBtnAction");
        this.setAction(this.cancelButton, "cancelBtnAction");
        this.setAction(this.btnSelectPath, "btnSelectPathAction");
        this.updateInit();
    }

    private void buildModels() {
        for (DownloadFile downloadFile : this.files) {
            downloadFile.addPropertyChangeListener(this);
        }
    }

    private void buildGUI() {
        new CompoundUndoManager(this.descriptionArea);
        this.comboPath.setModel(new RecentsFilesComboModel("lastUsedSavedPaths", true));
        this.comboPath.setSelectedItem(FileUtils.getAbsolutFile(this.file.getSaveToDirectory()).toString());
        Swinger.inputFocus(this.descriptionArea);
        this.descriptionArea.setText(this.file.getDescription());
        this.fieldSize.setOpaque(false);
        this.fieldSize.setBackground(this.getBackground());
        this.fieldSize.setEditable(false);
        this.descriptionArea.setFont(this.descriptionArea.getFont().deriveFont(11.0f));
        StringBuilder builder = new StringBuilder();
        for (DownloadFile downloadFile : this.files) {
            builder.append(downloadFile.getFileName()).append("<br>");
        }
        this.titleLabel.setToolTipText(this.getResourceMap().getString("html", builder.toString()));
    }

    @Action
    public void okBtnAction() {
        if (!this.validateChanges()) {
            return;
        }
        AppPrefs.storeProperty("lastComboPath", this.comboPath.getSelectedItem().toString());
        File outputDir = new File(this.comboPath.getEditor().getItem().toString());
        File dir = FRDUtils.getAbsRelPath(outputDir);
        this.file.setSaveToDirectory(dir);
        String desc = this.descriptionArea.getText();
        for (DownloadFile downloadFile : this.files) {
            downloadFile.setSaveToDirectory(dir);
            downloadFile.setDescription(desc);
        }
        this.setResult(0);
        this.doClose();
    }

    @Override
    public void doClose() {
        for (DownloadFile downloadFile : this.files) {
            downloadFile.removePropertyChangeListener(this);
        }
        super.doClose();
        if (this.getModalResult() == 0) {
            this.comboPath.addItem(this.comboPath.getSelectedItem());
            ((RecentsFilesComboModel)this.comboPath.getModel()).setAsMRU(this.comboPath.getSelectedItem());
        }
    }

    private boolean validateChanges() {
        String dir = (String)this.comboPath.getEditor().getItem();
        if (dir == null || !new File(dir).isDirectory()) {
            Swinger.showErrorMessage(this.getResourceMap(), "noDirectoryMessage", new Object[0]);
            this.btnSelectPathAction();
            return false;
        }
        return true;
    }

    @Action
    public void btnSelectPathAction() {
        JDirectoryChooser directoryChooser = new JDirectoryChooser(this.comboPath.getEditor().getItem().toString());
        if (directoryChooser.showDialog(this, this.getResourceMap().getString("SelectDirectory", new Object[0])) != 1) {
            this.comboPath.getEditor().setItem(directoryChooser.getSelectedFile().getAbsolutePath());
            Swinger.inputFocus(this.comboPath);
        }
    }

    private void initComponents() {
        JPanel dialogPane = new JPanel();
        JPanel contentPanel = new JPanel();
        JLabel iconLabel = new JLabel();
        this.titleLabel = new JLabel();
        JLabel labelSize = new JLabel();
        this.fieldSize = new JTextField();
        JLabel labelDescription = new JLabel();
        JScrollPane scrollPane1 = new JScrollPane();
        this.descriptionArea = ComponentFactory.getTextArea();
        JPanel optionsPanel = new JPanel();
        JLabel saveToLabel = new JLabel();
        this.comboPath = new JComboBox();
        this.btnSelectPath = new JButton();
        JXButtonPanel buttonBar = new JXButtonPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        CellConstraints cc = new CellConstraints();
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        dialogPane.setBorder(Borders.DIALOG);
        dialogPane.setLayout(new BorderLayout());
        iconLabel.setName("iconLabel");
        this.titleLabel.setName("titleLabel");
        this.titleLabel.setFont(new Font("Tahoma", 1, 12));
        labelSize.setName("labelSize");
        this.fieldSize.setBorder(null);
        this.fieldSize.setOpaque(false);
        this.fieldSize.setEditable(false);
        labelDescription.setName("labelDescription");
        scrollPane1.setViewportView(this.descriptionArea);
        saveToLabel.setName("saveToLabel");
        saveToLabel.setLabelFor(this.comboPath);
        this.comboPath.setEditable(true);
        this.btnSelectPath.setName("btnSelectPath");
        PanelBuilder optionsPanelBuilder = new PanelBuilder(new FormLayout(new ColumnSpec[]{FormSpecs.DEFAULT_COLSPEC, FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, Sizes.DEFAULT, 1.0), FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC}, RowSpec.decodeSpecs("default")), optionsPanel);
        optionsPanelBuilder.add((Component)saveToLabel, cc.xy(1, 1));
        optionsPanelBuilder.add((Component)this.comboPath, cc.xy(3, 1));
        optionsPanelBuilder.add((Component)this.btnSelectPath, cc.xy(5, 1));
        PanelBuilder contentPanelBuilder = new PanelBuilder(new FormLayout(new ColumnSpec[]{new ColumnSpec(Sizes.dluX(49)), FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, Sizes.DEFAULT, 1.0), FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, ColumnSpec.decode("max(min;70dlu)")}, new RowSpec[]{FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LINE_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LINE_GAP_ROWSPEC, new RowSpec(RowSpec.TOP, Sizes.PREFERRED, 0.0), FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LINE_GAP_ROWSPEC, new RowSpec(RowSpec.FILL, Sizes.bounded(Sizes.PREFERRED, Sizes.dluY(40), Sizes.dluY(50)), 1.0), FormSpecs.LINE_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC}), contentPanel);
        contentPanelBuilder.add((Component)iconLabel, cc.xywh(1, 1, 1, 5, CellConstraints.DEFAULT, CellConstraints.FILL));
        contentPanelBuilder.add((Component)this.titleLabel, cc.xywh(3, 1, 5, 1));
        contentPanelBuilder.add((Component)labelSize, cc.xy(3, 3));
        contentPanelBuilder.add((Component)this.fieldSize, cc.xywh(5, 3, 3, 1));
        contentPanelBuilder.add((Component)labelDescription, cc.xy(1, 7));
        contentPanelBuilder.add((Component)scrollPane1, cc.xywh(1, 9, 7, 1));
        contentPanelBuilder.add((Component)optionsPanel, cc.xywh(1, 11, 7, 1));
        dialogPane.add((Component)contentPanel, "Center");
        buttonBar.setBorder(new EmptyBorder(12, 0, 0, 0));
        this.okButton.setName("okButton");
        this.cancelButton.setName("cancelButton");
        PanelBuilder buttonBarBuilder = new PanelBuilder(new FormLayout(new ColumnSpec[]{new ColumnSpec(ColumnSpec.FILL, Sizes.DEFAULT, 1.0), FormSpecs.UNRELATED_GAP_COLSPEC, ColumnSpec.decode("max(pref;42dlu)"), FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC}, RowSpec.decodeSpecs("fill:pref")), buttonBar);
        ((FormLayout)buttonBar.getLayout()).setColumnGroups(new int[][]{{3, 5}});
        buttonBarBuilder.add((Component)this.okButton, cc.xy(3, 1));
        buttonBarBuilder.add((Component)this.cancelButton, cc.xy(5, 1));
        dialogPane.add((Component)buttonBar, "South");
        contentPane.add((Component)dialogPane, "Center");
    }

    private void updateInit() {
        this.updateSize();
        this.updateState();
    }

    private void updateState() {
        this.updateEnabled();
    }

    private void updateEnabled() {
        boolean enabled = true;
        for (DownloadFile downloadFile : this.files) {
            DownloadState s = downloadFile.getState();
            if (s != DownloadState.COMPLETED && s != DownloadState.DELETED) continue;
            enabled = false;
            break;
        }
        javax.swing.Action okAction = this.getActionMap().get("okBtnAction");
        javax.swing.Action selectAction = this.getActionMap().get("btnSelectPathAction");
        okAction.setEnabled(enabled);
        selectAction.setEnabled(enabled);
        this.descriptionArea.setEditable(enabled);
        this.comboPath.setEditable(enabled);
        this.comboPath.setEnabled(enabled);
    }

    private void updateSize() {
        String value;
        long fs = 0L;
        for (DownloadFile downloadFile : this.files) {
            long fileSize = downloadFile.getFileSize();
            if (fileSize < 0L) {
                fs = -1L;
                break;
            }
            fs += fileSize;
        }
        if (fs >= 0L) {
            value = ContentPanel.bytesToAnother(fs);
            if (fs >= 1024L) {
                value = value + "  (" + NumberFormat.getIntegerInstance().format(fs) + " B)";
            }
        } else {
            value = this.getResourceMap().getString("unknown", new Object[0]);
        }
        this.fieldSize.setText(value);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("state".equals(evt.getPropertyName())) {
            this.updateState();
        } else if ("fileSize".equals(evt.getPropertyName())) {
            this.updateSize();
        }
    }
}

