/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.gui.content;

import cz.vity.freerapid.model.DownloadFile;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import org.jdesktop.application.ApplicationContext;

public class DescriptionCellRenderer
extends DefaultTableCellRenderer {
    private String tooltip;

    public DescriptionCellRenderer(ApplicationContext context) {
        this.tooltip = context.getResourceMap().getString("tooltip", new Object[0]);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        DownloadFile downloadFile = (DownloadFile)value;
        String description = downloadFile.getDescription();
        if (description == null) {
            this.setToolTipText(null);
            this.getAccessibleContext().setAccessibleName(table.getColumnName(column));
        } else {
            this.setToolTipText(String.format(this.tooltip, description));
            this.getAccessibleContext().setAccessibleName(table.getColumnName(column) + " " + description);
        }
        return super.getTableCellRendererComponent(table, description, isSelected, hasFocus, row, column);
    }
}

