/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.core;

import java.text.Collator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public final class SupportedLanguage
implements Comparable<SupportedLanguage> {
    private final String languageCode;
    private final String name;
    private final String icon;
    private final String country;
    private final Map<String, String> flags = new HashMap<String, String>(2);

    public SupportedLanguage(String languageCode, String name, String icon, String country) {
        this.languageCode = languageCode;
        this.name = name;
        this.icon = icon;
        this.country = country;
    }

    public SupportedLanguage(String selLanguageCode, String country) {
        this(selLanguageCode, "", null, country);
    }

    public final String getLanguageCode() {
        return this.languageCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SupportedLanguage that = (SupportedLanguage)o;
        return this.country.equalsIgnoreCase(that.country) && this.languageCode.equalsIgnoreCase(that.languageCode);
    }

    public int hashCode() {
        int result = this.languageCode.hashCode();
        result = 31 * result + this.country.hashCode();
        return result;
    }

    @Override
    public int compareTo(SupportedLanguage o) {
        return Collator.getInstance().compare(this.getName(), o.getName());
    }

    public final String getName() {
        return this.name;
    }

    public final String getIcon() {
        String country = Locale.getDefault().getCountry();
        if (this.flags.containsKey(country)) {
            return this.flags.get(country);
        }
        return this.icon;
    }

    public String getCountry() {
        return this.country;
    }

    public String toString() {
        return this.getLanguageCode();
    }

    public void setFlags(String flags) {
        String[] f;
        for (String s : f = flags.split("\\|")) {
            if (s.trim().isEmpty()) continue;
            String[] country = s.split("=");
            for (int i = 0; i < country.length; i += 2) {
                this.flags.put(country[i], country[i + 1]);
            }
        }
    }
}

