/*
 * Decompiled with CFR 0.152.
 */
package com.pagosoft.plaf;

import com.pagosoft.plaf.PgsLookAndFeel;
import com.pagosoft.plaf.PgsUtils;
import java.awt.Dimension;
import java.util.HashMap;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalTheme;

public class PlafOptions {
    private static boolean vistaStyle;
    private static Dimension defIconSize;
    private static boolean useExtraMargin;
    private static boolean useBoldFonts;
    private static boolean useBoldMenuFonts;
    private static boolean useShadowBorder;
    private static boolean useToolBarIcon;
    private static boolean useDisabledIcon;
    private static boolean aaText;
    private static boolean isClearBorderEnabled;
    private static boolean fixHtmlDisplay;
    private static boolean wheelTabbedPaneEnabled;
    private static boolean tabbedPaneRightClickSelectionEnabled;
    private static boolean tabReorderingEnabled;
    private static boolean paintRolloverButtonBorder;
    private static boolean officeScrollBarEnabled;
    public static final int FLAT_STYLE = 0;
    public static final int GRADIENT_STYLE = 1;
    private static int defStyle;
    public static final String MENU_ITEM = "MenuItem";
    public static final String TOOLBAR = "ToolBar";
    public static final String BUTTON = "Button";
    public static final String TOOLBARBUTTON = "ToolBarButton";
    public static final String MENUBAR = "MenuBar";
    public static final String MENUBARMENU = "MenuBarMenu";
    private static HashMap styles;
    private static boolean fastGradient;

    private PlafOptions() {
    }

    public static void setAsLookAndFeel() {
        try {
            Class.forName("com.jidesoft.utils.Lm");
            PlafOptions.enableJideFastGradient();
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        PgsLookAndFeel.setAsLookAndFeel();
    }

    public static void setCurrentTheme(MetalTheme t) {
        PgsLookAndFeel.setCurrentTheme(t);
    }

    public static void updateAllUIs() {
        PgsLookAndFeel.updateAllUIs();
    }

    public static void setDefaultMenuItemIconSize(Dimension dim) {
        defIconSize = dim;
    }

    public static Dimension getDefaultMenuItemIconSize() {
        return defIconSize;
    }

    public static boolean useExtraMargin() {
        return useExtraMargin;
    }

    public static void useExtraMargin(boolean use) {
        useExtraMargin = use;
    }

    public static boolean useBoldFonts() {
        return useBoldFonts;
    }

    public static void useBoldFonts(boolean use) {
        useBoldFonts = use;
        UIManager.put("swing.boldMetal", use);
    }

    public static boolean useBoldMenuFonts() {
        return useBoldMenuFonts;
    }

    public static void useBoldMenuFonts(boolean use) {
        useBoldMenuFonts = use;
    }

    public static void useShadowBorder(boolean use) {
        useShadowBorder = use;
    }

    public static boolean isShadowBorderUsed() {
        return useShadowBorder;
    }

    public static void useToolBarIcon(boolean use) {
        useToolBarIcon = use;
    }

    public static boolean isToolBarIconUsed() {
        return useToolBarIcon;
    }

    public static void useDisabledIcon(boolean use) {
        useDisabledIcon = use;
    }

    public static boolean isDisabledIconUsed() {
        return useDisabledIcon;
    }

    public static void setAntialiasingEnabled(boolean use) {
        aaText = use;
    }

    public static boolean isAntialiasingEnabled() {
        return aaText;
    }

    public static void setClearBorderEnabled(boolean enabled) {
        PgsUtils.regenerateBorderStroke();
        isClearBorderEnabled = enabled;
    }

    public static boolean isClearBorderEnabled() {
        return isClearBorderEnabled;
    }

    public static boolean isHtmlDisplayFixEnabled() {
        return fixHtmlDisplay;
    }

    public static void setFixHtmlDisplayEnabled(boolean aFixHtmlDisplayEnabled) {
        fixHtmlDisplay = aFixHtmlDisplayEnabled;
    }

    public static boolean isWheelTabbedPaneEnabled() {
        return wheelTabbedPaneEnabled;
    }

    public static void setWheelTabbedPaneEnabled(boolean enabled) {
        wheelTabbedPaneEnabled = enabled;
    }

    public static boolean isTabbedPaneRightClickSelectionEnabled() {
        return tabbedPaneRightClickSelectionEnabled;
    }

    public static void setTabbedPaneRightClickSelectionEnabled(boolean enabled) {
        tabbedPaneRightClickSelectionEnabled = enabled;
    }

    public static boolean isTabReorderingEnabled() {
        return tabReorderingEnabled;
    }

    public static void setTabReorderingEnabled(boolean enabled) {
        tabReorderingEnabled = enabled;
    }

    public static boolean isPaintRolloverButtonBorder() {
        return paintRolloverButtonBorder;
    }

    public static void setPaintRolloverButtonBorder(boolean paintRolloverButtonBorder) {
        PlafOptions.paintRolloverButtonBorder = paintRolloverButtonBorder;
    }

    public static boolean isOfficeScrollBarEnabled() {
        return officeScrollBarEnabled;
    }

    public static void setOfficeScrollBarEnabled(boolean officeScrollBarEnabled) {
        PlafOptions.officeScrollBarEnabled = officeScrollBarEnabled;
    }

    public static void setDefaultStyle(int s) {
        if (s != 0 && s != 1) {
            throw new IllegalArgumentException("The Style must be flat or gradient");
        }
        defStyle = s;
    }

    public static void setStyle(String key, int s) {
        if (s != 0 && s != 1) {
            throw new IllegalArgumentException("The Style must be flat or gradient");
        }
        styles.put(key, new Integer(s));
    }

    public static int getStyle(String key) {
        if (styles.containsKey(key)) {
            return (Integer)styles.get(key);
        }
        return defStyle;
    }

    public static Boolean isFlat(String key) {
        return PlafOptions.getStyle(key) == 0 ? Boolean.TRUE : Boolean.FALSE;
    }

    @Deprecated
    public static void enableJideFastGradient() {
    }

    @Deprecated
    public static boolean isJideFastGradientEnabled() {
        return fastGradient;
    }

    public static boolean isVistaStyle() {
        return vistaStyle;
    }

    public static void setVistaStyle(boolean vistaStyle) {
        PlafOptions.vistaStyle = vistaStyle;
    }

    static {
        defIconSize = new Dimension(10, 10);
        useExtraMargin = true;
        useBoldFonts = false;
        useBoldMenuFonts = false;
        useShadowBorder = false;
        useToolBarIcon = true;
        useDisabledIcon = true;
        aaText = false;
        isClearBorderEnabled = false;
        fixHtmlDisplay = false;
        wheelTabbedPaneEnabled = false;
        tabbedPaneRightClickSelectionEnabled = false;
        tabReorderingEnabled = false;
        paintRolloverButtonBorder = true;
        officeScrollBarEnabled = false;
        defStyle = 1;
        styles = new HashMap();
        PlafOptions.setStyle(MENU_ITEM, 0);
        PlafOptions.setStyle(MENUBAR, 0);
        PlafOptions.setStyle(MENUBARMENU, 0);
        PlafOptions.setStyle(TOOLBAR, 1);
        PlafOptions.setStyle(TOOLBARBUTTON, 1);
        fastGradient = false;
    }
}

