/*
 * Decompiled with CFR 0.152.
 */
package com.pagosoft.plaf;

import com.pagosoft.plaf.PgsSplitPaneDivider;
import com.pagosoft.plaf.PlafOptions;
import com.pagosoft.swing.ShadowBorder;
import java.awt.Component;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;

public class PgsSplitPaneUI
extends BasicSplitPaneUI {
    private SplitPaneContainerListener splitPaneContainerListener;
    private MyPropertyChangeHandler propertyChangeHandler;

    public static ComponentUI createUI(JComponent x) {
        return new PgsSplitPaneUI();
    }

    @Override
    public void installDefaults() {
        super.installDefaults();
        this.maybeSetShadowBorder(this.splitPane.getLeftComponent());
        this.maybeSetShadowBorder(this.splitPane.getRightComponent());
    }

    @Override
    public void uninstallDefaults() {
        super.uninstallDefaults();
        this.maybeRemoveShadowBorder(this.splitPane.getLeftComponent());
        this.maybeRemoveShadowBorder(this.splitPane.getRightComponent());
    }

    protected boolean isShadowBorder() {
        if (this.splitPane.getClientProperty("pgs.shadowBorder") != null) {
            return Boolean.TRUE.equals(this.splitPane.getClientProperty("pgs.shadowBorder"));
        }
        return PlafOptions.isShadowBorderUsed();
    }

    protected void maybeSetShadowBorder(Component c) {
        if (c instanceof JComponent && this.isShadowBorder()) {
            JComponent comp = (JComponent)c;
            comp.putClientProperty("pgs.savedBorder", comp.getBorder());
            if (comp.getBorder() instanceof BorderUIResource) {
                comp.setBorder(ShadowBorder.getInstance());
            } else {
                comp.setBorder(BorderFactory.createCompoundBorder(ShadowBorder.getInstance(), comp.getBorder()));
            }
        }
    }

    protected void maybeRemoveShadowBorder(Component c) {
        if (c instanceof JComponent && !this.isShadowBorder()) {
            ((JComponent)c).setBorder((Border)((JComponent)c).getClientProperty("pgs.savedBorder"));
        }
    }

    @Override
    public void installListeners() {
        super.installListeners();
        if (this.splitPaneContainerListener == null) {
            this.splitPaneContainerListener = new SplitPaneContainerListener();
        }
        if (this.propertyChangeHandler == null) {
            this.propertyChangeHandler = new MyPropertyChangeHandler();
        }
        this.splitPane.addContainerListener(this.splitPaneContainerListener);
        this.splitPane.addPropertyChangeListener("pgs.shadowBorder", this.propertyChangeHandler);
    }

    @Override
    public void uninstallListeners() {
        super.uninstallListeners();
        this.splitPane.removeContainerListener(this.splitPaneContainerListener);
        this.splitPane.removePropertyChangeListener("pgs.shadowBorder", this.propertyChangeHandler);
    }

    @Override
    public BasicSplitPaneDivider createDefaultDivider() {
        return new PgsSplitPaneDivider(this);
    }

    protected class MyPropertyChangeHandler
    implements PropertyChangeListener {
        protected MyPropertyChangeHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (!e.getNewValue().equals(e.getOldValue())) {
                boolean use = e.getOldValue() != null ? (Boolean)e.getOldValue() : PlafOptions.isShadowBorderUsed();
                if (use) {
                    PgsSplitPaneUI.this.maybeRemoveShadowBorder(PgsSplitPaneUI.this.splitPane.getLeftComponent());
                    PgsSplitPaneUI.this.maybeRemoveShadowBorder(PgsSplitPaneUI.this.splitPane.getRightComponent());
                }
                if (use = ((Boolean)e.getNewValue()).booleanValue()) {
                    PgsSplitPaneUI.this.maybeSetShadowBorder(PgsSplitPaneUI.this.splitPane.getLeftComponent());
                    PgsSplitPaneUI.this.maybeSetShadowBorder(PgsSplitPaneUI.this.splitPane.getRightComponent());
                }
            }
        }
    }

    protected class SplitPaneContainerListener
    implements ContainerListener {
        protected SplitPaneContainerListener() {
        }

        @Override
        public void componentAdded(ContainerEvent e) {
            PgsSplitPaneUI.this.maybeSetShadowBorder(e.getChild());
        }

        @Override
        public void componentRemoved(ContainerEvent e) {
            PgsSplitPaneUI.this.maybeRemoveShadowBorder(e.getChild());
        }
    }
}

