/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.fast;

import com.jtattoo.plaf.BaseBorders;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import com.jtattoo.plaf.fast.FastLookAndFeel;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.border.Border;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.UIResource;

public class FastBorders
extends BaseBorders {
    private static Border buttonBorder;
    private static Border toolButtonBorder;
    private static Border rolloverToolButtonBorder;
    private static Border internalFrameBorder;

    public static Border getButtonBorder() {
        if (buttonBorder == null) {
            buttonBorder = new ButtonBorder();
        }
        return buttonBorder;
    }

    public static Border getToggleButtonBorder() {
        return FastBorders.getButtonBorder();
    }

    public static Border getToolButtonBorder() {
        if (toolButtonBorder == null) {
            toolButtonBorder = new ToolButtonBorder();
        }
        return toolButtonBorder;
    }

    public static Border getRolloverToolButtonBorder() {
        if (rolloverToolButtonBorder == null) {
            rolloverToolButtonBorder = new RolloverToolButtonBorder();
        }
        return rolloverToolButtonBorder;
    }

    public static Border getInternalFrameBorder() {
        if (internalFrameBorder == null) {
            internalFrameBorder = new InternalFrameBorder();
        }
        return internalFrameBorder;
    }

    public static class InternalFrameBorder
    extends BaseBorders.BaseInternalFrameBorder {
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            boolean bl = this.isActive(component);
            boolean bl2 = this.isResizable(component);
            ColorUIResource colorUIResource = FastLookAndFeel.getFrameColor();
            ColorUIResource colorUIResource2 = FastLookAndFeel.getWindowInactiveBorderColor();
            if (bl) {
                colorUIResource2 = FastLookAndFeel.getWindowBorderColor();
            }
            Color color = ColorHelper.brighter(colorUIResource, 40.0);
            Color color2 = colorUIResource;
            if (!bl2) {
                JTattooUtilities.draw3DBorder(graphics, color, color2, n, n2, n3, n4);
                graphics.setColor(colorUIResource2);
                for (int i = 1; i < 5; ++i) {
                    graphics.drawRect(i, i, n3 - 2 * i - 1, n4 - 2 * i - 1);
                }
                return;
            }
            JTattooUtilities.draw3DBorder(graphics, color, color2, n, n2, n3, n4);
            color = ColorHelper.brighter(colorUIResource2, 40.0);
            color2 = ColorHelper.darker(colorUIResource2, 20.0);
            JTattooUtilities.draw3DBorder(graphics, color, color2, n + 1, n2 + 1, n3 - 2, n4 - 2);
            graphics.setColor(colorUIResource2);
            graphics.drawRect(n + 2, n2 + 2, n3 - 5, n4 - 5);
            graphics.drawRect(n + 3, n2 + 3, n3 - 7, n4 - 7);
            JTattooUtilities.draw3DBorder(graphics, ColorHelper.darker(colorUIResource2, 5.0), ColorHelper.brighter(colorUIResource2, 30.0), n + 4, n2 + 4, n3 - 8, n4 - 8);
        }
    }

    public static class RolloverToolButtonBorder
    implements Border,
    UIResource {
        private static final Insets insets = new Insets(1, 1, 1, 1);

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            AbstractButton abstractButton = (AbstractButton)component;
            ButtonModel buttonModel = abstractButton.getModel();
            ColorUIResource colorUIResource = FastLookAndFeel.getFrameColor();
            if (buttonModel.isEnabled()) {
                if (buttonModel.isPressed() && buttonModel.isArmed() || buttonModel.isSelected()) {
                    Graphics2D graphics2D = (Graphics2D)graphics;
                    Composite composite = graphics2D.getComposite();
                    graphics.setColor(colorUIResource);
                    graphics.drawRect(n, n2, n3 - 1, n4 - 1);
                    AlphaComposite alphaComposite = AlphaComposite.getInstance(3, 0.15f);
                    graphics2D.setComposite(alphaComposite);
                    graphics.setColor(Color.black);
                    graphics.fillRect(n + 1, n2 + 1, n3 - 2, n4 - 2);
                    graphics2D.setComposite(composite);
                } else if (buttonModel.isRollover()) {
                    Graphics2D graphics2D = (Graphics2D)graphics;
                    Composite composite = graphics2D.getComposite();
                    graphics.setColor(colorUIResource);
                    graphics.drawRect(n, n2, n3 - 1, n4 - 1);
                    AlphaComposite alphaComposite = AlphaComposite.getInstance(3, 0.4f);
                    graphics2D.setComposite(alphaComposite);
                    graphics.setColor(Color.white);
                    graphics.fillRect(n + 1, n2 + 1, n3 - 2, n4 - 2);
                    graphics2D.setComposite(composite);
                }
            }
        }

        public Insets getBorderInsets(Component component) {
            return new Insets(RolloverToolButtonBorder.insets.top, RolloverToolButtonBorder.insets.left, RolloverToolButtonBorder.insets.bottom, RolloverToolButtonBorder.insets.right);
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            insets.left = RolloverToolButtonBorder.insets.left;
            insets.top = RolloverToolButtonBorder.insets.top;
            insets.right = RolloverToolButtonBorder.insets.right;
            insets.bottom = RolloverToolButtonBorder.insets.bottom;
            return insets;
        }

        public boolean isBorderOpaque() {
            return true;
        }
    }

    public static class ToolButtonBorder
    implements Border,
    UIResource {
        private static final Insets insets = new Insets(1, 1, 1, 1);

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            AbstractButton abstractButton = (AbstractButton)component;
            ButtonModel buttonModel = abstractButton.getModel();
            Color color = ColorHelper.brighter(FastLookAndFeel.getFrameColor(), 90.0);
            ColorUIResource colorUIResource = FastLookAndFeel.getFrameColor();
            if (buttonModel.isEnabled()) {
                if (buttonModel.isPressed() && buttonModel.isArmed() || buttonModel.isSelected()) {
                    Graphics2D graphics2D = (Graphics2D)graphics;
                    Composite composite = graphics2D.getComposite();
                    graphics.setColor(colorUIResource);
                    graphics.drawRect(n, n2, n3 - 1, n4 - 1);
                    AlphaComposite alphaComposite = AlphaComposite.getInstance(3, 0.15f);
                    graphics2D.setComposite(alphaComposite);
                    graphics.setColor(Color.black);
                    graphics.fillRect(n + 1, n2 + 1, n3 - 2, n4 - 2);
                    graphics2D.setComposite(composite);
                } else {
                    JTattooUtilities.draw3DBorder(graphics, color, colorUIResource, 0, 0, n3, n4);
                }
            }
        }

        public Insets getBorderInsets(Component component) {
            return new Insets(ToolButtonBorder.insets.top, ToolButtonBorder.insets.left, ToolButtonBorder.insets.bottom, ToolButtonBorder.insets.right);
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            insets.left = ToolButtonBorder.insets.left;
            insets.top = ToolButtonBorder.insets.top;
            insets.right = ToolButtonBorder.insets.right;
            insets.bottom = ToolButtonBorder.insets.bottom;
            return insets;
        }

        public boolean isBorderOpaque() {
            return true;
        }
    }

    public static class ButtonBorder
    implements Border,
    UIResource {
        private static final Color defaultFrameColor = new Color(0, 64, 255);
        private static final Insets insets = new Insets(4, 8, 4, 8);

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            AbstractButton abstractButton = (AbstractButton)component;
            ButtonModel buttonModel = abstractButton.getModel();
            Color color = ColorHelper.darker(abstractButton.getBackground(), 30.0);
            if (buttonModel.isEnabled()) {
                JButton jButton;
                if (buttonModel.isPressed() && buttonModel.isArmed() || buttonModel.isSelected()) {
                    graphics.setColor(color);
                    graphics.drawRect(n, n2, n3 - 1, n4 - 1);
                } else {
                    graphics.setColor(color);
                    graphics.drawRect(n, n2, n3 - 1, n4 - 1);
                    graphics.setColor(ColorHelper.brighter(abstractButton.getBackground(), 40.0));
                    graphics.drawLine(n + 1, n2 + 1, n + n3 - 2, n2 + 1);
                    graphics.drawLine(n + 1, n2 + 1, n + 1, n2 + n4 - 2);
                }
                if (component instanceof JButton && (jButton = (JButton)component).equals(jButton.getRootPane().getDefaultButton())) {
                    graphics.setColor(defaultFrameColor);
                    graphics.drawRect(n, n2, n3 - 1, n4 - 1);
                }
            } else {
                graphics.setColor(FastLookAndFeel.getDisabledForegroundColor());
                graphics.drawRect(n, n2, n3 - 1, n4 - 1);
            }
        }

        public Insets getBorderInsets(Component component) {
            return new Insets(ButtonBorder.insets.top, ButtonBorder.insets.left, ButtonBorder.insets.bottom, ButtonBorder.insets.right);
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            insets.left = ButtonBorder.insets.left;
            insets.top = ButtonBorder.insets.top;
            insets.right = ButtonBorder.insets.right;
            insets.bottom = ButtonBorder.insets.bottom;
            return insets;
        }

        public boolean isBorderOpaque() {
            return true;
        }
    }
}

