/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf;

import com.jtattoo.plaf.AbstractLookAndFeel;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicFormattedTextFieldUI;

public class BaseFormattedTextFieldUI
extends BasicFormattedTextFieldUI {
    private Border orgBorder = null;
    private FocusListener focusListener = null;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BaseFormattedTextFieldUI();
    }

    protected void installListeners() {
        super.installListeners();
        if (AbstractLookAndFeel.getTheme().doShowFocusFrame()) {
            this.focusListener = new FocusListener(){

                public void focusGained(FocusEvent focusEvent) {
                    if (BaseFormattedTextFieldUI.this.getComponent() != null) {
                        BaseFormattedTextFieldUI.this.orgBorder = BaseFormattedTextFieldUI.this.getComponent().getBorder();
                        LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
                        if (lookAndFeel instanceof AbstractLookAndFeel && BaseFormattedTextFieldUI.this.orgBorder instanceof UIResource) {
                            Border border = ((AbstractLookAndFeel)lookAndFeel).getBorderFactory().getFocusFrameBorder();
                            BaseFormattedTextFieldUI.this.getComponent().setBorder(border);
                        }
                        BaseFormattedTextFieldUI.this.getComponent().invalidate();
                        BaseFormattedTextFieldUI.this.getComponent().repaint();
                    }
                }

                public void focusLost(FocusEvent focusEvent) {
                    if (BaseFormattedTextFieldUI.this.getComponent() != null) {
                        BaseFormattedTextFieldUI.this.getComponent().setBorder(BaseFormattedTextFieldUI.this.orgBorder);
                        BaseFormattedTextFieldUI.this.getComponent().invalidate();
                        BaseFormattedTextFieldUI.this.getComponent().repaint();
                    }
                }
            };
            this.getComponent().addFocusListener(this.focusListener);
        }
    }

    protected void uninstallListeners() {
        this.getComponent().removeFocusListener(this.focusListener);
        this.focusListener = null;
        super.uninstallListeners();
    }

    protected void paintBackground(Graphics graphics) {
        graphics.setColor(this.getComponent().getBackground());
        if (AbstractLookAndFeel.getTheme().doShowFocusFrame() && this.getComponent().hasFocus() && this.getComponent().isEditable()) {
            graphics.setColor(AbstractLookAndFeel.getTheme().getFocusBackgroundColor());
        }
        graphics.fillRect(0, 0, this.getComponent().getWidth(), this.getComponent().getHeight());
    }

    protected void paintSafely(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Object object = null;
        if (AbstractLookAndFeel.getTheme().isTextAntiAliasingOn()) {
            object = graphics2D.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, AbstractLookAndFeel.getTheme().getTextAntiAliasingHint());
        }
        super.paintSafely(graphics);
        if (AbstractLookAndFeel.getTheme().isTextAntiAliasingOn()) {
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, object);
        }
    }
}

