/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Hashtable;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JMenuBar;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicToolBarUI;

public abstract class AbstractToolBarUI
extends BasicToolBarUI {
    private static final String IS_ROLLOVER = "JToolBar.isRollover";
    private static final Insets BUTTON_MARGIN = new Insets(1, 1, 1, 1);
    private static final Border INNER_BORDER = BorderFactory.createEmptyBorder(2, 2, 2, 2);
    private boolean isRolloverEnabled = true;
    private MyPropertyChangeListener propertyChangeListener = null;
    private MyContainerListener containerListener = null;
    private Hashtable orgBorders = new Hashtable();
    private Hashtable orgMargins = new Hashtable();

    public abstract Border getRolloverBorder();

    public abstract Border getNonRolloverBorder();

    public abstract boolean isButtonOpaque();

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        Boolean bl = (Boolean)UIManager.get(IS_ROLLOVER);
        if (bl != null) {
            this.isRolloverEnabled = bl;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                AbstractToolBarUI.this.changeBorders();
            }
        });
    }

    public void uninstallUI(JComponent jComponent) {
        this.restoreBorders();
        super.uninstallUI(jComponent);
    }

    protected void installListeners() {
        super.installListeners();
        this.propertyChangeListener = new MyPropertyChangeListener();
        if (this.propertyChangeListener != null) {
            this.toolBar.addPropertyChangeListener(this.propertyChangeListener);
        }
        this.containerListener = new MyContainerListener();
        if (this.containerListener != null) {
            this.toolBar.addContainerListener(this.containerListener);
        }
    }

    protected void uninstallListeners() {
        if (this.propertyChangeListener != null) {
            this.toolBar.removePropertyChangeListener(this.propertyChangeListener);
        }
        this.propertyChangeListener = null;
        if (this.containerListener != null) {
            this.toolBar.removeContainerListener(this.containerListener);
        }
        this.containerListener = null;
        super.uninstallListeners();
    }

    protected void setBorderToNormal(Component component) {
    }

    protected void setBorderToRollover(Component component) {
    }

    protected void setBorderToNonRollover(Component component) {
    }

    protected void changeBorders() {
        Component[] componentArray = this.toolBar.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            Component component = componentArray[i];
            if (!(component instanceof AbstractButton)) continue;
            this.changeButtonBorder((AbstractButton)component);
        }
    }

    protected void restoreBorders() {
        Component[] componentArray = this.toolBar.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            Component component = componentArray[i];
            if (!(component instanceof AbstractButton)) continue;
            this.restoreButtonBorder((AbstractButton)component);
        }
    }

    protected void changeButtonBorder(AbstractButton abstractButton) {
        Boolean bl;
        Object object = abstractButton.getClientProperty("paintToolBarBorder");
        if (object != null && object instanceof Boolean && !(bl = (Boolean)object).booleanValue()) {
            return;
        }
        if (!this.orgBorders.contains(abstractButton)) {
            if (abstractButton.getBorder() != null) {
                this.orgBorders.put(abstractButton, abstractButton.getBorder());
            } else {
                this.orgBorders.put(abstractButton, new NullBorder());
            }
        }
        if (!this.orgMargins.contains(abstractButton)) {
            this.orgMargins.put(abstractButton, abstractButton.getMargin());
        }
        if (abstractButton.getBorder() != null) {
            if (this.isRolloverEnabled) {
                abstractButton.setBorderPainted(true);
                abstractButton.setBorder(BorderFactory.createCompoundBorder(this.getRolloverBorder(), INNER_BORDER));
                abstractButton.setMargin(BUTTON_MARGIN);
                abstractButton.setRolloverEnabled(true);
                abstractButton.setOpaque(this.isButtonOpaque());
                abstractButton.setContentAreaFilled(this.isButtonOpaque());
            } else {
                abstractButton.setBorder(BorderFactory.createCompoundBorder(this.getNonRolloverBorder(), INNER_BORDER));
                abstractButton.setMargin(BUTTON_MARGIN);
                abstractButton.setRolloverEnabled(false);
                abstractButton.setOpaque(this.isButtonOpaque());
                abstractButton.setContentAreaFilled(this.isButtonOpaque());
            }
        }
    }

    protected void restoreButtonBorder(AbstractButton abstractButton) {
        Object object;
        Object object2 = abstractButton.getClientProperty("paintToolBarBorder");
        if (object2 != null && object2 instanceof Boolean && !((Boolean)(object = (Boolean)object2)).booleanValue()) {
            return;
        }
        object = (Border)this.orgBorders.get(abstractButton);
        if (object != null) {
            if (object instanceof NullBorder) {
                abstractButton.setBorder(null);
            } else {
                abstractButton.setBorder((Border)object);
            }
        }
        abstractButton.setMargin((Insets)this.orgMargins.get(abstractButton));
    }

    protected void updateToolbarBorder() {
        this.toolBar.revalidate();
        this.toolBar.repaint();
    }

    protected boolean isToolBarUnderMenubar() {
        JRootPane jRootPane;
        JMenuBar jMenuBar;
        if (this.toolBar != null && this.toolBar.getOrientation() == 0 && (jMenuBar = (jRootPane = SwingUtilities.getRootPane(this.toolBar)).getJMenuBar()) != null) {
            Point point = new Point(0, 0);
            point = SwingUtilities.convertPoint(jMenuBar, point, jRootPane);
            Point point2 = new Point(0, 0);
            point2 = SwingUtilities.convertPoint(this.toolBar, point2, jRootPane);
            point2.y -= jMenuBar.getHeight() - 1;
            Rectangle rectangle = new Rectangle(point, jMenuBar.getSize());
            return rectangle.contains(point2);
        }
        return false;
    }

    private static class NullBorder
    implements Border,
    UIResource {
        private static final Insets insets = new Insets(0, 0, 0, 0);

        private NullBorder() {
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        }

        public Insets getBorderInsets(Component component) {
            return insets;
        }

        public boolean isBorderOpaque() {
            return true;
        }
    }

    protected class MyContainerListener
    implements ContainerListener {
        protected MyContainerListener() {
        }

        public void componentAdded(ContainerEvent containerEvent) {
            Component component = containerEvent.getChild();
            if (component instanceof AbstractButton) {
                AbstractToolBarUI.this.changeButtonBorder((AbstractButton)component);
            }
        }

        public void componentRemoved(ContainerEvent containerEvent) {
            Component component = containerEvent.getChild();
            if (component instanceof AbstractButton) {
                AbstractToolBarUI.this.restoreButtonBorder((AbstractButton)component);
            }
        }
    }

    protected class MyPropertyChangeListener
    implements PropertyChangeListener {
        protected MyPropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals(AbstractToolBarUI.IS_ROLLOVER)) {
                if (propertyChangeEvent.getNewValue() != null) {
                    AbstractToolBarUI.this.isRolloverEnabled = (Boolean)propertyChangeEvent.getNewValue();
                    AbstractToolBarUI.this.changeBorders();
                }
            } else if ("componentOrientation".equals(propertyChangeEvent.getPropertyName())) {
                AbstractToolBarUI.this.updateToolbarBorder();
            }
        }
    }
}

