/*
 * Decompiled with CFR 0.152.
 */
package jlibs.xml.sax.binding.impl.processor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import java.util.StringTokenizer;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.xml.namespace.QName;
import jlibs.core.annotation.processing.AnnotationError;
import jlibs.xml.sax.binding.impl.Registry;
import jlibs.xml.sax.binding.impl.processor.BindingRelation;
import jlibs.xml.sax.binding.impl.processor.Namespaces;
import jlibs.xml.sax.binding.impl.processor.Relation;

class Binding {
    int id;
    ExecutableElement startMethod;
    ExecutableElement textMethod;
    ExecutableElement finishMethod;
    TypeElement element;
    Map<QName, BindingRelation> registry = new LinkedHashMap<QName, BindingRelation>();
    public Map<Integer, List<QName>> idMap = new HashMap<Integer, List<QName>>();

    Binding() {
    }

    Binding getBinding(ExecutableElement method, AnnotationMirror mirror, String xpath) {
        if (xpath.length() == 0) {
            return this;
        }
        return this.getBindingRelation((ExecutableElement)method, (AnnotationMirror)mirror, (String)xpath).binding;
    }

    Relation getRelation(ExecutableElement method, AnnotationMirror mirror, String xpath) {
        return this.getBindingRelation((ExecutableElement)method, (AnnotationMirror)mirror, (String)xpath).relation;
    }

    BindingRelation getBindingRelation(ExecutableElement method, AnnotationMirror mirror, String xpath) {
        Binding binding = this;
        BindingRelation bindingRelation = null;
        StringTokenizer stok = new StringTokenizer(xpath, "/");
        Map<QName, BindingRelation> registry = binding.registry;
        while (stok.hasMoreTokens()) {
            String token = stok.nextToken();
            QName qname = Binding.toQName(method, mirror, token);
            bindingRelation = registry.get(qname);
            if (bindingRelation == null) {
                registry.put(qname, new BindingRelation());
                bindingRelation = registry.get(qname);
            }
            registry = bindingRelation.binding.registry;
        }
        return bindingRelation;
    }

    public void handleStar() {
        BindingRelation startBindingRelation = this.registry.get(Registry.ANY);
        if (startBindingRelation != null) {
            for (BindingRelation bindingRelation : this.registry.values()) {
                if (bindingRelation.relation.startedMethod == null) {
                    bindingRelation.relation.startedMethod = startBindingRelation.relation.startedMethod;
                }
                if (bindingRelation.relation.finishedMethod != null) continue;
                bindingRelation.relation.finishedMethod = startBindingRelation.relation.finishedMethod;
            }
        }
    }

    public void initID(int id) {
        this.initID(id, this.idMap, new Stack<QName>());
    }

    private int initID(int id, Map<Integer, List<QName>> idMap, Stack<QName> path) {
        this.id = id;
        idMap.put(id, new ArrayList<QName>(path));
        for (Map.Entry<QName, BindingRelation> entry : this.registry.entrySet()) {
            path.push(entry.getKey());
            ++id;
            id = entry.getValue().binding.initID(id, idMap, path);
            path.pop();
        }
        return id;
    }

    static QName toQName(Element pos1, AnnotationMirror pos2, String token) {
        String uri;
        String localName;
        String prefix;
        if (token.equals("*")) {
            return Registry.ANY;
        }
        Properties nsContext = Namespaces.get(pos1);
        int colon = token.indexOf(58);
        if (colon == -1) {
            prefix = "";
            localName = token;
        } else {
            prefix = token.substring(0, colon);
            localName = token.substring(colon + 1);
        }
        String string = uri = prefix.equals("*") ? prefix : nsContext.getProperty(prefix);
        if (uri == null) {
            throw new AnnotationError(pos1, pos2, "no namespace mapping found for prefix " + prefix);
        }
        return new QName(uri, localName);
    }

    static String toJava(QName qname) {
        if (qname == null) {
            return null;
        }
        if (qname.getNamespaceURI().length() == 0) {
            return "new QName(\"" + qname.getLocalPart() + "\")";
        }
        return "new QName(\"" + qname.getNamespaceURI() + "\", \"" + qname.getLocalPart() + "\")";
    }
}

