/*
 * Decompiled with CFR 0.152.
 */
package jlibs.xml.sax.async;

import java.util.Arrays;
import jlibs.xml.sax.SAXDelegate;
import jlibs.xml.sax.async.AsyncXMLReader;
import jlibs.xml.sax.async.Attributes;
import jlibs.xml.sax.async.Namespaces;
import jlibs.xml.sax.async.QName;
import org.xml.sax.SAXException;

class Elements {
    private final AsyncXMLReader reader;
    private final SAXDelegate handler;
    private final Namespaces namespaces;
    private final Attributes attributes;
    private QName[] qnameStack = new QName[15];
    private String[] uriStack = new String[15];
    int free = 0;
    int freeLock = 0;

    public Elements(AsyncXMLReader reader, SAXDelegate handler, Namespaces namespaces, Attributes attributes) {
        this.reader = reader;
        this.handler = handler;
        this.namespaces = namespaces;
        this.attributes = attributes;
    }

    public void reset() {
        this.freeLock = 0;
        this.free = 0;
    }

    public char[] currentElementNameAsCharArray() {
        return this.qnameStack[this.free - 1].chars;
    }

    public String currentElementName() {
        return this.qnameStack[this.free - 1].name;
    }

    public void push1(QName qname) {
        if (this.free == this.qnameStack.length) {
            this.qnameStack = Arrays.copyOf(this.qnameStack, this.free * 2);
            this.uriStack = Arrays.copyOf(this.uriStack, this.free * 2);
        }
        this.qnameStack[this.free++] = qname;
        this.namespaces.push();
        this.attributes.reset();
    }

    public void push2() throws SAXException {
        String uri;
        QName bucket = this.qnameStack[this.free - 1];
        String error = this.attributes.fixAttributes(bucket.name);
        if (error != null) {
            this.reader.fatalError(error);
        }
        if ((uri = this.namespaces.getNamespaceURI(bucket.prefix)) == null) {
            this.reader.fatalError("Unbound prefix: " + bucket.prefix);
        }
        this.uriStack[this.free - 1] = uri;
        this.handler.startElement(uri, bucket.localName, bucket.name, this.attributes.get());
    }

    public boolean pop() throws SAXException {
        if (this.free == this.freeLock) {
            this.reader.fatalError("The element \"" + this.currentElementName() + "\" must start and end within the same entity");
        }
        QName qname = this.qnameStack[this.free - 1];
        this.handler.endElement(this.uriStack[this.free - 1], qname.localName, qname.name);
        --this.free;
        this.namespaces.pop();
        return this.free == 0;
    }
}

