/*
 * Decompiled with CFR 0.152.
 */
package org.java.plugin.registry.xml;

import org.java.plugin.registry.MatchingRule;
import org.java.plugin.registry.xml.BaseHandler;
import org.java.plugin.registry.xml.ModelManifestInfo;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;

final class ManifestInfoHandler
extends BaseHandler {
    private ModelManifestInfo manifest = null;

    ManifestInfoHandler(EntityResolver anEntityResolver) {
        super(anEntityResolver);
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        String name;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("startElement - [" + uri + "]/[" + localName + "]/[" + qName + "]"));
        }
        if ("plugin".equals(name = qName)) {
            if (this.manifest != null) {
                throw new SAXException("unexpected [" + name + "] element (manifest already defined)");
            }
            this.manifest = new ModelManifestInfo();
            this.manifest.setId(attributes.getValue("id"));
            this.manifest.setVersion(attributes.getValue("version"));
            this.manifest.setVendor(attributes.getValue("vendor"));
        } else if ("plugin-fragment".equals(name)) {
            if (this.manifest != null) {
                throw new SAXException("unexpected [" + name + "] element (manifest already defined)");
            }
            this.manifest = new ModelManifestInfo();
            this.manifest.setId(attributes.getValue("id"));
            this.manifest.setVersion(attributes.getValue("version"));
            this.manifest.setVendor(attributes.getValue("vendor"));
            this.manifest.setPluginId(attributes.getValue("plugin-id"));
            if (attributes.getValue("plugin-version") != null) {
                this.manifest.setPluginVersion(attributes.getValue("plugin-version"));
            }
            if (attributes.getValue("match") != null) {
                this.manifest.setMatchingRule(MatchingRule.fromCode(attributes.getValue("match")));
            } else {
                this.manifest.setMatchingRule(MatchingRule.COMPATIBLE);
            }
        }
    }

    public void endElement(String uri, String localName, String qName) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("endElement - [" + uri + "]/[" + localName + "]/[" + qName + "]"));
        }
    }

    public void characters(char[] ch, int start, int length) {
    }

    ModelManifestInfo getResult() {
        return this.manifest;
    }
}

