/*
 * Decompiled with CFR 0.152.
 */
package org.java.plugin;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.java.plugin.PathResolver;
import org.java.plugin.PluginManager;
import org.java.plugin.registry.PluginRegistry;
import org.java.plugin.standard.StandardObjectFactory;
import org.java.plugin.util.ExtendedProperties;
import org.java.plugin.util.IoUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ObjectFactory {
    public static ObjectFactory newInstance() {
        return ObjectFactory.newInstance(null);
    }

    public static ObjectFactory newInstance(ExtendedProperties config) {
        ObjectFactory result;
        Log log = LogFactory.getLog(ObjectFactory.class);
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = ObjectFactory.class.getClassLoader();
        }
        ExtendedProperties props = config != null ? config : ObjectFactory.loadProperties(cl);
        String className = ObjectFactory.findProperty(cl, props);
        try {
            if (className == null) {
                className = "org.java.plugin.standard.StandardObjectFactory";
            }
            result = (ObjectFactory)ObjectFactory.loadClass(cl, className).newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            log.fatal((Object)("failed instantiating object factory " + className), (Throwable)cnfe);
            throw new Error("failed instantiating object factory " + className, cnfe);
        }
        catch (IllegalAccessException iae) {
            log.fatal((Object)("failed instantiating object factory " + className), (Throwable)iae);
            throw new Error("failed instantiating object factory " + className, iae);
        }
        catch (SecurityException se) {
            log.fatal((Object)("failed instantiating object factory " + className), (Throwable)se);
            throw new Error("failed instantiating object factory " + className, se);
        }
        catch (InstantiationException ie) {
            log.fatal((Object)("failed instantiating object factory " + className), (Throwable)ie);
            throw new Error("failed instantiating object factory " + className, ie);
        }
        result.configure(props);
        log.debug((Object)("object factory instance created - " + result));
        return result;
    }

    private static Class<?> loadClass(ClassLoader cl, String className) throws ClassNotFoundException {
        ClassLoader cl2;
        if (cl != null) {
            try {
                return cl.loadClass(className);
            }
            catch (ClassNotFoundException cnfe) {
                // empty catch block
            }
        }
        if ((cl2 = ObjectFactory.class.getClassLoader()) != null) {
            try {
                return cl2.loadClass(className);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return ClassLoader.getSystemClassLoader().loadClass(className);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ExtendedProperties loadProperties(ClassLoader cl) {
        ExtendedProperties extendedProperties;
        Log log = LogFactory.getLog(ObjectFactory.class);
        File file = new File(System.getProperty("java.home") + File.separator + "lib" + File.separator + "jpf.properties");
        URL url = null;
        if (file.canRead()) {
            try {
                url = IoUtil.file2url(file);
            }
            catch (MalformedURLException mue) {
                log.error((Object)("failed converting file " + file + " to URL"), (Throwable)mue);
            }
        }
        if (url == null) {
            if (cl != null) {
                url = cl.getResource("jpf.properties");
                if (url == null) {
                    url = ClassLoader.getSystemResource("jpf.properties");
                }
            } else {
                url = ClassLoader.getSystemResource("jpf.properties");
            }
            if (url == null) {
                log.debug((Object)("no jpf.properties file found in ${java.home}/lib (" + file + ") nor in CLASSPATH, using standard properties"));
                url = StandardObjectFactory.class.getResource("jpf.properties");
            }
        }
        InputStream strm = IoUtil.getResourceInputStream(url);
        try {
            ExtendedProperties props = new ExtendedProperties();
            props.load(strm);
            log.debug((Object)("loaded jpf.properties from " + url));
            extendedProperties = props;
        }
        catch (Throwable throwable) {
            try {
                try {
                    strm.close();
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                throw throwable;
            }
            catch (Exception e) {
                log.error((Object)"failed loading jpf.properties from CLASSPATH", (Throwable)e);
                return null;
            }
        }
        try {
            strm.close();
        }
        catch (IOException ioe) {
            // empty catch block
        }
        return extendedProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String findProperty(ClassLoader cl, ExtendedProperties props) {
        Log log = LogFactory.getLog(ObjectFactory.class);
        String name = ObjectFactory.class.getName();
        String result = System.getProperty(name);
        if (result != null) {
            log.debug((Object)("property " + name + " found as system property"));
            return result;
        }
        if (props != null && (result = props.getProperty(name)) != null) {
            log.debug((Object)("property " + name + " found in properties file"));
            return result;
        }
        String serviceId = "META-INF/services/" + ObjectFactory.class.getName();
        InputStream strm = cl == null ? ClassLoader.getSystemResourceAsStream(serviceId) : cl.getResourceAsStream(serviceId);
        if (strm != null) {
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(strm, "UTF-8"));
                try {
                    result = reader.readLine();
                }
                finally {
                    try {
                        reader.close();
                    }
                    catch (IOException ioe) {}
                }
            }
            catch (IOException ioe) {
                try {
                    strm.close();
                }
                catch (IOException ioe2) {
                    // empty catch block
                }
            }
        }
        if (result != null) {
            log.debug((Object)("property " + name + " found as service"));
            return result;
        }
        log.debug((Object)("no property " + name + " found"));
        return result;
    }

    protected abstract void configure(ExtendedProperties var1);

    public final PluginManager createManager() {
        return this.createManager(this.createRegistry(), this.createPathResolver());
    }

    public abstract PluginManager createManager(PluginRegistry var1, PathResolver var2);

    public abstract PluginRegistry createRegistry();

    public abstract PathResolver createPathResolver();
}

