/*
 * Decompiled with CFR 0.152.
 */
package net.sf.portecle;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class NetUtil {
    private static final Logger LOG = Logger.getLogger(NetUtil.class.getCanonicalName());
    private static final int CONNECT_TIMEOUT = 10000;
    private static final int READ_TIMEOUT = 20000;

    private NetUtil() {
    }

    public static InputStream openGetStream(URL uRL) throws IOException {
        URLConnection uRLConnection = uRL.openConnection();
        uRLConnection.setConnectTimeout(10000);
        uRLConnection.setReadTimeout(20000);
        return uRLConnection.getInputStream();
    }

    public static InputStream openPostStream(URL uRL, byte[] byArray, String string) throws IOException {
        URLConnection uRLConnection = uRL.openConnection();
        uRLConnection.setDoOutput(true);
        uRLConnection.setConnectTimeout(10000);
        uRLConnection.setReadTimeout(20000);
        if (string != null) {
            uRLConnection.setRequestProperty("Content-Type", string);
        }
        uRLConnection.setRequestProperty("Content-Length", String.valueOf(byArray.length));
        try (OutputStream outputStream = uRLConnection.getOutputStream();){
            outputStream.write(byArray);
        }
        return uRLConnection.getInputStream();
    }

    public static URL download(URL uRL) throws IOException {
        if ("file".equals(uRL.getProtocol())) {
            return uRL;
        }
        File file = null;
        try (InputStream inputStream = NetUtil.openGetStream(uRL);){
            file = File.createTempFile("portecle", null);
            try (BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));){
                int n;
                byte[] byArray = new byte[2048];
                while ((n = inputStream.read(byArray)) != -1) {
                    ((OutputStream)bufferedOutputStream).write(byArray, 0, n);
                }
            }
        }
        catch (IOException iOException) {
            if (file != null && !file.delete()) {
                LOG.log(Level.WARNING, "Could not delete temporary file " + file);
            }
            throw iOException;
        }
        file.deleteOnExit();
        return file.toURI().toURL();
    }

    static URL toURL(Object object) throws MalformedURLException {
        if (object instanceof File) {
            return ((File)object).toURI().toURL();
        }
        if (object instanceof URI) {
            return ((URI)object).toURL();
        }
        return (URL)object;
    }
}

