/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.graph.querybuilder;

import java.awt.Component;
import java.util.Arrays;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.plugins.graph.querybuilder.OrderCol;
import net.sourceforge.squirrel_sql.plugins.graph.querybuilder.SortedColumnsTableModel;
import net.sourceforge.squirrel_sql.plugins.graph.xmlbeans.OrderStructureXmlBean;

public class QueryOrderTableModel
extends SortedColumnsTableModel<OrderCol> {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(QueryOrderTableModel.class);
    private DefaultTableColumnModel _colModel = new DefaultTableColumnModel();

    public QueryOrderTableModel(OrderStructureXmlBean orderStructure) {
        TableColumn col = new TableColumn(0);
        col.setHeaderValue(s_stringMgr.getString("graph.QueryOrderTableModel.Column"));
        col.setPreferredWidth(250);
        this._colModel.addColumn(col);
        col = new TableColumn(1);
        col.setHeaderValue(s_stringMgr.getString("graph.QueryOrderTableModel.Descending"));
        final JCheckBox rendererCheckBox = new JCheckBox();
        DefaultTableCellRenderer cellRenderer = new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                rendererCheckBox.setSelected((Boolean)value);
                return rendererCheckBox;
            }
        };
        col.setCellRenderer(cellRenderer);
        this._colModel.addColumn(col);
        if (null != orderStructure) {
            this.addCols(Arrays.asList(orderStructure.getOrderCols()));
        }
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (0 == column) {
            return ((OrderCol)this.getSortedCol(row)).getQualifiedCol();
        }
        return ((OrderCol)this.getSortedCol(row)).isDescending();
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    protected void updateCol(OrderCol toBeUpdated, OrderCol update) {
        toBeUpdated.setDescending(update.isDescending());
        toBeUpdated.setAggregated(update.isAggregated());
    }

    @Override
    public TableColumnModel getColumnModel() {
        return this._colModel;
    }
}

