/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.gui.builders.UIFactory;
import net.sourceforge.squirrel_sql.client.session.ISQLEntryPanel;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.SQLExecutionInfo;
import net.sourceforge.squirrel_sql.client.session.action.CloseAllSQLResultTabsAction;
import net.sourceforge.squirrel_sql.client.session.action.CloseAllSQLResultTabsButCurrentAction;
import net.sourceforge.squirrel_sql.client.session.action.CloseAllSQLResultTabsToLeftAction;
import net.sourceforge.squirrel_sql.client.session.action.CloseAllSQLResultTabsToRightAction;
import net.sourceforge.squirrel_sql.client.session.action.CloseCurrentSQLResultTabAction;
import net.sourceforge.squirrel_sql.client.session.action.ToggleCurrentSQLResultTabAnchoredAction;
import net.sourceforge.squirrel_sql.client.session.action.ToggleCurrentSQLResultTabStickyAction;
import net.sourceforge.squirrel_sql.client.session.event.ISQLExecutionListener;
import net.sourceforge.squirrel_sql.client.session.mainpanel.CancelPanel;
import net.sourceforge.squirrel_sql.client.session.mainpanel.CancelPanelCtrl;
import net.sourceforge.squirrel_sql.client.session.mainpanel.ErrorPanel;
import net.sourceforge.squirrel_sql.client.session.mainpanel.IResultTab;
import net.sourceforge.squirrel_sql.client.session.mainpanel.ISQLExecutionHandlerListener;
import net.sourceforge.squirrel_sql.client.session.mainpanel.ISQLResultExecuter;
import net.sourceforge.squirrel_sql.client.session.mainpanel.ResultFrame;
import net.sourceforge.squirrel_sql.client.session.mainpanel.ResultFrameListener;
import net.sourceforge.squirrel_sql.client.session.mainpanel.ResultTab;
import net.sourceforge.squirrel_sql.client.session.mainpanel.ResultTabClosing;
import net.sourceforge.squirrel_sql.client.session.mainpanel.ResultTabFactory;
import net.sourceforge.squirrel_sql.client.session.mainpanel.SQLExecutionHandler;
import net.sourceforge.squirrel_sql.client.session.mainpanel.SQLResultExecuterPanelFacade;
import net.sourceforge.squirrel_sql.client.session.mainpanel.TabIconManager;
import net.sourceforge.squirrel_sql.client.session.mainpanel.TabbedExcutionPanelUtil;
import net.sourceforge.squirrel_sql.client.session.properties.SessionProperties;
import net.sourceforge.squirrel_sql.fw.datasetviewer.IDataSetUpdateableTableModel;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ResultSetDataSet;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ResultSetMetaDataDataSet;
import net.sourceforge.squirrel_sql.fw.datasetviewer.TableState;
import net.sourceforge.squirrel_sql.fw.datasetviewer.coloring.markduplicates.MarkDuplicatesChooserController;
import net.sourceforge.squirrel_sql.fw.sql.ISQLConnection;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class SQLResultExecuterPanel
extends JPanel
implements ISQLResultExecuter {
    private static final ILogger s_log = LoggerController.createLogger(SQLResultExecuterPanel.class);
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(SQLResultExecuterPanel.class);
    private ISession _session;
    private MyPropertiesListener _propsListener;
    private JTabbedPane _tabbedExecutionsPanel;
    private ArrayList<ResultFrame> _sqlResultFrames = new ArrayList();
    private EventListenerList _listeners = new EventListenerList();
    private ResultTabFactory _resultTabFactory;
    private IResultTab _stickyTab;
    private TabIconManager _tabIconManager = new TabIconManager();
    private final ResultTabClosing _resultTabClosing;

    public SQLResultExecuterPanel(ISession session) {
        this._resultTabFactory = new ResultTabFactory(session, this.createSQLResultExecuterPanelFacade());
        this.setSession(session);
        this.createGUI();
        this.propertiesHaveChanged(null);
        this._resultTabClosing = new ResultTabClosing(this._tabIconManager, this._tabbedExecutionsPanel);
    }

    private SQLResultExecuterPanelFacade createSQLResultExecuterPanelFacade() {
        return new SQLResultExecuterPanelFacade(){

            @Override
            public void closeResultTab(IResultTab resultTab) {
                SQLResultExecuterPanel.this._resultTabClosing.closeTab(resultTab.getCompleteResultTab());
            }

            @Override
            public void returnToTabbedPane(ResultTab resultTab) {
                SQLResultExecuterPanel.this.returnToTabbedPane(resultTab);
            }

            @Override
            public void createSQLResultFrame(IResultTab resultTab) {
                SQLResultExecuterPanel.this.createSQLResultFrame(resultTab);
            }

            @Override
            public void rerunSQL(String sql, IResultTab resultTab) {
                SQLResultExecuterPanel.this.rerunSQL(sql, resultTab);
            }

            @Override
            public void removeErrorPanel(ErrorPanel errorPanel) {
                SQLResultExecuterPanel.this.removeErrorPanel(errorPanel);
            }
        };
    }

    @Override
    public String getTitle() {
        return s_stringMgr.getString("SQLResultExecuterPanel.title");
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    public synchronized void setSession(ISession session) {
        if (session == null) {
            throw new IllegalArgumentException("Null ISession passed");
        }
        this.sessionClosing();
        this._session = session;
        this._propsListener = new MyPropertiesListener();
        this._session.getProperties().addPropertyChangeListener(this._propsListener);
    }

    public ISession getSession() {
        return this._session;
    }

    public synchronized void addSQLExecutionListener(ISQLExecutionListener lis) {
        if (lis == null) {
            throw new IllegalArgumentException("ISQLExecutionListener == null");
        }
        this._listeners.add(ISQLExecutionListener.class, lis);
    }

    public synchronized void removeSQLExecutionListener(ISQLExecutionListener lis) {
        if (lis == null) {
            throw new IllegalArgumentException("ISQLExecutionListener == null");
        }
        this._listeners.remove(ISQLExecutionListener.class, lis);
    }

    @Override
    public void execute(ISQLEntryPanel sqlPanel, ISQLResultExecuter.ExecutionScope executionScope) {
        this.removeErrorPanels();
        String sql = ISQLResultExecuter.ExecutionScope.EXEC_CURRENT_SQL == executionScope ? sqlPanel.getSQLToBeExecuted() : sqlPanel.getText();
        if (sql != null && sql.length() > 0) {
            this.executeSQL(sql);
        } else {
            String msg = s_stringMgr.getString("SQLResultExecuterPanel.nosqlselected");
            this._session.showErrorMessage(msg);
        }
    }

    private void removeErrorPanels() {
        ArrayList<ErrorPanel> toRemove = new ArrayList<ErrorPanel>();
        for (int i = 0; i < this._tabbedExecutionsPanel.getTabCount(); ++i) {
            Component tab = this._tabbedExecutionsPanel.getComponentAt(i);
            if (!(tab instanceof ErrorPanel)) continue;
            toRemove.add((ErrorPanel)tab);
        }
        for (ErrorPanel errorPanel : toRemove) {
            this._resultTabClosing.closeTab(errorPanel);
        }
    }

    public void executeSQL(String sql) {
        this.executeSQL(sql, null);
    }

    public void executeSQL(String sql, String tableToBeEdited) {
        if (sql != null && sql.trim().length() > 0) {
            this.removeErrorPanels();
            String origSQL = sql;
            sql = this.fireSQLToBeExecutedEvent(sql);
            if (sql == null) {
                s_log.info("executeSQL: An ISQLExecutionListener veto'd execution of the following SQL: " + origSQL);
                return;
            }
            ISQLExecutionListener[] executionListeners = (ISQLExecutionListener[])this._listeners.getListeners(ISQLExecutionListener.class);
            new SQLExecutionHandler(null, this._session, sql, this.createSQLExecutionHandlerListener(), executionListeners, tableToBeEdited);
        }
    }

    private ISQLExecutionHandlerListener createSQLExecutionHandlerListener() {
        return new ISQLExecutionHandlerListener(){

            @Override
            public void addResultsTab(SQLExecutionInfo info, ResultSetDataSet rsds, ResultSetMetaDataDataSet rsmdds, IDataSetUpdateableTableModel model, IResultTab resultTabToReplace) {
                SQLResultExecuterPanel.this.onAddResultsTab(info, rsds, rsmdds, model, resultTabToReplace);
            }

            @Override
            public void removeCancelPanel(CancelPanelCtrl cancelPanelCtrl, IResultTab resultTabToReplace) {
                SQLResultExecuterPanel.this.onRemoveCancelPanel(cancelPanelCtrl, resultTabToReplace);
            }

            @Override
            public void setCancelPanel(CancelPanelCtrl cancelPanelCtrl) {
                SQLResultExecuterPanel.this.onSetCancelPanel(cancelPanelCtrl);
            }

            @Override
            public void displayErrors(ArrayList<String> sqlExecErrorMsgs, String lastExecutedStatement) {
                SQLResultExecuterPanel.this.onDisplayErrors(sqlExecErrorMsgs, lastExecutedStatement);
            }
        };
    }

    private void onDisplayErrors(final ArrayList<String> sqlExecErrorMsgs, final String lastExecutedStatement) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                SQLResultExecuterPanel.this.showErrorPanel(sqlExecErrorMsgs, lastExecutedStatement);
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    private void showErrorPanel(ArrayList<String> sqlExecErrorMsgs, String lastExecutedStatement) {
        ErrorPanel errorPanel = this._resultTabFactory.createErrorPanel(sqlExecErrorMsgs, lastExecutedStatement);
        this._tabbedExecutionsPanel.add(s_stringMgr.getString("SQLResultExecuterPanel.ErrorTabHeader"), errorPanel);
        this._tabbedExecutionsPanel.setSelectedComponent(errorPanel);
    }

    private void removeErrorPanel(ErrorPanel errorPanel) {
        this._tabbedExecutionsPanel.remove(errorPanel);
    }

    private void rerunSQL(String sql, IResultTab resultTabToReplace) {
        new SQLExecutionHandler(resultTabToReplace, this._session, sql, this.createSQLExecutionHandlerListener(), new ISQLExecutionListener[0]);
    }

    public void closeAllSQLResultFrames() {
        for (ResultFrame sqlResultFrame : this._sqlResultFrames) {
            sqlResultFrame.dispose();
        }
    }

    public void closeAllSQLResultTabs() {
        this.closeAllSQLResultTabs(false);
    }

    public void closeAllSQLResultTabs(boolean isMemoryCleanUp) {
        ArrayList<JComponent> allTabs = this.getAllTabs();
        this._resultTabClosing.closeTabs(allTabs, isMemoryCleanUp);
    }

    private ArrayList<JComponent> getAllTabs() {
        ArrayList<JComponent> allTabs = new ArrayList<JComponent>();
        for (int i = 0; i < this._tabbedExecutionsPanel.getTabCount(); ++i) {
            JComponent component = (JComponent)this._tabbedExecutionsPanel.getComponentAt(i);
            if (component instanceof CancelPanel) continue;
            allTabs.add(component);
        }
        return allTabs;
    }

    public void closeAllButCurrentResultTabs() {
        Component selectedTab = this._tabbedExecutionsPanel.getSelectedComponent();
        ArrayList<JComponent> allTabs = this.getAllTabs();
        ArrayList<JComponent> allButCurrent = new ArrayList<JComponent>(allTabs);
        allButCurrent.remove(selectedTab);
        this._resultTabClosing.closeTabs(allButCurrent);
    }

    public boolean confirmClose() {
        return this._resultTabClosing.confirmSqlPanelClose(this.getAllTabs());
    }

    public void closeAllToResultTabs(boolean left) {
        int selectedIndex = this._tabbedExecutionsPanel.getSelectedIndex();
        ArrayList<JComponent> tabsToClose = new ArrayList<JComponent>();
        if (left) {
            for (int i = 0; i < selectedIndex; ++i) {
                tabsToClose.add((JComponent)this._tabbedExecutionsPanel.getComponentAt(i));
            }
        } else {
            for (int i = selectedIndex + 1; i < this._tabbedExecutionsPanel.getTabCount(); ++i) {
                tabsToClose.add((JComponent)this._tabbedExecutionsPanel.getComponentAt(i));
            }
        }
        this._resultTabClosing.closeTabs(tabsToClose);
    }

    public void toggleCurrentSQLResultTabSticky() {
        if (null != this._stickyTab) {
            if (this._stickyTab.equals(this._tabbedExecutionsPanel.getSelectedComponent())) {
                this._stickyTab = null;
                this._tabbedExecutionsPanel.setIconAt(this._tabbedExecutionsPanel.getSelectedIndex(), null);
                return;
            }
            int indexOfStickyTab = TabbedExcutionPanelUtil.getIndexOfTab(this._stickyTab, this._tabbedExecutionsPanel);
            if (-1 != indexOfStickyTab) {
                this._tabbedExecutionsPanel.setIconAt(indexOfStickyTab, null);
            }
            this._stickyTab = null;
        }
        if (!(this._tabbedExecutionsPanel.getSelectedComponent() instanceof IResultTab)) {
            String msg = s_stringMgr.getString("SQLResultExecuterPanel.nonStickyPanel");
            JOptionPane.showMessageDialog(this._session.getApplication().getMainFrame(), msg);
            return;
        }
        this._stickyTab = (IResultTab)((Object)this._tabbedExecutionsPanel.getSelectedComponent());
        int selectedIndex = this._tabbedExecutionsPanel.getSelectedIndex();
        ImageIcon icon = this._tabIconManager.getStickyIcon();
        this._tabbedExecutionsPanel.setIconAt(selectedIndex, icon);
    }

    public void toggleCurrentSQLResultTabAnchored() {
        int selectedIndex;
        if (null != this._stickyTab && this._stickyTab.equals(this._tabbedExecutionsPanel.getSelectedComponent())) {
            this._stickyTab = null;
        }
        if (this._resultTabClosing.isAnchoredAt(selectedIndex = this._tabbedExecutionsPanel.getSelectedIndex())) {
            this._tabbedExecutionsPanel.setIconAt(selectedIndex, null);
        } else {
            this._tabbedExecutionsPanel.setIconAt(selectedIndex, this._tabIconManager.getAnchorIcon());
        }
    }

    public void closeCurrentResultTab() {
        JComponent selectedTab = (JComponent)this._tabbedExecutionsPanel.getSelectedComponent();
        this._resultTabClosing.closeTab(selectedTab);
    }

    void sessionClosing() {
        if (this._propsListener != null) {
            this._session.getProperties().removePropertyChangeListener(this._propsListener);
            this._propsListener = null;
        }
        this.closeAllSQLResultFrames();
    }

    public void gotoNextResultsTab() {
        int tabCount = this._tabbedExecutionsPanel.getTabCount();
        if (tabCount > 1) {
            int nextTabIdx = this._tabbedExecutionsPanel.getSelectedIndex() + 1;
            if (nextTabIdx >= tabCount) {
                nextTabIdx = 0;
            }
            this._tabbedExecutionsPanel.setSelectedIndex(nextTabIdx);
        }
    }

    public void gotoPreviousResultsTab() {
        int tabCount = this._tabbedExecutionsPanel.getTabCount();
        if (tabCount > 1) {
            int prevTabIdx = this._tabbedExecutionsPanel.getSelectedIndex() - 1;
            if (prevTabIdx < 0) {
                prevTabIdx = tabCount - 1;
            }
            this._tabbedExecutionsPanel.setSelectedIndex(prevTabIdx);
        }
    }

    protected String fireSQLToBeExecutedEvent(String sql) {
        Object[] listeners = this._listeners.getListenerList();
        for (int i = listeners.length - 2; i >= 0 && (listeners[i] != ISQLExecutionListener.class || (sql = ((ISQLExecutionListener)listeners[i + 1]).statementExecuting(sql)) != null); i -= 2) {
        }
        return sql;
    }

    private void createSQLResultFrame(IResultTab tab) {
        if (tab == null) {
            throw new IllegalArgumentException("Null ResultTab passed");
        }
        this._tabbedExecutionsPanel.remove(tab.getCompleteResultTab());
        ResultFrameListener resultFrameListener = new ResultFrameListener(){

            @Override
            public void frameReplaced(ResultFrame oldFrame, ResultFrame newFrame) {
                SQLResultExecuterPanel.this.onFrameReplaced(oldFrame, newFrame);
            }
        };
        ResultFrame frame = new ResultFrame(this._session, tab, this._resultTabFactory, resultFrameListener, true, false);
        this._sqlResultFrames.add(frame);
    }

    private void onFrameReplaced(ResultFrame oldFrame, ResultFrame newFrame) {
        this._sqlResultFrames.remove(oldFrame);
        this._sqlResultFrames.add(newFrame);
    }

    private void returnToTabbedPane(ResultTab tab) {
        if (tab == null) {
            throw new IllegalArgumentException("Null ResultTab passed");
        }
        MarkDuplicatesChooserController resultFramesMarkDuplicatesChooserController = null;
        for (ResultFrame sqlResultFrame : this._sqlResultFrames) {
            if (tab != sqlResultFrame.getResultTab()) continue;
            resultFramesMarkDuplicatesChooserController = sqlResultFrame.getMarkDuplicatesChooserController();
            this._sqlResultFrames.remove(sqlResultFrame);
            break;
        }
        this.addResultsTab(tab, null);
        tab.wasReturnedToTabbedPane(resultFramesMarkDuplicatesChooserController);
        this._tabbedExecutionsPanel.setSelectedComponent(tab);
    }

    @Override
    public IResultTab getSelectedResultTab() {
        return (IResultTab)((Object)this._tabbedExecutionsPanel.getSelectedComponent());
    }

    private void onAddResultsTab(final SQLExecutionInfo exInfo, final ResultSetDataSet rsds, final ResultSetMetaDataDataSet mdds, final IDataSetUpdateableTableModel creator, final IResultTab resultTabToReplace) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    ResultTab tab = SQLResultExecuterPanel.this._resultTabFactory.createResultTab(exInfo, creator, rsds, mdds);
                    SQLResultExecuterPanel.this.addResultsTab(tab, resultTabToReplace);
                    SQLResultExecuterPanel.this._tabbedExecutionsPanel.setSelectedComponent(tab);
                }
                catch (Throwable t) {
                    SQLResultExecuterPanel.this._session.showErrorMessage(t);
                }
            }
        });
    }

    private void onRemoveCancelPanel(final CancelPanelCtrl cancelPanelCtrl, final IResultTab resultTabToReplace) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SQLResultExecuterPanel.this._tabbedExecutionsPanel.remove(cancelPanelCtrl.getPanel());
                int indexToSelect = -1;
                indexToSelect = null == resultTabToReplace ? TabbedExcutionPanelUtil.getIndexOfTab(SQLResultExecuterPanel.this._stickyTab, SQLResultExecuterPanel.this._tabbedExecutionsPanel) : TabbedExcutionPanelUtil.getIndexOfTab(resultTabToReplace, SQLResultExecuterPanel.this._tabbedExecutionsPanel);
                if (-1 != indexToSelect) {
                    SQLResultExecuterPanel.this._tabbedExecutionsPanel.setSelectedIndex(indexToSelect);
                }
                cancelPanelCtrl.wasRemoved();
            }
        });
    }

    private void onSetCancelPanel(final CancelPanelCtrl cancelPanelCtrl) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SQLResultExecuterPanel.this._tabbedExecutionsPanel.addTab(i18n.EXEC_SQL_MSG, null, cancelPanelCtrl.getPanel(), i18n.CANCEL_SQL_MSG);
                SQLResultExecuterPanel.this._tabbedExecutionsPanel.setSelectedComponent(cancelPanelCtrl.getPanel());
            }
        });
    }

    private void addResultsTab(ResultTab tab, IResultTab resultTabToReplace) {
        boolean replaceStickyTab;
        TableState sortableTableState;
        if (null == resultTabToReplace && null == this._stickyTab) {
            this._tabbedExecutionsPanel.addTab(tab.getTitle(), null, tab, tab.getViewableSqlString());
            this.checkResultTabLimit();
            return;
        }
        if (null != resultTabToReplace && this._session.getProperties().getKeepTableLayoutOnRerun() && null != (sortableTableState = resultTabToReplace.getResultSortableTableState())) {
            tab.applyResultSortableTableState(sortableTableState);
        }
        int indexToReplace = -1;
        ImageIcon tabIcon = null;
        boolean bl = replaceStickyTab = null != this._stickyTab && (null == resultTabToReplace || this._stickyTab == resultTabToReplace);
        if (replaceStickyTab) {
            indexToReplace = TabbedExcutionPanelUtil.getIndexOfTab(this._stickyTab, this._tabbedExecutionsPanel);
            if (-1 == indexToReplace) {
                this._stickyTab = null;
            } else {
                tabIcon = this._tabIconManager.getStickyIcon();
                this._stickyTab = tab;
            }
        } else if (null != resultTabToReplace) {
            indexToReplace = TabbedExcutionPanelUtil.getIndexOfTab(resultTabToReplace, this._tabbedExecutionsPanel);
            if (this._resultTabClosing.isAnchored((JComponent)((Object)resultTabToReplace))) {
                tabIcon = this._tabIconManager.getAnchorIcon();
            }
        }
        if (-1 == indexToReplace) {
            this.addResultsTab(tab, null);
        } else {
            this._resultTabClosing.closeTabAt(indexToReplace);
            this._tabbedExecutionsPanel.insertTab(tab.getTitle(), tabIcon, tab, tab.getViewableSqlString(), indexToReplace);
        }
    }

    private void checkResultTabLimit() {
        SessionProperties props = this._session.getProperties();
        int indexToRemove = 0;
        while (props.getLimitSQLResultTabs() && props.getSqlResultTabLimit() < this._tabbedExecutionsPanel.getTabCount() && !(this._tabbedExecutionsPanel.getComponentAt(indexToRemove) instanceof CancelPanel)) {
            if (this._resultTabClosing.isAnchoredAt(indexToRemove)) {
                ++indexToRemove;
            } else {
                this._resultTabClosing.closeTabAt(indexToRemove);
            }
            if (indexToRemove != this._tabbedExecutionsPanel.getTabCount() - 1) continue;
            break;
        }
    }

    private void propertiesHaveChanged(String propName) {
        SessionProperties props = this._session.getProperties();
        if (propName == null || propName.equals("autoCommit")) {
            SetAutoCommitTask task = new SetAutoCommitTask();
            if (SwingUtilities.isEventDispatchThread()) {
                this._session.getApplication().getThreadPool().addTask(task);
            } else {
                task.run();
            }
        }
        if (propName == null || propName.equals("sqlExecutionTabPlacement")) {
            this._tabbedExecutionsPanel.setTabPlacement(props.getSQLExecutionTabPlacement());
        }
    }

    private void createGUI() {
        SessionProperties props = this._session.getProperties();
        this._tabbedExecutionsPanel = UIFactory.getInstance().createTabbedPane(props.getSQLExecutionTabPlacement(), true);
        this.createTabPopup();
        this._tabbedExecutionsPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                SQLResultExecuterPanel.this.doCloseOnMiddleMouseClick(e);
            }
        });
        this.setLayout(new BorderLayout());
        this.add((Component)this._tabbedExecutionsPanel, "Center");
    }

    private void doCloseOnMiddleMouseClick(MouseEvent e) {
        if (SwingUtilities.isMiddleMouseButton(e)) {
            int tab = this._tabbedExecutionsPanel.getUI().tabForCoordinate(this._tabbedExecutionsPanel, e.getX(), e.getY());
            if (-1 == tab) {
                return;
            }
            Component comp = this._tabbedExecutionsPanel.getComponentAt(tab);
            if (comp instanceof IResultTab) {
                this._resultTabClosing.closeTab((JComponent)comp);
            }
        }
    }

    private void createTabPopup() {
        final JPopupMenu popup = new JPopupMenu();
        String closeLabel = s_stringMgr.getString("SQLResultExecuterPanel.close");
        JMenuItem mnuClose = new JMenuItem(closeLabel);
        this.initAccelerator(CloseCurrentSQLResultTabAction.class, mnuClose);
        mnuClose.addActionListener(e -> this.closeCurrentResultTab());
        popup.add(mnuClose);
        String cabtLabel = s_stringMgr.getString("SQLResultExecuterPanel.closeAllButThis");
        JMenuItem mnuCloseAllButThis = new JMenuItem(cabtLabel);
        this.initAccelerator(CloseAllSQLResultTabsButCurrentAction.class, mnuCloseAllButThis);
        mnuCloseAllButThis.addActionListener(e -> this.closeAllButCurrentResultTabs());
        popup.add(mnuCloseAllButThis);
        String caLabel = s_stringMgr.getString("SQLResultExecuterPanel.closeAll");
        JMenuItem mnuCloseAll = new JMenuItem(caLabel);
        this.initAccelerator(CloseAllSQLResultTabsAction.class, mnuCloseAll);
        mnuCloseAll.addActionListener(e -> this.closeAllSQLResultTabs());
        popup.add(mnuCloseAll);
        String closeAlltoLeftLabel = s_stringMgr.getString("SQLResultExecuterPanel.closeAllToLeft");
        JMenuItem mnuCloseAllToLeft = new JMenuItem(closeAlltoLeftLabel);
        this.initAccelerator(CloseAllSQLResultTabsToLeftAction.class, mnuCloseAllToLeft);
        mnuCloseAllToLeft.addActionListener(e -> this.closeAllToResultTabs(true));
        popup.add(mnuCloseAllToLeft);
        String closeAlltoRightLabel = s_stringMgr.getString("SQLResultExecuterPanel.closeAllToRight");
        JMenuItem mnuCloseAllToRight = new JMenuItem(closeAlltoRightLabel);
        this.initAccelerator(CloseAllSQLResultTabsToRightAction.class, mnuCloseAllToLeft);
        mnuCloseAllToRight.addActionListener(e -> this.closeAllToResultTabs(false));
        popup.add(mnuCloseAllToRight);
        String tsLabel = s_stringMgr.getString("SQLResultExecuterPanel.toggleSticky");
        JMenuItem mnuToggleSticky = new JMenuItem(tsLabel);
        this.initAccelerator(ToggleCurrentSQLResultTabStickyAction.class, mnuToggleSticky);
        mnuToggleSticky.addActionListener(e -> this.toggleCurrentSQLResultTabSticky());
        mnuToggleSticky.setToolTipText(s_stringMgr.getString("SQLResultExecuterPanel.toggleSticky.tooltip"));
        popup.add(mnuToggleSticky);
        String taLabel = s_stringMgr.getString("SQLResultExecuterPanel.toggleAnchored");
        JMenuItem mnuToggleAnchored = new JMenuItem(taLabel);
        this.initAccelerator(ToggleCurrentSQLResultTabAnchoredAction.class, mnuToggleAnchored);
        mnuToggleAnchored.addActionListener(e -> this.toggleCurrentSQLResultTabAnchored());
        mnuToggleAnchored.setToolTipText(s_stringMgr.getString("SQLResultExecuterPanel.toggleAnchored.tooltip"));
        popup.add(mnuToggleAnchored);
        this._tabbedExecutionsPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                SQLResultExecuterPanel.this.maybeShowPopup(e, popup);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                SQLResultExecuterPanel.this.maybeShowPopup(e, popup);
            }
        });
    }

    private void initAccelerator(Class<? extends Action> actionClass, JMenuItem mnuItem) {
        Action action = this._session.getApplication().getActionCollection().get(actionClass);
        String accel = (String)action.getValue("SQuirreLAcceleratorString");
        Main.getApplication().getShortcutManager().setAccelerator(mnuItem, KeyStroke.getKeyStroke(accel), action);
    }

    private void maybeShowPopup(MouseEvent e, JPopupMenu popup) {
        int tab;
        if (e.isPopupTrigger() && -1 != (tab = this._tabbedExecutionsPanel.getUI().tabForCoordinate(this._tabbedExecutionsPanel, e.getX(), e.getY()))) {
            popup.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    static /* synthetic */ StringManager access$000() {
        return s_stringMgr;
    }

    private static final class ResultTabInfo {
        final ResultTab _tab;
        ResultFrame _resultFrame;

        ResultTabInfo(ResultTab tab) {
            if (tab == null) {
                throw new IllegalArgumentException("Null ResultTab passed");
            }
            this._tab = tab;
        }
    }

    private class MyPropertiesListener
    implements PropertyChangeListener {
        private boolean _listening = true;

        private MyPropertiesListener() {
        }

        void stopListening() {
            this._listening = false;
        }

        void startListening() {
            this._listening = true;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (this._listening) {
                SQLResultExecuterPanel.this.propertiesHaveChanged(evt.getPropertyName());
            }
        }
    }

    private class SetAutoCommitTask
    implements Runnable {
        private SetAutoCommitTask() {
        }

        @Override
        public void run() {
            ISQLConnection conn = SQLResultExecuterPanel.this._session.getSQLConnection();
            SessionProperties props = SQLResultExecuterPanel.this._session.getProperties();
            if (conn != null) {
                boolean auto = true;
                try {
                    auto = conn.getAutoCommit();
                }
                catch (SQLException ex) {
                    s_log.error("Error with transaction control", ex);
                    SQLResultExecuterPanel.this._session.showErrorMessage(ex);
                }
                try {
                    conn.setAutoCommit(props.getAutoCommit());
                }
                catch (SQLException ex) {
                    props.setAutoCommit(auto);
                    SQLResultExecuterPanel.this._session.showErrorMessage(ex);
                }
            }
        }
    }

    static interface i18n {
        public static final String EXEC_SQL_MSG = SQLResultExecuterPanel.access$000().getString("SQLResultExecuterPanel.exec");
        public static final String CANCEL_SQL_MSG = SQLResultExecuterPanel.access$000().getString("SQLResultExecuterPanel.cancelMsg");
    }
}

