/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.napkinlaf.util;

import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import net.sourceforge.napkinlaf.NapkinLookAndFeel;
import net.sourceforge.napkinlaf.NapkinTheme;
import net.sourceforge.napkinlaf.NapkinThemeColor;
import net.sourceforge.napkinlaf.shapes.AbstractDrawnGenerator;
import net.sourceforge.napkinlaf.shapes.DrawnBoxGenerator;
import net.sourceforge.napkinlaf.shapes.DrawnBoxHolder;
import net.sourceforge.napkinlaf.shapes.DrawnCheckGenerator;
import net.sourceforge.napkinlaf.shapes.DrawnCircleGenerator;
import net.sourceforge.napkinlaf.shapes.DrawnQuadLineGenerator;
import net.sourceforge.napkinlaf.shapes.DrawnTriangleGenerator;
import net.sourceforge.napkinlaf.sketch.DrawnIcon;
import net.sourceforge.napkinlaf.sketch.Template;
import net.sourceforge.napkinlaf.sketch.TemplateReadException;
import net.sourceforge.napkinlaf.util.AbstractNapkinIcon;
import net.sourceforge.napkinlaf.util.NapkinIcon;
import net.sourceforge.napkinlaf.util.NapkinUtil;
import net.sourceforge.napkinlaf.util.RandomXY;

public class NapkinIconFactory {
    private static final Map<String, Template> tmplMap = new HashMap<String, Template>();

    public static Icon createCheckBoxIcon() {
        return new CheckBoxIcon(13);
    }

    public static Icon createCheckedMenuItemIcon() {
        return new CheckBoxIcon(9);
    }

    public static Icon createRadioButtonIcon() {
        return new RadioButtonIcon();
    }

    public static Icon createArrowIcon(int pointTowards) {
        return NapkinIconFactory.createArrowIcon(pointTowards, 10);
    }

    public static Icon createArrowIcon(int pointTowards, int size) {
        return new ArrowIcon(pointTowards, size);
    }

    public static Icon createXIcon(int size) {
        return new XIcon(size);
    }

    public static Icon createSketchedIcon(String templatePath) {
        NapkinTheme theme = NapkinTheme.Manager.getCurrentTheme();
        Template template = NapkinIconFactory.getTemplate(templatePath);
        return template == null ? NapkinIconFactory.createXIcon(20) : new DrawnIcon(template, theme.getSketcher());
    }

    public static Template getTemplate(String templatePath) {
        Template template = tmplMap.get(templatePath);
        if (template == null) {
            String subpath = "resources/templates/" + templatePath + ".xml";
            InputStream in = NapkinLookAndFeel.class.getResourceAsStream(subpath);
            if (in == null) {
                throw new IllegalArgumentException("unknown template: " + subpath);
            }
            try {
                template = Template.createFromXML(in);
                tmplMap.put(templatePath, template);
            }
            catch (TemplateReadException e) {
                e.printStackTrace();
            }
        }
        return template;
    }

    public static class XIcon
    implements NapkinIcon {
        private final int size;
        private final DrawnBoxHolder mark;

        public XIcon(int size) {
            DrawnBoxGenerator box = new DrawnBoxGenerator();
            box.setAsX(true);
            this.mark = new DrawnBoxHolder(box);
            this.size = size;
        }

        public int getIconHeight() {
            return this.size;
        }

        public int getIconWidth() {
            return this.size;
        }

        public void paintIcon(Component c, Graphics g1, int x, int y) {
            Graphics2D g = NapkinUtil.lineGraphics(g1, 2.5f);
            this.mark.shapeUpToDate(new Rectangle(x, y, this.size, this.size));
            g.translate(x, y);
            this.mark.draw(g);
            g.translate(-x, -y);
        }
    }

    public static class ArrowIcon
    extends AbstractNapkinIcon {
        private final int genNum;
        private final int size;
        public static final int DEFAULT_SIZE = 10;
        private static final DrawnTriangleGenerator[] ARROW_GEN = new DrawnTriangleGenerator[]{new DrawnTriangleGenerator(0.0), new DrawnTriangleGenerator(1.5707963267948966), new DrawnTriangleGenerator(Math.PI), new DrawnTriangleGenerator(-1.5707963267948966)};

        public ArrowIcon(int pointTowards, int size) {
            super(NapkinThemeColor.CHECK_COLOR, NapkinUtil.scaleMat(size));
            this.genNum = pointTowards / 2;
            this.size = size;
            this.init();
        }

        protected AbstractDrawnGenerator createPlaceGenerator() {
            return ARROW_GEN[this.genNum];
        }

        protected AbstractDrawnGenerator createMarkGenerator() {
            return ARROW_GEN[this.genNum];
        }

        protected int calcHeight() {
            return this.size;
        }

        protected int calcWidth() {
            return this.size;
        }

        protected boolean shouldUseMark(Component c) {
            return super.shouldUseMark(c) || c.isFocusOwner();
        }
    }

    public static class RadioButtonIcon
    extends AbstractNapkinIcon {
        private final double scale;
        private static final int DEF_SIZE = 13;
        private static final double DEF_SCALE = 0.13;
        private static final AffineTransform DEF_SCALE_MAT = NapkinUtil.scaleMat(0.13);
        private static final DrawnCircleGenerator CIRCLE_GEN = new DrawnCircleGenerator();

        public RadioButtonIcon() {
            super(NapkinThemeColor.RADIO_COLOR, DEF_SCALE_MAT);
            this.scale = 0.13;
            this.init();
        }

        protected AbstractDrawnGenerator createPlaceGenerator() {
            return CIRCLE_GEN;
        }

        protected AbstractDrawnGenerator createMarkGenerator() {
            DrawnCircleGenerator gen = new DrawnCircleGenerator(true);
            double skew = 33.333333333333336;
            RandomXY tl = gen.getTL();
            RandomXY br = gen.getBR();
            Point2D tlMid = tl.getMid();
            Point2D brMid = br.getMid();
            tl.setMid(tlMid.getX() + skew, tlMid.getY() + skew);
            br.setMid(brMid.getX() + skew, brMid.getY() + skew);
            return gen;
        }

        public int calcWidth() {
            double max = CIRCLE_GEN.getBR().max().getX();
            double min = CIRCLE_GEN.getBL().min().getX();
            return (int)Math.ceil(this.scale * (max - min));
        }

        public int calcHeight() {
            double max = CIRCLE_GEN.getBR().max().getY();
            double min = CIRCLE_GEN.getTR().min().getY();
            return (int)Math.ceil(this.scale * (max - min));
        }
    }

    public static class CheckBoxIcon
    extends AbstractNapkinIcon {
        protected static final double MID_INSET_RATIO = 0.23076923076923078;
        private final int size;
        private final int midInset;
        private DrawnCheckGenerator checkGen;

        public CheckBoxIcon(int size) {
            super(NapkinThemeColor.CHECK_COLOR, null);
            this.size = size;
            this.midInset = (int)((double)size * 0.23076923076923078 + 0.5);
            this.init();
        }

        protected AbstractDrawnGenerator createPlaceGenerator() {
            DrawnQuadLineGenerator gen = new DrawnQuadLineGenerator();
            gen.getCtl().getY().setMid(1.0);
            return gen;
        }

        protected AbstractDrawnGenerator createMarkGenerator() {
            if (this.checkGen == null) {
                this.checkGen = new DrawnCheckGenerator(this.size - this.midInset);
            }
            return this.checkGen;
        }

        protected int calcWidth() {
            return (int)((double)(this.size - this.midInset) * this.checkGen.getMaxWidth() + 0.5);
        }

        protected int calcHeight() {
            return (int)((double)(this.size - this.midInset) * this.checkGen.getMaxHeight() + 2.5);
        }

        protected void doPaint(Graphics2D placeG, Graphics2D markG, int x, int y) {
            FontMetrics fm = placeG.getFontMetrics();
            int ypos = y + fm.getAscent();
            placeG.translate(x, ypos);
            placeG.scale((double)this.size / 100.0, 1.0);
            placeG.draw(this.place);
            if (markG != null) {
                markG.translate(x, ypos - this.size);
                markG.draw(this.mark);
            }
        }
    }
}

