/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.fingerprint.classpath.impl;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nullable;
import org.gradle.internal.change.Change;
import org.gradle.internal.change.ChangeVisitor;
import org.gradle.internal.change.DefaultFileChange;
import org.gradle.internal.file.FileType;
import org.gradle.internal.fingerprint.FileSystemLocationFingerprint;
import org.gradle.internal.fingerprint.FingerprintCompareStrategy;
import org.gradle.internal.fingerprint.impl.AbstractFingerprintCompareStrategy;
import org.gradle.internal.hash.Hasher;

public class ClasspathCompareStrategy
extends AbstractFingerprintCompareStrategy {
    public static final FingerprintCompareStrategy INSTANCE = new ClasspathCompareStrategy();

    private ClasspathCompareStrategy() {
    }

    protected boolean doVisitChangesSince(ChangeVisitor visitor, Map<String, FileSystemLocationFingerprint> currentSnapshots, Map<String, FileSystemLocationFingerprint> previousSnapshots, String propertyTitle, boolean includeAdded) {
        TrackingVisitor trackingVisitor = new TrackingVisitor(visitor);
        ChangeState changeState = new ChangeState(propertyTitle, includeAdded, trackingVisitor, currentSnapshots, previousSnapshots);
        while (trackingVisitor.isConsumeMore() && changeState.hasMoreToProcess()) {
            changeState.processChange();
        }
        return trackingVisitor.isConsumeMore();
    }

    public void appendToHasher(Hasher hasher, Collection<FileSystemLocationFingerprint> fingerprints) {
        for (FileSystemLocationFingerprint fingerprint : fingerprints) {
            fingerprint.appendToHasher(hasher);
        }
    }

    private static class ChangeState {
        private Map.Entry<String, FileSystemLocationFingerprint> current;
        private Map.Entry<String, FileSystemLocationFingerprint> previous;
        private final boolean includeAdded;
        private final ChangeVisitor changeConsumer;
        private final Iterator<Map.Entry<String, FileSystemLocationFingerprint>> currentEntries;
        private final Map<String, FileSystemLocationFingerprint> currentSnapshots;
        private final Iterator<Map.Entry<String, FileSystemLocationFingerprint>> previousEntries;
        private final Map<String, FileSystemLocationFingerprint> previousSnapshots;
        private final String propertyTitle;

        private ChangeState(String propertyTitle, boolean includeAdded, ChangeVisitor changeConsumer, Map<String, FileSystemLocationFingerprint> currentSnapshots, Map<String, FileSystemLocationFingerprint> previousSnapshots) {
            this.propertyTitle = propertyTitle;
            this.includeAdded = includeAdded;
            this.changeConsumer = changeConsumer;
            this.currentEntries = currentSnapshots.entrySet().iterator();
            this.currentSnapshots = currentSnapshots;
            this.previousEntries = previousSnapshots.entrySet().iterator();
            this.previousSnapshots = previousSnapshots;
            this.current = this.nextEntry(this.currentEntries);
            this.previous = this.nextEntry(this.previousEntries);
        }

        void processChange() {
            if (this.current == null) {
                if (this.previous != null) {
                    this.removed();
                }
            } else if (this.previous == null) {
                this.added();
            } else {
                String previousNormalizedPath;
                FileSystemLocationFingerprint currentFingerprint = this.current.getValue();
                FileSystemLocationFingerprint previousFingerprint = this.previous.getValue();
                String currentNormalizedPath = currentFingerprint.getNormalizedPath();
                if (!currentNormalizedPath.equals(previousNormalizedPath = previousFingerprint.getNormalizedPath())) {
                    this.removed();
                    this.added();
                } else if (currentFingerprint.getNormalizedContentHash().equals((Object)previousFingerprint.getNormalizedContentHash())) {
                    this.current = this.nextEntry(this.currentEntries);
                    this.previous = this.nextEntry(this.previousEntries);
                } else if (currentNormalizedPath.isEmpty()) {
                    String previousAbsolutePath;
                    String currentAbsolutePath = this.current.getKey();
                    if (!currentAbsolutePath.equals(previousAbsolutePath = this.previous.getKey())) {
                        if (!this.currentSnapshots.containsKey(previousAbsolutePath)) {
                            this.removed();
                        } else if (!this.previousSnapshots.containsKey(currentAbsolutePath)) {
                            this.added();
                        } else {
                            this.removed();
                            this.added();
                        }
                    } else {
                        this.modified();
                    }
                } else {
                    this.modified();
                }
            }
        }

        void added() {
            if (this.includeAdded) {
                DefaultFileChange added = DefaultFileChange.added((String)this.current.getKey(), (String)this.propertyTitle, (FileType)this.current.getValue().getType(), (String)this.current.getValue().getNormalizedPath());
                this.changeConsumer.visitChange((Change)added);
            }
            this.current = this.nextEntry(this.currentEntries);
        }

        void removed() {
            DefaultFileChange removed = DefaultFileChange.removed((String)this.previous.getKey(), (String)this.propertyTitle, (FileType)this.previous.getValue().getType(), (String)this.previous.getValue().getNormalizedPath());
            this.changeConsumer.visitChange((Change)removed);
            this.previous = this.nextEntry(this.previousEntries);
        }

        void modified() {
            DefaultFileChange modified = DefaultFileChange.modified((String)this.current.getKey(), (String)this.propertyTitle, (FileType)this.previous.getValue().getType(), (FileType)this.current.getValue().getType(), (String)this.current.getValue().getNormalizedPath());
            this.changeConsumer.visitChange((Change)modified);
            this.previous = this.nextEntry(this.previousEntries);
            this.current = this.nextEntry(this.currentEntries);
        }

        @Nullable
        private <T> T nextEntry(Iterator<T> iterator) {
            return iterator.hasNext() ? (T)iterator.next() : null;
        }

        public boolean hasMoreToProcess() {
            return this.current != null || this.previous != null;
        }
    }

    private static class TrackingVisitor
    implements ChangeVisitor {
        private final ChangeVisitor visitor;
        private boolean consumeMore = true;

        private TrackingVisitor(ChangeVisitor visitor) {
            this.visitor = visitor;
        }

        public boolean visitChange(Change change) {
            if (this.consumeMore) {
                this.consumeMore = this.visitor.visitChange(change);
            }
            return this.consumeMore;
        }

        public boolean isConsumeMore() {
            return this.consumeMore;
        }
    }
}

