/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.ios.dyldcache;

import generic.continues.GenericFactory;
import generic.continues.RethrowContinuesFactory;
import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteArrayProvider;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.format.macho.MachException;
import ghidra.app.util.bin.format.macho.MachHeader;
import ghidra.app.util.bin.format.macho.Section;
import ghidra.app.util.bin.format.macho.commands.DyldInfoCommand;
import ghidra.app.util.bin.format.macho.commands.DynamicSymbolTableCommand;
import ghidra.app.util.bin.format.macho.commands.LoadCommand;
import ghidra.app.util.bin.format.macho.commands.SegmentCommand;
import ghidra.app.util.bin.format.macho.commands.SymbolTableCommand;
import ghidra.app.util.bin.format.macho.dyld.DyldCacheHeader;
import ghidra.app.util.bin.format.macho.dyld.DyldCacheMappingInfo;
import ghidra.app.util.opinion.DyldCacheUtils;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.util.LittleEndianDataConverter;
import ghidra.util.Msg;
import ghidra.util.exception.NotFoundException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class DyldCacheDylibExtractor {
    public static ByteProvider extractDylib(long dylibOffset, DyldCacheUtils.SplitDyldCache splitDyldCache, int index, FSRL fsrl, TaskMonitor monitor) throws IOException, MachException {
        MachHeader dylibHeader = MachHeader.createMachHeader((GenericFactory)RethrowContinuesFactory.INSTANCE, (ByteProvider)splitDyldCache.getProvider(index), (long)dylibOffset, (boolean)false);
        dylibHeader.parse();
        PackedDylib packedDylib = new PackedDylib(dylibHeader, dylibOffset, splitDyldCache, index);
        for (LoadCommand cmd : dylibHeader.getLoadCommands()) {
            if (monitor.isCancelled()) break;
            switch (cmd.getCommandType()) {
                case 1: {
                    DyldCacheDylibExtractor.fixupSegment((SegmentCommand)cmd, packedDylib, false, monitor);
                    break;
                }
                case 25: {
                    DyldCacheDylibExtractor.fixupSegment((SegmentCommand)cmd, packedDylib, true, monitor);
                    break;
                }
                case 2: {
                    DyldCacheDylibExtractor.fixupSymbolTable((SymbolTableCommand)cmd, packedDylib);
                    break;
                }
                case 11: {
                    DyldCacheDylibExtractor.fixupDynamicSymbolTable((DynamicSymbolTableCommand)cmd, packedDylib);
                    break;
                }
                case -2147483614: 
                case 34: {
                    DyldCacheDylibExtractor.fixupDyldInfo((DyldInfoCommand)cmd, packedDylib);
                }
            }
        }
        return packedDylib.getByteProvider(fsrl);
    }

    private static void fixupSegment(SegmentCommand cmd, PackedDylib packedDylib, boolean is64bit, TaskMonitor monitor) throws IOException {
        if (cmd.getFileOffset() > 0L && cmd.getFileSize() > 0L) {
            packedDylib.fixup(cmd.getStartIndex() + (long)(is64bit ? 40 : 32), is64bit ? 8 : 4);
        }
        long sectionStartIndex = cmd.getStartIndex() + (long)(is64bit ? 72 : 56);
        for (Section section : cmd.getSections()) {
            if (monitor.isCancelled()) break;
            if (section.getOffset() > 0 && section.getSize() > 0L) {
                packedDylib.fixup(sectionStartIndex + (long)(is64bit ? 48 : 40), 4);
            }
            if (section.getRelocationOffset() > 0) {
                packedDylib.fixup(sectionStartIndex + (long)(is64bit ? 56 : 48), 4);
            }
            sectionStartIndex += is64bit ? 80L : 68L;
        }
    }

    private static void fixupSymbolTable(SymbolTableCommand cmd, PackedDylib packedDylib) throws IOException {
        if (cmd.getSymbolOffset() > 0) {
            packedDylib.fixup(cmd.getStartIndex() + 8L, 4);
        }
        if (cmd.getStringTableOffset() > 0) {
            packedDylib.fixup(cmd.getStartIndex() + 16L, 4);
        }
    }

    private static void fixupDynamicSymbolTable(DynamicSymbolTableCommand cmd, PackedDylib packedDylib) throws IOException {
        if (cmd.getTableOfContentsOffset() > 0) {
            packedDylib.fixup(cmd.getStartIndex() + 32L, 4);
        }
        if (cmd.getModuleTableOffset() > 0) {
            packedDylib.fixup(cmd.getStartIndex() + 40L, 4);
        }
        if (cmd.getReferencedSymbolTableOffset() > 0) {
            packedDylib.fixup(cmd.getStartIndex() + 48L, 4);
        }
        if (cmd.getIndirectSymbolTableOffset() > 0) {
            packedDylib.fixup(cmd.getStartIndex() + 56L, 4);
        }
        if (cmd.getExternalRelocationOffset() > 0) {
            packedDylib.fixup(cmd.getStartIndex() + 64L, 4);
        }
        if (cmd.getLocalRelocationOffset() > 0) {
            packedDylib.fixup(cmd.getStartIndex() + 72L, 4);
        }
    }

    private static void fixupDyldInfo(DyldInfoCommand cmd, PackedDylib packedDylib) throws IOException {
        if (cmd.getRebaseOffset() > 0) {
            packedDylib.fixup(cmd.getStartIndex() + 8L, 4);
        }
        if (cmd.getBindOffset() > 0) {
            packedDylib.fixup(cmd.getStartIndex() + 16L, 4);
        }
        if (cmd.getWeakBindOffset() > 0) {
            packedDylib.fixup(cmd.getStartIndex() + 24L, 4);
        }
        if (cmd.getLazyBindOffset() > 0) {
            packedDylib.fixup(cmd.getStartIndex() + 32L, 4);
        }
        if (cmd.getExportOffset() > 0) {
            packedDylib.fixup(cmd.getStartIndex() + 40L, 4);
        }
    }

    private static class PackedDylib {
        private BinaryReader reader;
        private Map<SegmentCommand, Integer> packedStarts;
        private byte[] packed;

        public PackedDylib(MachHeader dylibHeader, long dylibOffset, DyldCacheUtils.SplitDyldCache splitDyldCache, int index) throws IOException {
            this.reader = new BinaryReader(splitDyldCache.getProvider(index), true);
            this.packedStarts = new HashMap<SegmentCommand, Integer>();
            int size = 0;
            for (SegmentCommand segment : dylibHeader.getAllSegments()) {
                this.packedStarts.put(segment, size);
                size = (int)((long)size + segment.getFileSize());
                if (segment.getFileOffset() != 0L) continue;
                segment.setFileOffset(dylibOffset);
            }
            this.packed = new byte[size];
            for (SegmentCommand segment : dylibHeader.getAllSegments()) {
                long segmentSize = segment.getFileSize();
                ByteProvider segmentProvider = this.getSegmentProvider(segment, splitDyldCache);
                if (segment.getFileOffset() + segmentSize > segmentProvider.length()) {
                    segmentSize = segmentProvider.length() - segment.getFileOffset();
                    Msg.warn((Object)this, (Object)(segment.getSegmentName() + " segment extends beyond end of file.  Truncating..."));
                }
                byte[] bytes = segmentProvider.readBytes(segment.getFileOffset(), segmentSize);
                System.arraycopy(bytes, 0, this.packed, this.packedStarts.get(segment), bytes.length);
            }
        }

        ByteProvider getByteProvider(FSRL fsrl) {
            return new ByteArrayProvider(this.packed, fsrl);
        }

        public void fixup(long fileOffset, int size) throws IOException {
            if (size != 4 && size != 8) {
                throw new IllegalArgumentException("Size must be 4 or 8 (got " + size + ")");
            }
            long orig = this.reader.readUnsignedValue(fileOffset, size);
            try {
                byte[] newBytes = this.toBytes(this.getPackedOffset(orig), size);
                System.arraycopy(newBytes, 0, this.packed, (int)this.getPackedOffset(fileOffset), newBytes.length);
            }
            catch (NotFoundException e) {
                Msg.warn((Object)this, (Object)e.getMessage());
            }
        }

        private long getPackedOffset(long fileOffset) throws NotFoundException {
            for (SegmentCommand segment : this.packedStarts.keySet()) {
                if (fileOffset < segment.getFileOffset() || fileOffset >= segment.getFileOffset() + segment.getFileSize()) continue;
                return fileOffset - segment.getFileOffset() + (long)this.packedStarts.get(segment).intValue();
            }
            throw new NotFoundException("Failed to convert DYLD file offset to packed DYLIB offset: " + Long.toHexString(fileOffset));
        }

        private ByteProvider getSegmentProvider(SegmentCommand segment, DyldCacheUtils.SplitDyldCache splitDyldCache) throws IOException {
            for (int i = 0; i < splitDyldCache.size(); ++i) {
                DyldCacheHeader header = splitDyldCache.getDyldCacheHeader(i);
                for (DyldCacheMappingInfo mappingInfo : header.getMappingInfos()) {
                    if (!mappingInfo.contains(segment.getVMaddress())) continue;
                    return splitDyldCache.getProvider(i);
                }
            }
            throw new IOException("Failed to find provider for segment: " + segment.getSegmentName());
        }

        private byte[] toBytes(long value, int size) throws IllegalArgumentException {
            if (size != 4 && size != 8) {
                throw new IllegalArgumentException("Size must be 4 or 8 (got " + size + ")");
            }
            LittleEndianDataConverter converter = LittleEndianDataConverter.INSTANCE;
            return size == 8 ? converter.getBytes(value) : converter.getBytes((int)value);
        }
    }
}

