/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.coff;

import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.ByteProviderWrapper;
import ghidra.app.util.bin.format.coff.CoffException;
import ghidra.app.util.bin.format.coff.archive.CoffArchiveHeader;
import ghidra.app.util.bin.format.coff.archive.CoffArchiveMemberHeader;
import ghidra.file.formats.coff.CoffArchiveFileSystemFactory;
import ghidra.formats.gfilesystem.FSRLRoot;
import ghidra.formats.gfilesystem.FileSystemIndexHelper;
import ghidra.formats.gfilesystem.FileSystemRefManager;
import ghidra.formats.gfilesystem.GFile;
import ghidra.formats.gfilesystem.GFileSystem;
import ghidra.formats.gfilesystem.annotations.FileSystemInfo;
import ghidra.formats.gfilesystem.fileinfo.FileAttributeType;
import ghidra.formats.gfilesystem.fileinfo.FileAttributes;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.Date;
import java.util.List;

@FileSystemInfo(type="coff", description="COFF Archive", factory=CoffArchiveFileSystemFactory.class)
public class CoffArchiveFileSystem
implements GFileSystem {
    private final FSRLRoot fsFSRL;
    private FileSystemIndexHelper<CoffArchiveMemberHeader> fsih;
    private FileSystemRefManager refManager = new FileSystemRefManager((GFileSystem)this);
    private ByteProvider provider;

    public CoffArchiveFileSystem(FSRLRoot fsFSRL, ByteProvider provider) {
        this.fsFSRL = fsFSRL;
        this.provider = provider;
        this.fsih = new FileSystemIndexHelper((GFileSystem)this, fsFSRL);
    }

    public void mount(TaskMonitor monitor) throws IOException {
        try {
            monitor.setMessage("Opening COFF archive...");
            CoffArchiveHeader caf = CoffArchiveHeader.read((ByteProvider)this.provider, (TaskMonitor)monitor);
            for (CoffArchiveMemberHeader camh : caf.getArchiveMemberHeaders()) {
                if (!camh.isCOFF()) continue;
                String name = camh.getName().replace('\\', '/');
                monitor.setMessage(name);
                this.fsih.storeFile(name, (long)this.fsih.getFileCount(), false, camh.getSize(), (Object)camh);
            }
        }
        catch (CoffException e) {
            throw new IOException(e);
        }
    }

    public String getName() {
        return this.fsFSRL.getContainer().getName();
    }

    public FSRLRoot getFSRL() {
        return this.fsFSRL;
    }

    public ByteProvider getByteProvider(GFile file, TaskMonitor monitor) {
        CoffArchiveMemberHeader entry = (CoffArchiveMemberHeader)this.fsih.getMetadata(file);
        return entry != null && entry.isCOFF() ? new ByteProviderWrapper(this.provider, entry.getPayloadOffset(), entry.getSize(), file.getFSRL()) : null;
    }

    public void close() throws IOException {
        this.refManager.onClose();
        if (this.provider != null) {
            this.provider.close();
            this.provider = null;
        }
        this.fsih.clear();
    }

    public boolean isClosed() {
        return this.provider == null;
    }

    public int getFileCount() {
        return this.fsih.getFileCount();
    }

    public FileAttributes getFileAttributes(GFile file, TaskMonitor monitor) {
        CoffArchiveMemberHeader entry = (CoffArchiveMemberHeader)this.fsih.getMetadata(file);
        FileAttributes result = new FileAttributes();
        if (entry != null) {
            result.add(FileAttributeType.NAME_ATTR, (Object)entry.getName());
            result.add(FileAttributeType.SIZE_ATTR, (Object)entry.getSize());
            result.add(FileAttributeType.USER_ID_ATTR, (Object)entry.getUserIdInt());
            result.add(FileAttributeType.GROUP_ID_ATTR, (Object)entry.getGroupIdInt());
            result.add(FileAttributeType.MODIFIED_DATE_ATTR, (Object)new Date(entry.getDate()));
            result.add("Mode", (Object)entry.getMode());
        }
        return result;
    }

    public GFile lookup(String path) throws IOException {
        return this.fsih.lookup(path);
    }

    public List<GFile> getListing(GFile directory) throws IOException {
        return this.fsih.getListing(directory);
    }

    public FileSystemRefManager getRefManager() {
        return this.refManager;
    }
}

