/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.fbpk;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.file.formats.android.fbpk.FBPT_Entry;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class FBPT
implements StructConverter {
    private String magic;
    private int unknown1;
    private int unknown2;
    private int unknown3;
    private int nEntries;
    private int unknownA;
    private int unknownB;
    private int unknownC;
    private int unknownD;
    private int unknownE;
    private int unknownF;
    private int unknownG;
    private int unknownH;
    private int unknownI;
    private int unknownJ;
    private int unknownK;
    private int unknownL;
    private int unknownM;
    private List<FBPT_Entry> entries = new ArrayList<FBPT_Entry>();

    public FBPT(BinaryReader reader) throws IOException {
        this.magic = reader.readNextAsciiString("FBPT".length());
        this.unknown1 = reader.readNextInt();
        this.unknown2 = reader.readNextInt();
        this.unknown3 = reader.readNextInt();
        this.nEntries = reader.readNextInt();
        this.unknownA = reader.readNextInt();
        this.unknownB = reader.readNextInt();
        this.unknownC = reader.readNextInt();
        this.unknownD = reader.readNextInt();
        this.unknownE = reader.readNextInt();
        this.unknownF = reader.readNextInt();
        this.unknownG = reader.readNextInt();
        this.unknownH = reader.readNextInt();
        this.unknownI = reader.readNextInt();
        this.unknownJ = reader.readNextInt();
        this.unknownK = reader.readNextInt();
        this.unknownL = reader.readNextInt();
        this.unknownM = reader.readNextInt();
        for (int i = 0; i < this.nEntries; ++i) {
            this.entries.add(new FBPT_Entry(reader, i == this.nEntries - 1));
        }
    }

    public String getMagic() {
        return this.magic;
    }

    public int getNEntries() {
        return this.nEntries;
    }

    public List<FBPT_Entry> getEntries() {
        return this.entries;
    }

    public int getUnknown1() {
        return this.unknown1;
    }

    public int getUnknown2() {
        return this.unknown2;
    }

    public int getUnknown3() {
        return this.unknown3;
    }

    public int getUnknownA() {
        return this.unknownA;
    }

    public int getUnknownB() {
        return this.unknownB;
    }

    public int getUnknownC() {
        return this.unknownC;
    }

    public int getUnknownD() {
        return this.unknownD;
    }

    public int getUnknownE() {
        return this.unknownE;
    }

    public int getUnknownF() {
        return this.unknownF;
    }

    public int getUnknownG() {
        return this.unknownG;
    }

    public int getUnknownH() {
        return this.unknownH;
    }

    public int getUnknownI() {
        return this.unknownI;
    }

    public int getUnknownJ() {
        return this.unknownJ;
    }

    public int getUnknownK() {
        return this.unknownK;
    }

    public int getUnknownL() {
        return this.unknownL;
    }

    public int getUnknownM() {
        return this.unknownM;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType(FBPT.class.getSimpleName(), 0);
        struct.add(STRING, "FBPT".length(), "magic", null);
        struct.add(DWORD, "unknown1", null);
        struct.add(DWORD, "unknown2", null);
        struct.add(DWORD, "unknown3", null);
        struct.add(DWORD, "nEntries", null);
        struct.add(DWORD, "unknownA", null);
        struct.add(DWORD, "unknownB", null);
        struct.add(DWORD, "unknownC", null);
        struct.add(DWORD, "unknownD", null);
        struct.add(DWORD, "unknownE", null);
        struct.add(DWORD, "unknownF", null);
        struct.add(DWORD, "unknownG", null);
        struct.add(DWORD, "unknownH", null);
        struct.add(DWORD, "unknownI", null);
        struct.add(DWORD, "unknownJ", null);
        struct.add(DWORD, "unknownK", null);
        struct.add(DWORD, "unknownL", null);
        struct.add(DWORD, "unknownM", null);
        return struct;
    }
}

