/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.art.lollipop;

import ghidra.app.util.bin.BinaryReader;
import ghidra.file.formats.android.art.ArtHeader;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.Structure;
import ghidra.program.model.listing.Program;
import ghidra.util.InvalidNameException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

public class ArtHeader_LollipopMR1WFC
extends ArtHeader {
    protected int image_begin_;
    protected int image_size_;
    protected int image_bitmap_offset_;
    protected int image_bitmap_size_;
    protected int oat_checksum_;
    protected int oat_file_begin_;
    protected int oat_data_begin_;
    protected int oat_data_end_;
    protected int oat_file_end_;
    protected int patch_delta_;
    protected int image_roots_;
    protected int compile_pic_;

    public ArtHeader_LollipopMR1WFC(BinaryReader reader) throws IOException {
        super(reader);
        this.parse(reader);
    }

    @Override
    protected void parse(BinaryReader reader) throws IOException {
        this.image_begin_ = reader.readNextInt();
        this.image_size_ = reader.readNextInt();
        this.image_bitmap_offset_ = reader.readNextInt();
        this.image_bitmap_size_ = reader.readNextInt();
        this.oat_checksum_ = reader.readNextInt();
        this.oat_file_begin_ = reader.readNextInt();
        this.oat_data_begin_ = reader.readNextInt();
        this.oat_data_end_ = reader.readNextInt();
        this.oat_file_end_ = reader.readNextInt();
        this.patch_delta_ = reader.readNextInt();
        this.image_roots_ = reader.readNextInt();
        this.compile_pic_ = reader.readNextInt();
    }

    @Override
    public int getImageBegin() {
        return this.image_begin_;
    }

    @Override
    public int getImageSize() {
        return this.image_size_;
    }

    public int getCompilePic() {
        return this.compile_pic_;
    }

    @Override
    public int getOatChecksum() {
        return this.oat_checksum_;
    }

    @Override
    public int getPointerSize() {
        return -1;
    }

    @Override
    public int getOatFileBegin() {
        return this.oat_file_begin_;
    }

    @Override
    public int getOatFileEnd() {
        return this.oat_file_end_;
    }

    @Override
    public int getOatDataBegin() {
        return this.oat_data_begin_;
    }

    @Override
    public int getOatDataEnd() {
        return this.oat_data_end_;
    }

    @Override
    public void markup(Program program, TaskMonitor monitor) throws Exception {
    }

    @Override
    public int getArtMethodCountForVersion() {
        throw new UnsupportedOperationException();
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        Structure structure = (Structure)super.toDataType();
        try {
            structure.setName(ArtHeader_LollipopMR1WFC.class.getSimpleName());
        }
        catch (InvalidNameException invalidNameException) {
            // empty catch block
        }
        structure.add(DWORD, "image_begin_", null);
        structure.add(DWORD, "image_size_", null);
        structure.add(DWORD, "image_bitmap_offset_", null);
        structure.add(DWORD, "image_bitmap_size_", null);
        structure.add(DWORD, "oat_checksum_", null);
        structure.add(DWORD, "oat_file_begin_", null);
        structure.add(DWORD, "oat_data_begin_", null);
        structure.add(DWORD, "oat_data_end_", null);
        structure.add(DWORD, "oat_file_end_", null);
        structure.add(DWORD, "patch_delta_", null);
        structure.add(DWORD, "image_roots_", null);
        structure.add(DWORD, "compile_pic_", null);
        return structure;
    }
}

