/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgeng.manager.cmd;

import agent.dbgeng.dbgeng.DebugStackInformation;
import agent.dbgeng.dbgeng.DebugSystemObjects;
import agent.dbgeng.dbgeng.DebugThreadId;
import agent.dbgeng.jna.dbgeng.DbgEngNative;
import agent.dbgeng.manager.DbgStackFrame;
import agent.dbgeng.manager.cmd.AbstractDbgCommand;
import agent.dbgeng.manager.cmd.DbgPendingCommand;
import agent.dbgeng.manager.impl.DbgManagerImpl;
import agent.dbgeng.manager.impl.DbgStackFrameImpl;
import agent.dbgeng.manager.impl.DbgThreadImpl;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public class DbgStackListFramesCommand
extends AbstractDbgCommand<List<DbgStackFrame>> {
    protected final DbgThreadImpl thread;
    private List<DbgStackFrame> result;

    public DbgStackListFramesCommand(DbgManagerImpl manager, DbgThreadImpl thread) {
        super(manager);
        this.thread = thread;
    }

    @Override
    public List<DbgStackFrame> complete(DbgPendingCommand<?> pending) {
        return this.result;
    }

    @Override
    public void invoke() {
        this.result = new ArrayList<DbgStackFrame>();
        DebugSystemObjects so = this.manager.getSystemObjects();
        DebugThreadId previous = so.getCurrentThreadId();
        so.setCurrentThreadId(this.thread.getId());
        DebugStackInformation stackTrace = this.manager.getControl().getStackTrace(0L, 0L, 0L);
        for (int i = 0; i < stackTrace.getNumberOfFrames(); ++i) {
            DbgEngNative.DEBUG_STACK_FRAME tf = stackTrace.getFrame(i);
            DbgStackFrameImpl frame = new DbgStackFrameImpl(this.thread, tf.FrameNumber.intValue(), new BigInteger(Long.toHexString(tf.InstructionOffset.longValue()), 16), tf.FuncTableEntry.longValue(), tf.FrameOffset.longValue(), tf.ReturnOffset.longValue(), tf.StackOffset.longValue(), tf.Virtual.booleanValue(), tf.Params[0].longValue(), tf.Params[1].longValue(), tf.Params[2].longValue(), tf.Params[3].longValue());
            this.result.add(frame);
        }
        so.setCurrentThreadId(previous);
    }
}

