/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgeng.impl.dbgeng.advanced;

import agent.dbgeng.dbgeng.DebugAdvanced;
import agent.dbgeng.dbgeng.DebugThreadId;
import agent.dbgeng.impl.dbgeng.advanced.DebugAdvancedImpl1;
import agent.dbgeng.impl.dbgeng.advanced.DebugAdvancedInternal;
import agent.dbgeng.jna.dbgeng.DbgEngNative;
import agent.dbgeng.jna.dbgeng.advanced.IDebugAdvanced2;
import com.sun.jna.platform.win32.COM.COMUtils;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import ghidra.comm.util.BitmaskSet;

public class DebugAdvancedImpl2
extends DebugAdvancedImpl1 {
    private final IDebugAdvanced2 jnaAdvanced;

    public DebugAdvancedImpl2(IDebugAdvanced2 jnaAdvanced) {
        super(jnaAdvanced);
        this.jnaAdvanced = jnaAdvanced;
    }

    @Override
    public DebugAdvanced.DebugThreadBasicInformation getThreadBasicInformation(DebugThreadId tid) {
        WinDef.ULONG ulWhich = new WinDef.ULONG((long)DebugAdvancedInternal.WhichSystemObjectInformation.THREAD_BASIC_INFORMATION.ordinal());
        WinDef.ULONGLONG ullUnused = new WinDef.ULONGLONG(0L);
        WinDef.ULONG ulThreadId = new WinDef.ULONG((long)tid.id);
        DbgEngNative.DEBUG_THREAD_BASIC_INFORMATION sInfo = new DbgEngNative.DEBUG_THREAD_BASIC_INFORMATION();
        WinDef.ULONG ulBufferSize = new WinDef.ULONG((long)sInfo.size());
        COMUtils.checkRC((WinNT.HRESULT)this.jnaAdvanced.GetSystemObjectInformation(ulWhich, ullUnused, ulThreadId, sInfo.getPointer(), ulBufferSize, null));
        sInfo.read();
        Integer exitStatus = null;
        Integer priorityClass = null;
        Integer priority = null;
        Long createTime = null;
        Long exitTime = null;
        Long kernelTime = null;
        Long userTime = null;
        Long startOffset = null;
        Long affinity = null;
        BitmaskSet valid = new BitmaskSet(DebugAdvancedInternal.ThreadBasicInformationValidBits.class, (long)sInfo.Valid.intValue());
        if (valid.contains((Object)DebugAdvancedInternal.ThreadBasicInformationValidBits.EXIT_STATUS)) {
            exitStatus = sInfo.ExitStatus.intValue();
        }
        if (valid.contains((Object)DebugAdvancedInternal.ThreadBasicInformationValidBits.PRIORITY_CLASS)) {
            priorityClass = sInfo.PriorityClass.intValue();
        }
        if (valid.contains((Object)DebugAdvancedInternal.ThreadBasicInformationValidBits.PRIORITY)) {
            priority = sInfo.Priority.intValue();
        }
        if (valid.contains((Object)DebugAdvancedInternal.ThreadBasicInformationValidBits.TIMES)) {
            createTime = sInfo.CreateTime.longValue();
            exitTime = sInfo.ExitTime.longValue();
            kernelTime = sInfo.KernelTime.longValue();
            userTime = sInfo.UserTime.longValue();
        }
        if (valid.contains((Object)DebugAdvancedInternal.ThreadBasicInformationValidBits.START_OFFSET)) {
            startOffset = sInfo.StartOffset.longValue();
        }
        if (valid.contains((Object)DebugAdvancedInternal.ThreadBasicInformationValidBits.AFFINITY)) {
            affinity = sInfo.Affinity.longValue();
        }
        return new DebugAdvanced.DebugThreadBasicInformation(exitStatus, priorityClass, priority, createTime, exitTime, kernelTime, userTime, startOffset, affinity);
    }
}

