/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgeng.dbgeng;

import ghidra.util.NumericUtilities;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;

@ForDebugValueType(value=DebugValueType.INVALID)
public interface DebugValue {
    default public DebugValueType getValueType() {
        return DebugValueType.getDebugValueTypeForClass(this.getClass());
    }

    public byte[] encodeAsBytes();

    @ForDebugValueType(value=DebugValueType.VECTOR128)
    public static class DebugVector128Value
    implements DebugValue {
        private final byte[] bytes;

        public DebugVector128Value(byte[] bytes) {
            if (bytes.length != 16) {
                throw new IllegalArgumentException("Must have exactly 16 bytes. got " + bytes.length);
            }
            this.bytes = Arrays.copyOf(bytes, 16);
        }

        public byte[] vi8() {
            return this.bytes;
        }

        @Override
        public byte[] encodeAsBytes() {
            return this.bytes;
        }

        public String toString() {
            return "vec128 " + NumericUtilities.convertBytesToString((byte[])this.bytes);
        }
    }

    @ForDebugValueType(value=DebugValueType.VECTOR64)
    public static class DebugVector64Value
    implements DebugValue {
        private final byte[] bytes;

        public DebugVector64Value(byte[] bytes) {
            if (bytes.length != 8) {
                throw new IllegalArgumentException("Must have exactly 8 bytes");
            }
            this.bytes = Arrays.copyOf(bytes, 8);
        }

        public byte[] vi4() {
            return this.bytes;
        }

        @Override
        public byte[] encodeAsBytes() {
            return this.bytes;
        }

        public String toString() {
            return "vec64 " + NumericUtilities.convertBytesToString((byte[])this.bytes);
        }
    }

    @ForDebugValueType(value=DebugValueType.FLOAT128)
    public static class DebugFloat128Value
    implements DebugValue {
        private final byte[] bytes;

        public DebugFloat128Value(byte[] bytes) {
            if (bytes.length != 16) {
                throw new IllegalArgumentException("Must have exactly 16 bytes");
            }
            this.bytes = Arrays.copyOf(bytes, 16);
        }

        public byte[] bytes() {
            return this.bytes;
        }

        @Override
        public byte[] encodeAsBytes() {
            return this.bytes;
        }

        public String toString() {
            return "f128 " + NumericUtilities.convertBytesToString((byte[])this.bytes);
        }
    }

    @ForDebugValueType(value=DebugValueType.FLOAT82)
    public static class DebugFloat82Value
    implements DebugValue {
        private final byte[] bytes;

        public DebugFloat82Value(byte[] bytes) {
            if (bytes.length != 11) {
                throw new IllegalArgumentException("Must have exactly 11 bytes");
            }
            this.bytes = Arrays.copyOf(bytes, 11);
        }

        public byte[] bytes() {
            return this.bytes;
        }

        @Override
        public byte[] encodeAsBytes() {
            return this.bytes;
        }

        public String toString() {
            return "f82 " + NumericUtilities.convertBytesToString((byte[])this.bytes);
        }
    }

    @ForDebugValueType(value=DebugValueType.FLOAT80)
    public static class DebugFloat80Value
    implements DebugValue {
        private final byte[] bytes;

        public DebugFloat80Value(byte[] bytes) {
            if (bytes.length != 10) {
                throw new IllegalArgumentException("Must have exactly 10 bytes");
            }
            this.bytes = Arrays.copyOf(bytes, 10);
        }

        public byte[] bytes() {
            return this.bytes;
        }

        @Override
        public byte[] encodeAsBytes() {
            return this.bytes;
        }

        public String toString() {
            return "f80 " + NumericUtilities.convertBytesToString((byte[])this.bytes);
        }
    }

    @ForDebugValueType(value=DebugValueType.FLOAT64)
    public static class DebugFloat64Value
    implements DebugValue {
        private final double value;

        public DebugFloat64Value(double value) {
            this.value = value;
        }

        public DebugFloat64Value(byte[] bytes) {
            if (bytes.length != 8) {
                throw new IllegalArgumentException("Must have exactly 8 bytes");
            }
            ByteBuffer buf = ByteBuffer.wrap(bytes).order(ByteOrder.BIG_ENDIAN);
            this.value = buf.getDouble();
        }

        public double doubleValue() {
            return this.value;
        }

        @Override
        public byte[] encodeAsBytes() {
            ByteBuffer buf = ByteBuffer.allocate(8).order(ByteOrder.BIG_ENDIAN);
            buf.putDouble(this.value);
            return buf.array();
        }

        public String toString() {
            return "f64 " + this.value;
        }
    }

    @ForDebugValueType(value=DebugValueType.FLOAT32)
    public static class DebugFloat32Value
    implements DebugValue {
        private final float value;

        public DebugFloat32Value(float value) {
            this.value = value;
        }

        public DebugFloat32Value(byte[] bytes) {
            if (bytes.length != 4) {
                throw new IllegalArgumentException("Must have exactly 4 bytes");
            }
            ByteBuffer buf = ByteBuffer.wrap(bytes).order(ByteOrder.BIG_ENDIAN);
            this.value = buf.getFloat();
        }

        public float floatValue() {
            return this.value;
        }

        @Override
        public byte[] encodeAsBytes() {
            ByteBuffer buf = ByteBuffer.allocate(4).order(ByteOrder.BIG_ENDIAN);
            buf.putFloat(this.value);
            return buf.array();
        }

        public String toString() {
            return "f32 " + this.value;
        }
    }

    @ForDebugValueType(value=DebugValueType.INT64)
    public static class DebugInt64Value
    implements DebugValue {
        private final long value;

        public DebugInt64Value(long value) {
            this.value = value;
        }

        public DebugInt64Value(byte[] bytes) {
            if (bytes.length != 8) {
                throw new IllegalArgumentException("Must have exactly 8 bytes");
            }
            ByteBuffer buf = ByteBuffer.wrap(bytes).order(ByteOrder.BIG_ENDIAN);
            this.value = buf.getLong();
        }

        public long longValue() {
            return this.value;
        }

        @Override
        public byte[] encodeAsBytes() {
            ByteBuffer buf = ByteBuffer.allocate(8).order(ByteOrder.BIG_ENDIAN);
            buf.putLong(this.value);
            return buf.array();
        }

        public String toString() {
            return "qword " + Long.toHexString(this.value) + "h";
        }
    }

    @ForDebugValueType(value=DebugValueType.INT32)
    public static class DebugInt32Value
    implements DebugValue {
        private final int value;

        public DebugInt32Value(int value) {
            this.value = value;
        }

        public DebugInt32Value(byte[] bytes) {
            if (bytes.length != 4) {
                throw new IllegalArgumentException("Must have exactly 4 bytes");
            }
            ByteBuffer buf = ByteBuffer.wrap(bytes).order(ByteOrder.BIG_ENDIAN);
            this.value = buf.getInt();
        }

        public int intValue() {
            return this.value;
        }

        @Override
        public byte[] encodeAsBytes() {
            ByteBuffer buf = ByteBuffer.allocate(4).order(ByteOrder.BIG_ENDIAN);
            buf.putInt(this.value);
            return buf.array();
        }

        public String toString() {
            return "dword " + Integer.toHexString(this.value) + "h";
        }
    }

    @ForDebugValueType(value=DebugValueType.INT16)
    public static class DebugInt16Value
    implements DebugValue {
        private final short value;

        public DebugInt16Value(short value) {
            this.value = value;
        }

        public DebugInt16Value(byte[] bytes) {
            if (bytes.length != 2) {
                throw new IllegalArgumentException("Must have exactly 2 bytes");
            }
            ByteBuffer buf = ByteBuffer.wrap(bytes).order(ByteOrder.BIG_ENDIAN);
            this.value = buf.getShort();
        }

        public short shortValue() {
            return this.value;
        }

        @Override
        public byte[] encodeAsBytes() {
            ByteBuffer buf = ByteBuffer.allocate(2).order(ByteOrder.BIG_ENDIAN);
            buf.putShort(this.value);
            return buf.array();
        }

        public String toString() {
            return "word " + Integer.toHexString(this.value) + "h";
        }
    }

    @ForDebugValueType(value=DebugValueType.INT8)
    public static class DebugInt8Value
    implements DebugValue {
        private final byte value;

        public DebugInt8Value(byte value) {
            this.value = value;
        }

        public DebugInt8Value(byte[] bytes) {
            if (bytes.length != 1) {
                throw new IllegalArgumentException("Must have exactly 1 byte");
            }
            this.value = bytes[0];
        }

        public byte byteValue() {
            return this.value;
        }

        @Override
        public byte[] encodeAsBytes() {
            return new byte[]{this.value};
        }

        public String toString() {
            return "byte " + Integer.toHexString(this.value) + "h";
        }
    }

    public static enum DebugValueType {
        INVALID(0),
        INT8(8),
        INT16(16),
        INT32(32),
        INT64(64),
        FLOAT32(32),
        FLOAT64(64),
        FLOAT80(80),
        FLOAT82(82),
        FLOAT128(128),
        VECTOR64(64),
        VECTOR128(128);

        private static final Class<? extends DebugValue>[] CLASSES;
        public final int bitLength;
        public final int byteLength;

        public static DebugValueType getDebugValueTypeForClass(Class<? extends DebugValue> cls) {
            ForDebugValueType annot = cls.getAnnotation(ForDebugValueType.class);
            if (annot == null) {
                throw new AssertionError((Object)("INTERNAL: Missing ForDebugValueType annotation on " + cls));
            }
            return annot.value();
        }

        private DebugValueType(int bitLength) {
            this.bitLength = bitLength;
            this.byteLength = (bitLength + 7) / 8;
        }

        public Class<? extends DebugValue> getDebugValueClass() {
            return CLASSES[this.ordinal()];
        }

        public DebugValue decodeBytes(byte[] bytes) throws IllegalArgumentException {
            try {
                return CLASSES[this.ordinal()].getConstructor(byte[].class).newInstance(new Object[]{bytes});
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException e) {
                throw new AssertionError((Object)e);
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof IllegalArgumentException) {
                    throw (IllegalArgumentException)e.getCause();
                }
                throw new AssertionError((Object)e);
            }
        }

        static {
            Class[] supressed = new Class[DebugValueType.values().length];
            CLASSES = supressed;
            for (Class<?> cls : DebugValue.class.getDeclaredClasses()) {
                if (!DebugValue.class.isAssignableFrom(cls)) continue;
                Class<DebugValue> dvCls = cls.asSubclass(DebugValue.class);
                DebugValueType type = DebugValueType.getDebugValueTypeForClass(dvCls);
                DebugValueType.CLASSES[type.ordinal()] = dvCls;
            }
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface ForDebugValueType {
        public DebugValueType value();
    }
}

