/*
 * Decompiled with CFR 0.152.
 */
package agent.gdb.model.impl;

import agent.gdb.manager.GdbStackFrame;
import agent.gdb.manager.impl.cmd.GdbStateChangeRecord;
import agent.gdb.model.impl.GdbModelImpl;
import agent.gdb.model.impl.GdbModelSelectableObject;
import agent.gdb.model.impl.GdbModelTargetInferior;
import agent.gdb.model.impl.GdbModelTargetStack;
import agent.gdb.model.impl.GdbModelTargetStackFrameRegisterContainer;
import agent.gdb.model.impl.GdbModelTargetThread;
import ghidra.dbg.DebuggerModelListener;
import ghidra.dbg.agent.AbstractDebuggerObjectModel;
import ghidra.dbg.agent.DefaultTargetObject;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.TargetStackFrame;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetElementType;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import ghidra.dbg.util.PathUtils;
import ghidra.lifecycle.Internal;
import ghidra.program.model.address.Address;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

@TargetObjectSchemaInfo(name="StackFrame", elements={@TargetElementType(type=Void.class)}, attributes={@TargetAttributeType(type=Void.class)})
public class GdbModelTargetStackFrame
extends DefaultTargetObject<TargetObject, GdbModelTargetStack>
implements TargetStackFrame,
GdbModelSelectableObject {
    public static final String FUNC_ATTRIBUTE_NAME = "_function";
    public static final String FROM_ATTRIBUTE_NAME = "_from";
    protected final GdbModelImpl impl;
    protected final GdbModelTargetThread thread;
    protected final GdbModelTargetInferior inferior;
    protected GdbStackFrame frame;
    protected Address pc;
    protected String func;
    protected String display;
    private final GdbModelTargetStackFrameRegisterContainer registers;

    protected static String indexFrame(GdbStackFrame frame) {
        return PathUtils.makeIndex((int)frame.getLevel());
    }

    protected static String keyFrame(GdbStackFrame frame) {
        return PathUtils.makeKey((String)GdbModelTargetStackFrame.indexFrame(frame));
    }

    protected static String computeDisplay(GdbStackFrame frame) {
        return String.format("#%d 0x%s in %s ()", frame.getLevel(), frame.getAddress().toString(16), frame.getFunction());
    }

    public GdbModelTargetStackFrame(GdbModelTargetStack stack, GdbModelTargetThread thread, GdbModelTargetInferior inferior, GdbStackFrame frame) {
        super((AbstractDebuggerObjectModel)stack.impl, (TargetObject)stack, GdbModelTargetStackFrame.keyFrame(frame), "StackFrame");
        this.impl = stack.impl;
        this.thread = thread;
        this.inferior = inferior;
        this.impl.addModelObject(frame, this);
        this.registers = new GdbModelTargetStackFrameRegisterContainer(this);
        this.display = GdbModelTargetStackFrame.computeDisplay(frame);
        this.changeAttributes(List.of(), List.of(this.registers), Map.of("_display", this.display), "Initialized");
        this.setFrame(frame);
    }

    @TargetAttributeType(name="Registers", required=true, fixed=true)
    public GdbModelTargetStackFrameRegisterContainer getRegisters() {
        return this.registers;
    }

    protected void setFrame(GdbStackFrame frame) {
        if (this.frame == (frame = frame.fillWith(this.frame))) {
            return;
        }
        this.frame = frame;
        this.pc = this.impl.space.getAddress(frame.getAddress().longValue());
        this.func = frame.getFunction();
        this.display = GdbModelTargetStackFrame.computeDisplay(frame);
        this.changeAttributes(List.of(), List.of(this.registers), Map.of("_pc", this.pc, FUNC_ATTRIBUTE_NAME, this.func, "_display", this.display, "_value", this.pc), "Refreshed");
    }

    protected void invalidateRegisterCaches() {
        ((DebuggerModelListener)this.listeners.fire).invalidateCacheRequested((TargetObject)this);
    }

    @Override
    @Internal
    public CompletableFuture<Void> setActive() {
        return this.impl.gateFuture(this.frame.setActive(false));
    }

    @TargetAttributeType(name="_function")
    public String getFunction() {
        return this.func;
    }

    public Address getProgramCounter() {
        return this.pc;
    }

    public CompletableFuture<Void> stateChanged(GdbStateChangeRecord sco) {
        return this.registers.stateChanged(sco);
    }
}

