/*
 * Decompiled with CFR 0.152.
 */
package agent.gdb.manager.impl.cmd;

import agent.gdb.manager.evt.GdbCommandDoneEvent;
import agent.gdb.manager.evt.GdbThreadSelectedEvent;
import agent.gdb.manager.impl.GdbEvent;
import agent.gdb.manager.impl.GdbManagerImpl;
import agent.gdb.manager.impl.GdbPendingCommand;
import agent.gdb.manager.impl.GdbStackFrameImpl;
import agent.gdb.manager.impl.GdbThreadImpl;
import agent.gdb.manager.impl.cmd.AbstractGdbCommandWithThreadAndFrameId;
import agent.gdb.manager.parsing.GdbMiParser;

public class GdbSetActiveThreadCommand
extends AbstractGdbCommandWithThreadAndFrameId<Void> {
    private final boolean internal;

    public GdbSetActiveThreadCommand(GdbManagerImpl manager, int threadId, Integer frameId, boolean internal) {
        super(manager, threadId, frameId);
        this.internal = internal;
    }

    @Override
    public String encode(String threadPart, String framePart) {
        return "-thread-select" + threadPart + framePart + " " + this.threadId;
    }

    @Override
    public boolean handle(GdbEvent<?> evt, GdbPendingCommand<?> pending) {
        if (super.handle(evt, pending)) {
            return true;
        }
        if (evt instanceof GdbThreadSelectedEvent) {
            pending.claim(evt);
        }
        return false;
    }

    @Override
    public Void complete(GdbPendingCommand<?> pending) {
        GdbCommandDoneEvent done = (GdbCommandDoneEvent)pending.checkCompletion(GdbCommandDoneEvent.class);
        GdbThreadSelectedEvent already = pending.getFirstOf(GdbThreadSelectedEvent.class);
        if (already != null) {
            return null;
        }
        GdbThreadImpl thread = this.manager.getThread(this.threadId);
        GdbMiParser.GdbMiFieldList fields = ((GdbMiParser.GdbMiFieldList)done.getInfo()).getFieldList("frame");
        if (fields == null) {
            return null;
        }
        GdbStackFrameImpl frame = GdbStackFrameImpl.fromFieldList(thread, fields);
        this.manager.doThreadSelected(thread, frame, done.getCause());
        return null;
    }

    @Override
    public boolean isFocusInternallyDriven() {
        return this.internal;
    }
}

