/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main;

import docking.options.editor.ButtonPanelFactory;
import docking.widgets.checkbox.GCheckBox;
import docking.widgets.list.GListCellRenderer;
import docking.widgets.table.GTable;
import docking.wizard.AbstractWizardJPanel;
import ghidra.framework.client.RepositoryAdapter;
import ghidra.framework.main.UserAccessTableModel;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.framework.remote.User;
import ghidra.util.HelpLocation;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.table.TableModel;
import resources.ResourceManager;
import util.CollectionUtils;

public class ProjectAccessPanel
extends AbstractWizardJPanel {
    protected KnownUsersPanel knownUsersPanel;
    protected UserAccessPanel userAccessPanel;
    protected ButtonPanel addRemoveButtonPanel;
    protected JCheckBox anonymousAccessCB;
    protected String currentUser;
    protected List<User> origProjectUserList;
    protected boolean origAnonymousAccessEnabled;
    protected String repositoryName;
    protected HelpLocation helpLoc;
    protected final Color SELECTION_BG_COLOR = new Color(204, 204, 255);
    protected final Color SELECTION_FG_COLOR = Color.BLACK;
    protected PluginTool tool;

    public ProjectAccessPanel(String[] knownUsers, RepositoryAdapter repository, PluginTool tool) throws IOException {
        this(knownUsers, repository.getServer().getUser(), Arrays.asList(repository.getUserList()), repository.getName(), repository.getServer().anonymousAccessAllowed(), repository.anonymousAccessAllowed(), tool);
    }

    public ProjectAccessPanel(String[] knownUsers, String currentUser, List<User> allUsers, String repositoryName, boolean anonymousServerAccessAllowed, boolean anonymousAccessEnabled, PluginTool tool) {
        super((LayoutManager)new BorderLayout());
        this.currentUser = currentUser;
        this.origProjectUserList = allUsers;
        this.origAnonymousAccessEnabled = anonymousAccessEnabled;
        this.repositoryName = repositoryName;
        this.tool = tool;
        this.createMainPanel(knownUsers, anonymousServerAccessAllowed);
    }

    public boolean isValidInformation() {
        return true;
    }

    public String getTitle() {
        return "Specify Users for Repository " + this.repositoryName;
    }

    public void initialize() {
        this.userAccessPanel.resetUserList();
        if (this.anonymousAccessCB != null) {
            this.anonymousAccessCB.setSelected(this.origAnonymousAccessEnabled);
        }
    }

    public HelpLocation getHelpLocation() {
        if (this.helpLoc != null) {
            return this.helpLoc;
        }
        return new HelpLocation("FrontEndPlugin", "UserAccessList");
    }

    void setHelpLocation(HelpLocation helpLoc) {
        this.helpLoc = helpLoc;
    }

    User[] getProjectUsers() {
        return this.userAccessPanel.getProjectUsers();
    }

    boolean allowAnonymousAccess() {
        return this.anonymousAccessCB != null && this.anonymousAccessCB.isSelected();
    }

    String getRepositoryName() {
        return this.repositoryName;
    }

    protected void createMainPanel(String[] knownUsers, boolean anonymousServerAccessAllowed) {
        JPanel mainPanel = new JPanel();
        mainPanel.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        mainPanel.setLayout(new BoxLayout(mainPanel, 0));
        this.knownUsersPanel = new KnownUsersPanel(Arrays.asList(knownUsers));
        this.userAccessPanel = new UserAccessPanel(this.currentUser);
        this.addRemoveButtonPanel = new ButtonPanel();
        mainPanel.add(this.knownUsersPanel);
        mainPanel.add(this.addRemoveButtonPanel);
        mainPanel.add(this.userAccessPanel);
        this.add(mainPanel, "Center");
        if (anonymousServerAccessAllowed) {
            this.anonymousAccessCB = new GCheckBox("Allow Anonymous Access", this.origAnonymousAccessEnabled);
            this.anonymousAccessCB.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 0));
            this.add(this.anonymousAccessCB, "South");
        }
    }

    class KnownUsersPanel
    extends JPanel {
        private static final int DEFAULT_USERLIST_ROWS_TO_SHOW = 20;
        private JList<String> userList;
        private DefaultListModel<String> listModel;

        KnownUsersPanel(List<String> users) {
            this.setLayout(new BorderLayout());
            users.sort(String::compareToIgnoreCase);
            this.listModel = new DefaultListModel();
            for (String user : users) {
                this.listModel.addElement(user);
            }
            this.userList = new JList<String>(this.listModel);
            this.userList.setSelectionBackground(ProjectAccessPanel.this.SELECTION_BG_COLOR);
            this.userList.setSelectionForeground(ProjectAccessPanel.this.SELECTION_FG_COLOR);
            this.userList.setCellRenderer((ListCellRenderer<String>)((Object)new UserListCellRenderer()));
            JScrollPane sp = new JScrollPane(this.userList);
            sp.setBorder(BorderFactory.createTitledBorder("Known Users"));
            sp.setOpaque(false);
            Dimension d = this.userList.getPreferredSize();
            d.width = 100;
            d.height = Math.min(this.userList.getFixedCellHeight() * 20, d.height);
            sp.setPreferredSize(d);
            sp.setMinimumSize(new Dimension(100, 200));
            this.add((Component)sp, "Center");
        }

        List<String> getSelectedUsers() {
            return this.userList.getSelectedValuesList();
        }

        JList<String> getList() {
            return this.userList;
        }

        List<String> getAllUsers() {
            List allUsers = CollectionUtils.asList(this.listModel.elements());
            return allUsers;
        }

        void clearSelection() {
            this.userList.getSelectionModel().clearSelection();
        }

        private class UserListCellRenderer
        extends GListCellRenderer<String> {
            private Icon icon = ResourceManager.loadImage((String)"images/EmptyIcon.gif");
            private Icon inProjectIcon = ResourceManager.loadImage((String)"images/user.png");

            UserListCellRenderer() {
                this.icon = ResourceManager.getScaledIcon((Icon)this.icon, (int)this.inProjectIcon.getIconWidth(), (int)this.inProjectIcon.getIconHeight());
            }

            public Component getListCellRendererComponent(JList<? extends String> list, String username, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent(list, (Object)username, index, isSelected, cellHasFocus);
                if (ProjectAccessPanel.this.userAccessPanel != null) {
                    this.setIcon(ProjectAccessPanel.this.userAccessPanel.isInProjectAccessList(username) ? this.inProjectIcon : this.icon);
                }
                return this;
            }
        }
    }

    class UserAccessPanel
    extends JPanel {
        private GTable table;
        private UserAccessTableModel tableModel;

        UserAccessPanel(String user) {
            this.setLayout(new BorderLayout());
            this.tableModel = new UserAccessTableModel(user, ProjectAccessPanel.this.origProjectUserList, (ServiceProvider)ProjectAccessPanel.this.tool);
            this.table = new GTable((TableModel)((Object)this.tableModel));
            this.table.setShowGrid(false);
            this.table.setSelectionBackground(ProjectAccessPanel.this.SELECTION_BG_COLOR);
            this.table.setSelectionForeground(ProjectAccessPanel.this.SELECTION_FG_COLOR);
            this.table.setSelectionMode(2);
            this.table.setBorder(BorderFactory.createEmptyBorder());
            JScrollPane sp = new JScrollPane((Component)this.table);
            sp.setBorder(BorderFactory.createTitledBorder("Project Users"));
            sp.setBackground(this.getBackground());
            this.add((Component)sp, "Center");
            this.setPreferredSize(new Dimension(400, 200));
        }

        GTable getTable() {
            return this.table;
        }

        void resetUserList() {
            this.tableModel.setUserList(ProjectAccessPanel.this.origProjectUserList);
        }

        List<String> getSelectedUsers() {
            ArrayList<String> users = new ArrayList<String>();
            int[] selectedRows = this.table.getSelectedRows();
            for (int i = 0; i < selectedRows.length; ++i) {
                User user = (User)this.tableModel.getRowObject(selectedRows[i]);
                users.add(user.getName());
            }
            return users;
        }

        boolean isInProjectAccessList(String name) {
            Object usersInProject = this.tableModel.getDataSource();
            Iterator iterator = usersInProject.iterator();
            while (iterator.hasNext()) {
                User user = (User)iterator.next();
                if (!user.getName().equals(name)) continue;
                return true;
            }
            return false;
        }

        User[] getProjectUsers() {
            User[] users = new User[this.tableModel.getModelData().size()];
            return this.tableModel.getModelData().toArray(users);
        }

        private void removeAllUsers() {
            ArrayList<User> list = new ArrayList<User>();
            for (User user : this.tableModel.getModelData()) {
                if (user.getName().equals(ProjectAccessPanel.this.currentUser)) continue;
                list.add(user);
            }
            this.tableModel.removeUsers(list);
        }

        private void removeSelectedUsers() {
            ArrayList<User> users = new ArrayList<User>();
            for (int selectedRow : this.table.getSelectedRows()) {
                User user = (User)this.tableModel.getRowObject(selectedRow);
                if (user.getName().equals(ProjectAccessPanel.this.currentUser)) continue;
                users.add(user);
            }
            this.tableModel.removeUsers(users);
        }

        private void addUsers(List<String> users) {
            ArrayList<User> list = new ArrayList<User>();
            for (String user : users) {
                if (this.isInProjectAccessList(user)) continue;
                list.add(new User(user, 1));
            }
            this.tableModel.addUsers(list);
        }
    }

    class ButtonPanel
    extends JPanel {
        private JButton addButton = new JButton("Add >>");
        private JButton addAllButton;
        private JButton removeButton;
        private JButton removeAllButton;

        public ButtonPanel() {
            this.addButton.setEnabled(false);
            this.addButton.addActionListener(e -> ProjectAccessPanel.this.userAccessPanel.addUsers(ProjectAccessPanel.this.knownUsersPanel.getSelectedUsers()));
            this.addAllButton = new JButton("Add All");
            this.addAllButton.addActionListener(e -> {
                ProjectAccessPanel.this.userAccessPanel.addUsers(ProjectAccessPanel.this.knownUsersPanel.getAllUsers());
                ProjectAccessPanel.this.knownUsersPanel.clearSelection();
            });
            this.addAllButton.setEnabled(true);
            this.removeButton = new JButton("<< Remove");
            this.removeButton.setEnabled(false);
            this.removeButton.addActionListener(e -> ProjectAccessPanel.this.userAccessPanel.removeSelectedUsers());
            this.removeAllButton = new JButton("Remove All");
            this.removeAllButton.addActionListener(e -> {
                ProjectAccessPanel.this.userAccessPanel.removeAllUsers();
                ProjectAccessPanel.this.knownUsersPanel.clearSelection();
            });
            this.removeAllButton.setEnabled(true);
            JPanel panel = ButtonPanelFactory.createButtonPanel((JButton[])new JButton[]{this.addButton, this.addAllButton, this.removeButton, this.removeAllButton}, (int)5);
            panel.setMinimumSize(panel.getPreferredSize());
            ProjectAccessPanel.this.userAccessPanel.getTable().getSelectionModel().addListSelectionListener(e -> {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                this.updateState();
            });
            ProjectAccessPanel.this.userAccessPanel.tableModel.addTableModelListener(e -> ProjectAccessPanel.this.knownUsersPanel.repaint());
            ProjectAccessPanel.this.knownUsersPanel.getList().getSelectionModel().addListSelectionListener(e -> {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                this.updateState();
            });
            this.add(panel);
        }

        public void updateState() {
            this.updateAddButtonState();
            this.updateRemoveButtonState();
        }

        private void updateRemoveButtonState() {
            boolean enabled = false;
            List<String> selectedUserNames = ProjectAccessPanel.this.userAccessPanel.getSelectedUsers();
            enabled = selectedUserNames.isEmpty() ? false : (selectedUserNames.size() == 1 ? !selectedUserNames.get(0).equals(ProjectAccessPanel.this.currentUser) : true);
            this.removeButton.setEnabled(enabled);
        }

        private void updateAddButtonState() {
            boolean enabled = false;
            List<String> selectedUserNames = ProjectAccessPanel.this.knownUsersPanel.getSelectedUsers();
            for (String user : selectedUserNames) {
                if (ProjectAccessPanel.this.userAccessPanel.isInProjectAccessList(user)) continue;
                enabled = true;
                break;
            }
            this.addButton.setEnabled(enabled);
        }
    }
}

