/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.graph;

import ghidra.util.graph.DirectedGraph;
import ghidra.util.graph.Edge;
import ghidra.util.graph.WeightedDigraph;

public class SimpleWeightedDigraph
extends WeightedDigraph {
    private final boolean allowLoops;

    public SimpleWeightedDigraph(int vertexCapacity, int edgeCapacity, double defaultEdgeWeight, boolean loopsAllowed) {
        super(vertexCapacity, edgeCapacity, defaultEdgeWeight);
        this.allowLoops = loopsAllowed;
    }

    public SimpleWeightedDigraph(int vertexCapacity, int edgeCapacity, double defaultEdgeWeight) {
        super(vertexCapacity, edgeCapacity, defaultEdgeWeight);
        this.allowLoops = false;
    }

    public SimpleWeightedDigraph(int vertexCapacity, int edgeCapacity) {
        super(vertexCapacity, edgeCapacity, 1.0);
        this.allowLoops = false;
    }

    @Override
    public boolean add(Edge e) {
        if (!this.allowLoops && e.from() == e.to()) {
            return false;
        }
        Edge[] ft = this.getEdges(e.from(), e.to());
        if (ft.length == 0) {
            return super.add(e);
        }
        return this.setWeight(ft[0], this.getWeight(ft[0]) + this.getDefaultEdgeWeight());
    }

    @Override
    public boolean add(Edge e, double weight) {
        if (!this.allowLoops && e.from() == e.to()) {
            return false;
        }
        Edge[] ft = this.getEdges(e.from(), e.to());
        if (ft.length == 0) {
            return super.add(e, weight);
        }
        return this.setWeight(ft[0], this.getWeight(ft[0]) + weight);
    }

    @Override
    public boolean remove(Edge e) {
        Edge[] ft = this.getEdges(e.from(), e.to());
        if (ft.length == 0) {
            return false;
        }
        return super.remove(ft[0]);
    }

    @Override
    public double getWeight(Edge e) {
        Edge[] ft = this.getEdges(e.from(), e.to());
        if (ft.length == 0) {
            return 0.0;
        }
        return super.getWeight(ft[0]);
    }

    @Override
    public DirectedGraph copy() {
        SimpleWeightedDigraph copy = new SimpleWeightedDigraph(this.numVertices(), this.numEdges(), this.getDefaultEdgeWeight(), this.allowLoops);
        this.copyAll(copy);
        return copy;
    }
}

