/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.classfinder;

import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.HashSet;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

abstract class ClassLocation {
    protected static final String CLASS_EXT = ".class";
    final Logger log = LogManager.getLogger(this.getClass());
    protected Set<Class<?>> classes = new HashSet();

    ClassLocation() {
    }

    abstract void getClasses(Set<Class<?>> var1, TaskMonitor var2) throws CancelledException;

    void checkForDuplicates(Set<Class<?>> existingClasses) {
        if (!this.log.isTraceEnabled()) {
            return;
        }
        for (Class<?> c : this.classes) {
            if (!existingClasses.contains(c)) continue;
            Module module = c.getModule();
            module.toString();
            this.log.trace("Attempting to load the same class twice: {}.  Keeping loaded class ; ignoring class from {}", c, (Object)this);
            return;
        }
    }
}

