/*
 * Decompiled with CFR 0.152.
 */
package ghidra.net;

import generic.random.SecureRandomFactory;
import ghidra.net.ApplicationKeyManagerFactory;
import ghidra.net.ApplicationTrustManagerFactory;
import ghidra.net.SignedToken;
import ghidra.util.Msg;
import ghidra.util.exception.AssertException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.UnrecoverableEntryException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Base64;
import java.util.Date;
import java.util.HashSet;
import javax.net.ssl.KeyManager;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.Destroyable;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.X500NameStyle;
import org.bouncycastle.asn1.x500.style.RFC4519Style;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;

public class ApplicationKeyManagerUtils {
    public static final String RSA_TYPE = "RSA";
    private static final int KEY_SIZE = 4096;
    private static final String SIGNING_ALGORITHM = "SHA512withRSA";
    private static final int MILLISECONDS_PER_DAY = 86400000;
    public static final String BEGIN_CERT = "-----BEGIN CERTIFICATE-----";
    public static final String END_CERT = "-----END CERTIFICATE-----";

    private ApplicationKeyManagerUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SignedToken getSignedToken(Principal[] authorities, byte[] token) throws NoSuchAlgorithmException, SignatureException, CertificateException {
        Destroyable privateKey = null;
        X509Certificate[] certificateChain = null;
        try {
            ApplicationKeyManagerFactory keyManagerFactory = ApplicationKeyManagerFactory.getInstance();
            for (KeyManager keyManager : keyManagerFactory.getKeyManagers()) {
                if (!(keyManager instanceof X509KeyManager)) continue;
                X509KeyManager x509KeyManager = (X509KeyManager)keyManager;
                String alias = x509KeyManager.chooseClientAlias(new String[]{RSA_TYPE}, authorities, null);
                if (alias == null) continue;
                privateKey = x509KeyManager.getPrivateKey(alias);
                certificateChain = x509KeyManager.getCertificateChain(alias);
                break;
            }
            if (privateKey == null || certificateChain == null) {
                CertificateException e = new CertificateException("suitable PKI certificate not found");
                e.printStackTrace();
                throw e;
            }
            String algorithm = certificateChain[0].getSigAlgName();
            Signature sig = Signature.getInstance(algorithm);
            try {
                sig.initSign((PrivateKey)privateKey);
            }
            catch (InvalidKeyException e) {
                throw new CertificateException("suitable PKI certificate not found", e);
            }
            sig.update(token);
            SignedToken signedToken = new SignedToken(token, sig.sign(), certificateChain, algorithm);
            return signedToken;
        }
        finally {
            if (privateKey != null) {
                try {
                    privateKey.destroy();
                }
                catch (DestroyFailedException destroyFailedException) {}
            }
        }
    }

    public static boolean isMySignature(Principal[] authorities, byte[] token, byte[] signature) throws NoSuchAlgorithmException, SignatureException, CertificateException {
        SignedToken signedToken = ApplicationKeyManagerUtils.getSignedToken(authorities, token);
        return Arrays.equals(signature, signedToken.signature);
    }

    public static X500Principal[] getTrustedIssuers() throws CertificateException {
        TrustManager[] trustManagers = ApplicationTrustManagerFactory.getTrustManagers();
        if (ApplicationTrustManagerFactory.hasCertError()) {
            throw new CertificateException("failed to load CA certs", ApplicationTrustManagerFactory.getCertError());
        }
        HashSet<X500Principal> set = new HashSet<X500Principal>();
        boolean openTrust = true;
        for (TrustManager trustManager : trustManagers) {
            if (!(trustManager instanceof X509TrustManager)) {
                Msg.warn(ApplicationKeyManagerUtils.class, (Object)("Unexpected trust manager implementation: " + trustManager.getClass().getName()));
                openTrust = false;
                continue;
            }
            X509TrustManager x509TrustManager = (X509TrustManager)trustManager;
            X509Certificate[] acceptedIssuers = x509TrustManager.getAcceptedIssuers();
            if (acceptedIssuers == null) continue;
            openTrust = false;
            for (X509Certificate trustedCert : acceptedIssuers) {
                set.add(trustedCert.getSubjectX500Principal());
            }
        }
        if (openTrust) {
            return null;
        }
        X500Principal[] principals = new X500Principal[set.size()];
        return set.toArray(principals);
    }

    public static void validateClient(X509Certificate[] certChain, String authType) throws CertificateException {
        CertificateException checkFailure = null;
        TrustManager[] trustManagers = ApplicationTrustManagerFactory.getTrustManagers();
        if (ApplicationTrustManagerFactory.hasCertError()) {
            throw new CertificateException("failed to load CA certs", ApplicationTrustManagerFactory.getCertError());
        }
        for (TrustManager trustManager : trustManagers) {
            if (!(trustManager instanceof X509TrustManager)) continue;
            X509TrustManager x509TrustManager = (X509TrustManager)trustManager;
            try {
                x509TrustManager.checkClientTrusted(certChain, authType);
                checkFailure = null;
                break;
            }
            catch (CertificateException e) {
                checkFailure = e;
            }
        }
        if (checkFailure != null) {
            throw checkFailure;
        }
    }

    private static Certificate[] makeCertificateChain(Certificate cert, Certificate ... caCerts) {
        Certificate[] chain = new Certificate[caCerts.length + 1];
        chain[0] = cert;
        System.arraycopy(caCerts, 0, chain, 1, caCerts.length);
        return chain;
    }

    public static void exportX509Certificates(Certificate[] certificates, File outFile) throws IOException, CertificateEncodingException {
        try (FileOutputStream fout = new FileOutputStream(outFile);
             PrintWriter writer = new PrintWriter(fout);){
            for (Certificate certificate : certificates) {
                if (!(certificate instanceof X509Certificate)) continue;
                writer.println(BEGIN_CERT);
                String base64 = Base64.getEncoder().encodeToString(certificate.getEncoded());
                while (base64.length() != 0) {
                    int endIndex = Math.min(44, base64.length());
                    String line = base64.substring(0, endIndex);
                    writer.println(line);
                    base64 = base64.substring(endIndex);
                }
                writer.println(END_CERT);
                writer.println();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final KeyStore createKeyStore(String alias, String dn, int durationDays, KeyStore.PrivateKeyEntry caEntry, File keyFile, String keystoreType, char[] protectedPassphrase) throws KeyStoreException {
        final KeyStore.PasswordProtection pp = new KeyStore.PasswordProtection(protectedPassphrase);
        KeyStore.LoadStoreParameter loadStoreParameter = null;
        if (keyFile != null && keyFile.exists()) {
            loadStoreParameter = new KeyStore.LoadStoreParameter(){

                @Override
                public KeyStore.ProtectionParameter getProtectionParameter() {
                    return pp;
                }
            };
        }
        try {
            X500Name x500Name;
            KeyStore keyStore = KeyStore.getInstance(keystoreType);
            keyStore.load(loadStoreParameter);
            SecureRandom random = SecureRandomFactory.getSecureRandom();
            KeyPairGenerator rsa = KeyPairGenerator.getInstance(RSA_TYPE);
            rsa.initialize(4096);
            KeyPair keyPair = rsa.generateKeyPair();
            PrivateKey issuerKey = keyPair.getPrivate();
            byte[] encodedPublicKey = keyPair.getPublic().getEncoded();
            SubjectPublicKeyInfo bcPk = SubjectPublicKeyInfo.getInstance((Object)encodedPublicKey);
            X500Name caX500Name = x500Name = new X500Name(dn);
            KeyUsage keyUsage = new KeyUsage(164);
            if (caEntry != null) {
                Certificate caCert = caEntry.getCertificate();
                if (!(caCert instanceof X509Certificate)) {
                    throw new CertificateException("Unsupported certificate type: " + caCert.getType());
                }
                X509Certificate caX509Cert = (X509Certificate)caCert;
                caX500Name = new X500Name(caX509Cert.getSubjectDN().getName());
                keyUsage = new KeyUsage(160);
                issuerKey = caEntry.getPrivateKey();
            }
            Date notBefore = new Date();
            long durationMs = (long)durationDays * 86400000L;
            Date notAfter = new Date(notBefore.getTime() + durationMs);
            BigInteger serialNumber = new BigInteger(128, random);
            X509v3CertificateBuilder certificateBuilder = new X509v3CertificateBuilder(caX500Name, serialNumber, notBefore, notAfter, x500Name, bcPk);
            certificateBuilder.addExtension(Extension.keyUsage, true, (ASN1Encodable)keyUsage);
            if (caEntry == null) {
                certificateBuilder.addExtension(Extension.basicConstraints, true, (ASN1Encodable)new BasicConstraints(1));
            }
            ContentSigner contentSigner = new JcaContentSignerBuilder(SIGNING_ALGORITHM).build(issuerKey);
            X509Certificate certificate = new JcaX509CertificateConverter().getCertificate(certificateBuilder.build(contentSigner));
            Certificate[] chain = caEntry == null ? new Certificate[]{certificate} : ApplicationKeyManagerUtils.makeCertificateChain(certificate, caEntry.getCertificateChain());
            keyStore.setKeyEntry(alias, keyPair.getPrivate(), protectedPassphrase, chain);
            if (keyFile != null) {
                try (FileOutputStream out = new FileOutputStream(keyFile);){
                    keyStore.store(out, protectedPassphrase);
                    out.flush();
                    out.getFD().sync();
                    Msg.debug(ApplicationKeyManagerUtils.class, (Object)(out.getChannel().size() + " bytes written to key/cert file: " + keyFile));
                }
                keyFile.setReadable(true, true);
                keyFile.setWritable(false);
            }
            Msg.debug(ApplicationKeyManagerUtils.class, (Object)("Certificate Generated (" + alias + "): " + dn));
            KeyStore keyStore2 = keyStore;
            return keyStore2;
        }
        catch (IOException | GeneralSecurityException | OperatorException e) {
            throw new KeyStoreException("Failed to generate/store certificate (" + dn + ")", e);
        }
        finally {
            try {
                pp.destroy();
            }
            catch (DestroyFailedException e) {
                throw new AssertException((Throwable)e);
            }
        }
    }

    public static final KeyStore.PrivateKeyEntry createKeyEntry(String alias, String dn, int durationDays, KeyStore.PrivateKeyEntry caEntry, File keyFile, String keystoreType, char[] protectedPassphrase) throws KeyStoreException {
        KeyStore.PasswordProtection pp = new KeyStore.PasswordProtection(protectedPassphrase);
        try {
            KeyStore keyStore = ApplicationKeyManagerUtils.createKeyStore(alias, dn, durationDays, caEntry, keyFile, keystoreType, protectedPassphrase);
            KeyStore.PrivateKeyEntry privateKeyEntry = (KeyStore.PrivateKeyEntry)keyStore.getEntry(alias, pp);
            return privateKeyEntry;
        }
        catch (NoSuchAlgorithmException | UnrecoverableEntryException e) {
            throw new KeyStoreException("Failed to generate/store certificate (" + dn + ")", e);
        }
        finally {
            try {
                pp.destroy();
            }
            catch (DestroyFailedException e) {
                throw new AssertException((Throwable)e);
            }
        }
    }

    static {
        X500Name.setDefaultStyle((X500NameStyle)RFC4519Style.INSTANCE);
    }
}

