/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.layout.util.synthetics;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jungrapht.visualization.layout.model.Point;

public class ArticulatedEdge<V, E> {
    protected E edge;
    protected V source;
    protected V target;
    protected final List<V> intermediateVertices = new ArrayList<V>();
    protected final List<Point> intermediatePoints = new ArrayList<Point>();

    public static <V, E> ArticulatedEdge of(E edge, V source, V target) {
        return new ArticulatedEdge<V, E>(edge, source, target);
    }

    protected ArticulatedEdge(E edge, V source, V target) {
        this.edge = edge;
        this.source = source;
        this.target = target;
    }

    public E getEdge() {
        return this.edge;
    }

    public V getSource() {
        return this.source;
    }

    public V getTarget() {
        return this.target;
    }

    public List<Point> getIntermediatePoints() {
        return this.intermediatePoints;
    }

    public void addIntermediateVertex(V v) {
        this.intermediateVertices.add(v);
    }

    public void addIntermediatePoint(Point p) {
        this.intermediatePoints.add(p);
    }

    public List<V> getIntermediateVertices() {
        return Collections.unmodifiableList(this.intermediateVertices);
    }

    public ArticulatedEdge<V, E> reversed() {
        ArticulatedEdge reversed = ArticulatedEdge.of(this.edge, this.target, this.source);
        this.intermediateVertices.forEach(v -> reversed.intermediateVertices.add(0, v));
        this.intermediatePoints.forEach(v -> reversed.intermediatePoints.add(0, (Point)v));
        return reversed;
    }

    public boolean equals(Object o) {
        return this == o;
    }

    public int hashCode() {
        return System.identityHashCode(this);
    }

    public String toString() {
        return "ArticulatedEdge{edge=" + this.edge + ", source=" + this.source + ", intermediateVertices=" + this.intermediateVertices + ", target=" + this.target + "}";
    }
}

