/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.exec;

import ghidra.app.services.TraceRecorder;
import ghidra.pcode.exec.AsyncWrappedPcodeExecutorState;
import ghidra.pcode.exec.trace.TraceBytesPcodeExecutorState;
import ghidra.pcode.exec.trace.TraceMemoryStatePcodeExecutorStatePiece;
import ghidra.pcode.utils.Utils;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.trace.model.memory.TraceMemoryState;
import ghidra.trace.model.thread.TraceThread;
import ghidra.util.task.TaskMonitor;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.concurrent.CompletableFuture;

public class TraceRecorderAsyncPcodeExecutorState
extends AsyncWrappedPcodeExecutorState<byte[]> {
    private final TraceRecorder recorder;
    private final TraceBytesPcodeExecutorState traceState;
    private final TraceMemoryStatePcodeExecutorStatePiece traceMemState;

    public TraceRecorderAsyncPcodeExecutorState(TraceRecorder recorder, long snap, TraceThread thread, int frame) {
        super(new TraceBytesPcodeExecutorState(recorder.getTrace(), snap, thread, frame));
        this.recorder = recorder;
        this.traceState = (TraceBytesPcodeExecutorState)this.state;
        this.traceMemState = new TraceMemoryStatePcodeExecutorStatePiece(recorder.getTrace(), snap, thread, frame);
    }

    protected CompletableFuture<?> doSetTargetVar(AddressSpace space, long offset, int size, boolean truncateAddressableUnit, byte[] val) {
        return this.recorder.writeVariable(this.traceState.getThread(), 0, space.getAddress(offset), val);
    }

    protected byte[] knitFromResults(NavigableMap<Address, byte[]> map, Address addr, int size) {
        Map.Entry ent;
        long off;
        Address floor = map.floorKey(addr);
        NavigableMap<Address, byte[]> tail = floor == null ? map : map.tailMap(floor, true);
        byte[] result = new byte[size];
        Iterator iterator = tail.entrySet().iterator();
        while (iterator.hasNext() && (off = ((Address)(ent = iterator.next()).getKey()).subtract(addr)) < (long)size && off >= 0L) {
            int subSize = Math.min(size - (int)off, ((byte[])ent.getValue()).length);
            System.arraycopy(ent.getValue(), 0, result, (int)off, subSize);
        }
        return result;
    }

    protected CompletableFuture<byte[]> doGetTargetVar(AddressSpace space, long offset, int size, boolean truncateAddressableUnit) {
        if (space.isMemorySpace()) {
            Address addr = space.getAddress(this.truncateOffset(space, offset));
            AddressSet set = new AddressSet(addr, space.getAddress(offset + (long)size - 1L));
            CompletableFuture<NavigableMap<Address, byte[]>> future = this.recorder.captureProcessMemory((AddressSetView)set, TaskMonitor.DUMMY, true);
            return future.thenApply(map -> this.knitFromResults((NavigableMap<Address, byte[]>)map, addr, size));
        }
        assert (space.isRegisterSpace());
        Language lang = this.recorder.getTrace().getBaseLanguage();
        Register register = lang.getRegister(space, offset, size);
        if (register == null) {
            throw new IllegalArgumentException("read from register space must be from one register");
        }
        Register baseRegister = register.getBaseRegister();
        CompletableFuture<Map<Register, RegisterValue>> future = this.recorder.captureThreadRegisters(this.traceState.getThread(), this.traceState.getFrame(), Set.of(baseRegister));
        return future.thenApply(map -> {
            RegisterValue baseVal = (RegisterValue)map.get(baseRegister);
            if (baseVal == null) {
                return (byte[])this.state.getVar(space, offset, size, truncateAddressableUnit);
            }
            BigInteger val = baseVal.getRegisterValue(register).getUnsignedValue();
            return Utils.bigIntegerToBytes((BigInteger)val, (int)size, (boolean)this.recorder.getTrace().getBaseLanguage().isBigEndian());
        });
    }

    protected boolean isTargetSpace(AddressSpace space) {
        return this.traceState.getSnap() == this.recorder.getSnap() && !space.isConstantSpace() && !space.isUniqueSpace();
    }

    @Override
    protected CompletableFuture<?> doSetVar(AddressSpace space, CompletableFuture<byte[]> offset, int size, boolean truncateAddressableUnit, CompletableFuture<byte[]> val) {
        if (!this.isTargetSpace(space)) {
            return super.doSetVar(space, offset, size, truncateAddressableUnit, val);
        }
        return offset.thenCompose(off -> val.thenCompose(v -> this.doSetTargetVar(space, this.traceState.offsetToLong(off), size, truncateAddressableUnit, (byte[])v)));
    }

    @Override
    protected CompletableFuture<byte[]> doGetVar(AddressSpace space, CompletableFuture<byte[]> offset, int size, boolean truncateAddressableUnit) {
        if (!this.isTargetSpace(space)) {
            return super.doGetVar(space, offset, size, truncateAddressableUnit);
        }
        return offset.thenCompose(off -> {
            TraceMemoryState ms = (TraceMemoryState)this.traceMemState.getVar(space, off, size, truncateAddressableUnit);
            if (ms == TraceMemoryState.KNOWN) {
                return super.doGetVar(space, offset, size, truncateAddressableUnit);
            }
            return this.doGetTargetVar(space, this.traceState.offsetToLong(off), size, truncateAddressableUnit);
        });
    }
}

