/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.services;

import ghidra.framework.model.DomainObject;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Bookmark;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.trace.model.Trace;
import ghidra.trace.model.breakpoint.TraceBreakpoint;
import ghidra.trace.model.breakpoint.TraceBreakpointKind;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.CompletableFuture;

public interface LogicalBreakpoint {
    public static final String BREAKPOINT_ENABLED_BOOKMARK_TYPE = "BreakpointEnabled";
    public static final String BREAKPOINT_DISABLED_BOOKMARK_TYPE = "BreakpointDisabled";

    public boolean isEmpty();

    public Set<TraceBreakpointKind> getKinds();

    default public Program getProgram() {
        ProgramLocation loc = this.getProgramLocation();
        return loc == null ? null : loc.getProgram();
    }

    public Bookmark getProgramBookmark();

    public ProgramLocation getProgramLocation();

    public long getLength();

    public Set<TraceBreakpoint> getTraceBreakpoints();

    public Set<TraceBreakpoint> getTraceBreakpoints(Trace var1);

    public Set<Trace> getMappedTraces();

    public Set<Trace> getParticipatingTraces();

    public Address getTraceAddress(Trace var1);

    public DomainObject getDomainObject();

    public Address getAddress();

    public Enablement computeEnablementForProgram(Program var1);

    public Enablement computeEnablementForTrace(Trace var1);

    public Enablement computeEnablement();

    public void enableForProgram();

    public void disableForProgram();

    public void deleteForProgram();

    public CompletableFuture<Void> enableForTrace(Trace var1);

    public CompletableFuture<Void> disableForTrace(Trace var1);

    public CompletableFuture<Void> deleteForTrace(Trace var1);

    public CompletableFuture<Void> enable();

    public CompletableFuture<Void> disable();

    public CompletableFuture<Void> delete();

    public static enum Enablement {
        NONE(false, false, true, false){

            @Override
            public Enablement getPrimary() {
                return NONE;
            }
        }
        ,
        ENABLED(true, false, true, true){

            @Override
            public Enablement getPrimary() {
                return ENABLED;
            }
        }
        ,
        DISABLED(false, true, true, true){

            @Override
            public Enablement getPrimary() {
                return DISABLED;
            }
        }
        ,
        INEFFECTIVE_ENABLED(true, false, true, false){

            @Override
            public Enablement getPrimary() {
                return ENABLED;
            }
        }
        ,
        INEFFECTIVE_DISABLED(false, true, true, false){

            @Override
            public Enablement getPrimary() {
                return DISABLED;
            }
        }
        ,
        ENABLED_DISABLED(true, false, false, true){

            @Override
            public Enablement getPrimary() {
                return ENABLED;
            }
        }
        ,
        DISABLED_ENABLED(false, true, false, true){

            @Override
            public Enablement getPrimary() {
                return DISABLED;
            }
        };

        public final boolean enabled;
        public final boolean disabled;
        public final boolean consistent;
        public final boolean effective;

        private Enablement(boolean enabled, boolean disabled, boolean consistent, boolean effective) {
            this.enabled = enabled;
            this.disabled = disabled;
            this.consistent = consistent;
            this.effective = effective;
        }

        public Enablement sameAdddress(Enablement that) {
            if (this == NONE) {
                return that;
            }
            if (that == NONE) {
                return this;
            }
            if (!this.effective && !that.effective) {
                return this.enabled || that.enabled ? INEFFECTIVE_ENABLED : INEFFECTIVE_DISABLED;
            }
            return Enablement.fromBools(this.enabled || that.enabled, this.enabled && that.enabled);
        }

        public static Enablement sameAddress(Collection<Enablement> col) {
            Enablement result = NONE;
            for (Enablement e : col) {
                result = result.sameAdddress(e);
            }
            return result;
        }

        public static Enablement fromBools(boolean firstEn, boolean secondEn) {
            if (firstEn) {
                if (secondEn) {
                    return ENABLED;
                }
                return ENABLED_DISABLED;
            }
            if (secondEn) {
                return DISABLED_ENABLED;
            }
            return DISABLED;
        }

        public abstract Enablement getPrimary();

        public Enablement getToggled(boolean mapped) {
            boolean en = mapped ? this == ENABLED : this.enabled;
            return en ? DISABLED : ENABLED;
        }
    }

    public static enum TraceEnablement {
        NONE{

            @Override
            public TraceEnablement combine(TraceEnablement that) {
                return that;
            }

            @Override
            public Enablement combineProgram(ProgramEnablement progEn) {
                switch (progEn) {
                    case NONE: 
                    case MISSING: {
                        return Enablement.NONE;
                    }
                    case ENABLED: {
                        return Enablement.INEFFECTIVE_ENABLED;
                    }
                    case DISABLED: {
                        return Enablement.INEFFECTIVE_DISABLED;
                    }
                }
                throw new AssertionError();
            }
        }
        ,
        MISSING{

            @Override
            public TraceEnablement combine(TraceEnablement that) {
                return that;
            }

            @Override
            public Enablement combineProgram(ProgramEnablement progEn) {
                switch (progEn) {
                    case NONE: 
                    case MISSING: {
                        return Enablement.NONE;
                    }
                    case ENABLED: {
                        return Enablement.INEFFECTIVE_ENABLED;
                    }
                    case DISABLED: {
                        return Enablement.INEFFECTIVE_DISABLED;
                    }
                }
                throw new AssertionError();
            }
        }
        ,
        ENABLED{

            @Override
            public TraceEnablement combine(TraceEnablement that) {
                switch (that) {
                    case NONE: 
                    case MISSING: 
                    case ENABLED: {
                        return ENABLED;
                    }
                    case MIXED: 
                    case DISABLED: {
                        return MIXED;
                    }
                }
                throw new AssertionError();
            }

            @Override
            public Enablement combineProgram(ProgramEnablement progEn) {
                switch (progEn) {
                    case NONE: 
                    case MISSING: 
                    case DISABLED: {
                        return Enablement.ENABLED_DISABLED;
                    }
                    case ENABLED: {
                        return Enablement.ENABLED;
                    }
                }
                throw new AssertionError();
            }
        }
        ,
        DISABLED{

            @Override
            public TraceEnablement combine(TraceEnablement that) {
                switch (that) {
                    case NONE: 
                    case MISSING: 
                    case DISABLED: {
                        return DISABLED;
                    }
                    case ENABLED: 
                    case MIXED: {
                        return MIXED;
                    }
                }
                throw new AssertionError();
            }

            @Override
            public Enablement combineProgram(ProgramEnablement progEn) {
                switch (progEn) {
                    case NONE: 
                    case MISSING: 
                    case DISABLED: {
                        return Enablement.DISABLED;
                    }
                    case ENABLED: {
                        return Enablement.DISABLED_ENABLED;
                    }
                }
                throw new AssertionError();
            }
        }
        ,
        MIXED{

            @Override
            public TraceEnablement combine(TraceEnablement that) {
                return MIXED;
            }

            @Override
            public Enablement combineProgram(ProgramEnablement progEn) {
                return Enablement.ENABLED_DISABLED;
            }
        };


        public static TraceEnablement fromBool(boolean en) {
            return en ? ENABLED : DISABLED;
        }

        public abstract TraceEnablement combine(TraceEnablement var1);

        public abstract Enablement combineProgram(ProgramEnablement var1);
    }

    public static enum ProgramEnablement {
        NONE{

            @Override
            public Enablement combineTrace(TraceEnablement traceEn) {
                switch (traceEn) {
                    case NONE: {
                        return Enablement.NONE;
                    }
                    case MISSING: {
                        return Enablement.NONE;
                    }
                    case ENABLED: {
                        return Enablement.ENABLED;
                    }
                    case MIXED: {
                        return Enablement.DISABLED_ENABLED;
                    }
                    case DISABLED: {
                        return Enablement.DISABLED;
                    }
                }
                throw new AssertionError();
            }
        }
        ,
        MISSING{

            @Override
            public Enablement combineTrace(TraceEnablement traceEn) {
                switch (traceEn) {
                    case NONE: {
                        return Enablement.NONE;
                    }
                    case MISSING: {
                        return Enablement.NONE;
                    }
                    case ENABLED: 
                    case MIXED: {
                        return Enablement.DISABLED_ENABLED;
                    }
                    case DISABLED: {
                        return Enablement.DISABLED;
                    }
                }
                throw new AssertionError();
            }
        }
        ,
        ENABLED{

            @Override
            public Enablement combineTrace(TraceEnablement traceEn) {
                switch (traceEn) {
                    case NONE: 
                    case MISSING: {
                        return Enablement.INEFFECTIVE_ENABLED;
                    }
                    case ENABLED: {
                        return Enablement.ENABLED;
                    }
                    case MIXED: 
                    case DISABLED: {
                        return Enablement.ENABLED_DISABLED;
                    }
                }
                throw new AssertionError();
            }
        }
        ,
        DISABLED{

            @Override
            public Enablement combineTrace(TraceEnablement traceEn) {
                switch (traceEn) {
                    case NONE: 
                    case MISSING: {
                        return Enablement.INEFFECTIVE_DISABLED;
                    }
                    case ENABLED: 
                    case MIXED: {
                        return Enablement.DISABLED_ENABLED;
                    }
                    case DISABLED: {
                        return Enablement.DISABLED;
                    }
                }
                throw new AssertionError();
            }
        };


        public abstract Enablement combineTrace(TraceEnablement var1);
    }
}

