/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.service.model;

import ghidra.app.plugin.core.debug.service.model.DefaultTraceRecorder;
import ghidra.app.plugin.core.debug.service.model.RecorderPermanentTransaction;
import ghidra.app.services.TraceRecorderListener;
import ghidra.framework.model.UndoableDomainObject;
import ghidra.trace.model.Trace;
import ghidra.trace.model.thread.TraceThread;
import ghidra.trace.model.time.TraceSnapshot;

public class DefaultTimeRecorder {
    private DefaultTraceRecorder recorder;
    private Trace trace;
    private TraceSnapshot snapshot = null;

    public DefaultTimeRecorder(DefaultTraceRecorder recorder) {
        this.recorder = recorder;
        this.trace = recorder.getTrace();
    }

    public TraceSnapshot getSnapshot() {
        return this.snapshot;
    }

    public long getSnap() {
        return this.snapshot.getKey();
    }

    protected synchronized void doAdvanceSnap(String description, TraceThread eventThread) {
        this.snapshot = this.trace.getTimeManager().createSnapshot(description);
        this.snapshot.setEventThread(eventThread);
    }

    public TraceSnapshot forceSnapshot() {
        this.createSnapshot("User-forced snapshot", null, null);
        return this.snapshot;
    }

    public void createSnapshot(String description, TraceThread eventThread, RecorderPermanentTransaction tid) {
        if (tid != null) {
            this.doAdvanceSnap(description, eventThread);
            ((TraceRecorderListener)this.recorder.getListeners().fire).snapAdvanced(this.recorder, this.getSnap());
            return;
        }
        try (RecorderPermanentTransaction tid2 = RecorderPermanentTransaction.start((UndoableDomainObject)this.trace, description);){
            this.doAdvanceSnap(description, eventThread);
        }
        ((TraceRecorderListener)this.recorder.getListeners().fire).snapAdvanced(this.recorder, this.getSnap());
    }
}

