/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.mapping;

import ghidra.app.plugin.core.debug.mapping.DebuggerMappingOffer;
import ghidra.app.plugin.core.debug.mapping.DebuggerTargetTraceMapper;
import ghidra.app.plugin.core.debug.mapping.DefaultDebuggerTargetTraceMapper;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.util.PathUtils;
import ghidra.program.model.lang.CompilerSpecID;
import ghidra.program.model.lang.CompilerSpecNotFoundException;
import ghidra.program.model.lang.LanguageID;
import ghidra.program.model.lang.LanguageNotFoundException;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class DefaultDebuggerMappingOffer
implements DebuggerMappingOffer {
    protected final TargetObject target;
    protected final int confidence;
    protected final String description;
    protected final LanguageID langID;
    protected final CompilerSpecID csID;
    protected final Set<String> extraRegNames;

    public DefaultDebuggerMappingOffer(TargetObject target, int confidence, String description, LanguageID langID, CompilerSpecID csID, Collection<String> extraRegNames) {
        this.target = target;
        this.confidence = confidence;
        this.description = description;
        this.langID = langID;
        this.csID = csID;
        this.extraRegNames = Set.copyOf(extraRegNames);
    }

    public String toString() {
        return String.format("<Offer: '%s' lang=%s cs=%s confidence=%d target=%s>", this.description, this.langID, this.csID, this.confidence, PathUtils.toString((List)this.target.getPath()));
    }

    @Override
    public int getConfidence() {
        return this.confidence;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public LanguageID getTraceLanguageID() {
        return this.langID;
    }

    @Override
    public CompilerSpecID getTraceCompilerSpecID() {
        return this.csID;
    }

    protected DebuggerTargetTraceMapper createMapper() throws LanguageNotFoundException, CompilerSpecNotFoundException {
        return new DefaultDebuggerTargetTraceMapper(this.target, this.langID, this.csID, this.extraRegNames);
    }

    @Override
    public DebuggerTargetTraceMapper take() {
        try {
            return this.createMapper();
        }
        catch (CompilerSpecNotFoundException | LanguageNotFoundException e) {
            throw new AssertionError((Object)e);
        }
    }
}

