/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.watch;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.WindowPosition;
import docking.action.DockingAction;
import docking.action.ToggleDockingAction;
import docking.action.builder.ActionBuilder;
import docking.action.builder.ToggleActionBuilder;
import docking.widgets.table.CustomToStringCellRenderer;
import docking.widgets.table.DefaultEnumeratedColumnTableModel;
import docking.widgets.table.GTableCellRenderingData;
import docking.widgets.table.RowObjectTableModel;
import ghidra.app.plugin.core.debug.DebuggerCoordinates;
import ghidra.app.plugin.core.debug.gui.DebuggerResources;
import ghidra.app.plugin.core.debug.gui.watch.DebuggerWatchActionContext;
import ghidra.app.plugin.core.debug.gui.watch.DebuggerWatchesPlugin;
import ghidra.app.plugin.core.debug.gui.watch.WatchRow;
import ghidra.app.services.DebuggerListingService;
import ghidra.app.services.DebuggerTraceManagerService;
import ghidra.async.AsyncDebouncer;
import ghidra.async.AsyncTimer;
import ghidra.base.widgets.table.DataTypeTableCellEditor;
import ghidra.docking.settings.Settings;
import ghidra.framework.model.DomainObjectChangeRecord;
import ghidra.framework.model.DomainObjectListener;
import ghidra.framework.model.UndoableDomainObject;
import ghidra.framework.options.SaveState;
import ghidra.framework.options.annotation.AutoOptionDefined;
import ghidra.framework.options.annotation.HelpInfo;
import ghidra.framework.plugintool.AutoService;
import ghidra.framework.plugintool.ComponentProviderAdapter;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.annotation.AutoServiceConsumed;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeConflictException;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.program.util.ProgramSelection;
import ghidra.trace.model.Trace;
import ghidra.trace.model.TraceAddressSnapRange;
import ghidra.trace.model.TraceDomainObjectListener;
import ghidra.trace.model.time.schedule.TraceSchedule;
import ghidra.trace.util.TraceAddressSpace;
import ghidra.trace.util.TraceChangeType;
import ghidra.util.Msg;
import ghidra.util.Swing;
import ghidra.util.database.UndoableTransaction;
import ghidra.util.table.GhidraTable;
import ghidra.util.table.GhidraTableFilterPanel;
import ghidra.util.table.column.AbstractGColumnRenderer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class DebuggerWatchesProvider
extends ComponentProviderAdapter {
    private static final String KEY_EXPRESSION_LIST = "expressionList";
    private static final String KEY_TYPE_LIST = "typeList";
    final DebuggerWatchesPlugin plugin;
    DebuggerCoordinates current = DebuggerCoordinates.NOWHERE;
    private Trace currentTrace;
    @AutoServiceConsumed
    private DebuggerListingService listingService;
    @AutoServiceConsumed
    private DebuggerTraceManagerService traceManager;
    private final AutoService.Wiring autoServiceWiring;
    @AutoOptionDefined(name={"Colors.Stale Watches"}, description="Text color for watches whose value is not known", help=@HelpInfo(anchor="colors"))
    protected Color watchStaleColor = DebuggerResources.DEFAULT_COLOR_WATCH_STALE;
    @AutoOptionDefined(name={"Colors.Stale Watches (selected)"}, description="Selected text color for watches whose value is not known", help=@HelpInfo(anchor="colors"))
    protected Color watchStaleSelColor = DebuggerResources.DEFAULT_COLOR_WATCH_STALE_SEL;
    @AutoOptionDefined(name={"Colors.Changed Watches"}, description="Text color for watches whose value just changed", help=@HelpInfo(anchor="colors"))
    protected Color watchChangesColor = DebuggerResources.DEFAULT_COLOR_WATCH_CHANGED;
    @AutoOptionDefined(name={"Colors.Changed Watches (selected)"}, description="Selected text color for watches whose value just changed", help=@HelpInfo(anchor="colors"))
    protected Color watchChangesSelColor = DebuggerResources.DEFAULT_COLOR_WATCH_CHANGED_SEL;
    private final AddressSet changed = new AddressSet();
    private final AsyncDebouncer<Void> changeDebouncer = new AsyncDebouncer(AsyncTimer.DEFAULT_TIMER, 100L);
    private ForDepsListener forDepsListener = new ForDepsListener();
    private JPanel mainPanel = new JPanel(new BorderLayout());
    protected final WatchTableModel watchTableModel = new WatchTableModel();
    protected GhidraTable watchTable;
    protected GhidraTableFilterPanel<WatchRow> watchFilterPanel;
    ToggleDockingAction actionEnableEdits;
    DockingAction actionApplyDataType;
    DockingAction actionSelectRange;
    DockingAction actionSelectAllReads;
    DockingAction actionAdd;
    DockingAction actionRemove;
    private DebuggerWatchActionContext myActionContext;

    protected static boolean sameCoordinates(DebuggerCoordinates a, DebuggerCoordinates b) {
        if (!Objects.equals(a.getTrace(), b.getTrace())) {
            return false;
        }
        if (!Objects.equals(a.getRecorder(), b.getRecorder())) {
            return false;
        }
        if (!Objects.equals(a.getTime(), b.getTime())) {
            return false;
        }
        if (!Objects.equals(a.getThread(), b.getThread())) {
            return false;
        }
        return Objects.equals(a.getFrame(), b.getFrame());
    }

    public DebuggerWatchesProvider(DebuggerWatchesPlugin plugin) {
        super(plugin.getTool(), "Watches", plugin.getName());
        this.plugin = plugin;
        this.autoServiceWiring = AutoService.wireServicesConsumed((Plugin)plugin, (Object)((Object)this));
        this.setIcon(DebuggerResources.ICON_PROVIDER_WATCHES);
        this.setHelpLocation(DebuggerResources.HELP_PROVIDER_WATCHES);
        this.setWindowMenuGroup("Debugger");
        this.buildMainPanel();
        this.setDefaultWindowPosition(WindowPosition.RIGHT);
        this.createActions();
        this.setVisible(true);
        this.contextChanged();
        this.changeDebouncer.addListener(__ -> this.doCheckDepsAndReevaluate());
    }

    public ActionContext getActionContext(MouseEvent event) {
        if (this.myActionContext != null) {
            return this.myActionContext;
        }
        return super.getActionContext(event);
    }

    protected void buildMainPanel() {
        this.watchTable = new GhidraTable((TableModel)((Object)this.watchTableModel));
        this.mainPanel.add(new JScrollPane((Component)this.watchTable));
        this.watchFilterPanel = new GhidraTableFilterPanel((JTable)this.watchTable, (RowObjectTableModel)this.watchTableModel);
        this.mainPanel.add((Component)this.watchFilterPanel, "South");
        this.watchTable.getSelectionModel().addListSelectionListener(evt -> {
            if (evt.getValueIsAdjusting()) {
                return;
            }
            this.contextChanged();
        });
        this.watchTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() != 2 || e.getButton() != 1) {
                    return;
                }
                DebuggerWatchesProvider.this.navigateToSelectedWatch();
            }
        });
        TableColumnModel columnModel = this.watchTable.getColumnModel();
        TableColumn addrCol = columnModel.getColumn(WatchTableColumns.ADDRESS.ordinal());
        addrCol.setCellRenderer((TableCellRenderer)CustomToStringCellRenderer.MONO_OBJECT);
        TableColumn valCol = columnModel.getColumn(WatchTableColumns.VALUE.ordinal());
        valCol.setCellRenderer((TableCellRenderer)((Object)new WatchValueCellRenderer()));
        TableColumn typeCol = columnModel.getColumn(WatchTableColumns.TYPE.ordinal());
        typeCol.setCellEditor((TableCellEditor)((Object)new WatchDataTypeEditor()));
    }

    public void contextChanged() {
        this.myActionContext = new DebuggerWatchActionContext(this, this.watchFilterPanel.getSelectedItems(), (Component)this.watchTable);
        super.contextChanged();
    }

    protected void navigateToSelectedWatch() {
        Object val;
        if (this.myActionContext == null) {
            return;
        }
        WatchRow row = this.myActionContext.getWatchRow();
        if (row == null) {
            return;
        }
        int modelCol = this.watchTable.convertColumnIndexToModel(this.watchTable.getSelectedColumn());
        Throwable error = row.getError();
        if (error != null) {
            Msg.showError((Object)((Object)this), (Component)this.getComponent(), (String)"Evaluation error", (Object)"Could not evaluate watch", (Throwable)error);
        } else if (modelCol == WatchTableColumns.ADDRESS.ordinal()) {
            Address address = row.getAddress();
            if (address != null) {
                this.navigateToAddress(address);
            }
        } else if (modelCol == WatchTableColumns.REPR.ordinal() && (val = row.getValueObj()) instanceof Address) {
            this.navigateToAddress((Address)val);
        }
    }

    protected void navigateToAddress(Address address) {
        if (this.listingService == null) {
            return;
        }
        if (address.isMemoryAddress()) {
            this.listingService.goTo(address, true);
            return;
        }
    }

    protected void createActions() {
        this.actionEnableEdits = (ToggleDockingAction)((ToggleActionBuilder)((ToggleActionBuilder)DebuggerResources.EnableEditsAction.builder(this.plugin).enabledWhen(c -> this.current.getTrace() != null)).onAction(c -> {})).buildAndInstallLocal((ComponentProvider)this);
        this.actionApplyDataType = (DockingAction)DebuggerResources.ApplyDataTypeAction.builder(this.plugin).withContext(DebuggerWatchActionContext.class).enabledWhen(ctx -> this.current.getTrace() != null && this.selHasDataType((DebuggerWatchActionContext)((Object)ctx))).onAction(this::activatedApplyDataType).buildAndInstallLocal((ComponentProvider)this);
        this.actionSelectRange = (DockingAction)DebuggerResources.SelectWatchRangeAction.builder(this.plugin).withContext(DebuggerWatchActionContext.class).enabledWhen(ctx -> this.current.getTrace() != null && this.listingService != null && this.selHasMemoryRanges((DebuggerWatchActionContext)((Object)ctx))).onAction(this::activatedSelectRange).buildAndInstallLocal((ComponentProvider)this);
        this.actionSelectAllReads = (DockingAction)DebuggerResources.SelectWatchReadsAction.builder(this.plugin).withContext(DebuggerWatchActionContext.class).enabledWhen(ctx -> this.current.getTrace() != null && this.listingService != null && this.selHasMemoryReads((DebuggerWatchActionContext)((Object)ctx))).onAction(this::activatedSelectReads).buildAndInstallLocal((ComponentProvider)this);
        this.actionAdd = (DockingAction)((ActionBuilder)DebuggerResources.AddAction.builder(this.plugin).onAction(this::activatedAdd)).buildAndInstallLocal((ComponentProvider)this);
        this.actionRemove = (DockingAction)DebuggerResources.RemoveAction.builder(this.plugin).withContext(DebuggerWatchActionContext.class).enabledWhen(ctx -> !ctx.getWatchRows().isEmpty()).onAction(this::activatedRemove).buildAndInstallLocal((ComponentProvider)this);
    }

    protected boolean selHasDataType(DebuggerWatchActionContext ctx) {
        for (WatchRow row : ctx.getWatchRows()) {
            Address address = row.getAddress();
            if (row.getDataType() == null || address == null || !address.isMemoryAddress() || row.getValueLength() == 0) continue;
            return true;
        }
        return false;
    }

    protected boolean selHasMemoryRanges(DebuggerWatchActionContext ctx) {
        for (WatchRow row : ctx.getWatchRows()) {
            AddressRange rng = row.getRange();
            if (rng == null || !rng.getAddressSpace().isMemorySpace()) continue;
            return true;
        }
        return false;
    }

    protected boolean selHasMemoryReads(DebuggerWatchActionContext ctx) {
        for (WatchRow row : ctx.getWatchRows()) {
            AddressSet set = row.getReads();
            if (set == null) continue;
            for (AddressRange rng : set) {
                if (!rng.getAddressSpace().isMemorySpace()) continue;
                return true;
            }
        }
        return false;
    }

    private void activatedApplyDataType(DebuggerWatchActionContext context) {
        if (this.current.getTrace() == null) {
            return;
        }
        ArrayList<CallSite> errs = new ArrayList<CallSite>();
        for (WatchRow row : context.getWatchRows()) {
            int size;
            Address address;
            DataType dataType = row.getDataType();
            if (dataType == null || (address = row.getAddress()) == null || !address.isMemoryAddress() || (size = row.getValueLength()) == 0) continue;
            Listing listing = this.current.getView().getListing();
            Data existing = listing.getDefinedDataAt(address);
            if (existing != null && existing.getDataType().isEquivalent(dataType)) {
                return;
            }
            UndoableTransaction tid = UndoableTransaction.start((UndoableDomainObject)this.current.getTrace(), (String)"Apply Watch Data Type", (boolean)true);
            try {
                try {
                    listing.clearCodeUnits(row.getAddress(), row.getRange().getMaxAddress(), false);
                    listing.createData(address, dataType, size);
                }
                catch (DataTypeConflictException | CodeUnitInsertionException e) {
                    errs.add((CallSite)((Object)(address + " " + dataType + "(" + size + "): " + e.getMessage())));
                }
            }
            finally {
                if (tid == null) continue;
                tid.close();
            }
        }
        if (!errs.isEmpty()) {
            StringBuffer msg = new StringBuffer("One or more types could not be applied:");
            for (String string : errs) {
                msg.append("\n    ");
                msg.append(string);
            }
            Msg.showError((Object)((Object)this), (Component)this.getComponent(), (String)"Apply Data Type", (Object)msg.toString());
        }
    }

    private void activatedSelectRange(DebuggerWatchActionContext context) {
        if (this.listingService == null) {
            return;
        }
        AddressSet sel = new AddressSet();
        for (WatchRow row : context.getWatchRows()) {
            AddressRange rng = row.getRange();
            if (rng == null) continue;
            sel.add(rng);
        }
        this.listingService.setCurrentSelection(new ProgramSelection((AddressSetView)sel));
    }

    private void activatedSelectReads(DebuggerWatchActionContext context) {
        if (this.listingService == null) {
            return;
        }
        AddressSet sel = new AddressSet();
        for (WatchRow row : context.getWatchRows()) {
            AddressSet reads = row.getReads();
            if (reads == null) continue;
            sel.add((AddressSetView)reads);
        }
        this.listingService.setCurrentSelection(new ProgramSelection((AddressSetView)sel));
    }

    private void activatedAdd(ActionContext ignored) {
        this.addWatch("");
    }

    private void activatedRemove(DebuggerWatchActionContext context) {
        this.watchTableModel.deleteWith(context.getWatchRows()::contains);
    }

    public WatchRow addWatch(String expression) {
        WatchRow row = new WatchRow(this, expression);
        row.setCoordinates(this.current);
        this.watchTableModel.add(row);
        return row;
    }

    public JComponent getComponent() {
        return this.mainPanel;
    }

    private void removeOldListeners() {
        if (this.currentTrace == null) {
            return;
        }
        this.currentTrace.removeListener((DomainObjectListener)this.forDepsListener);
    }

    private void addNewListeners() {
        if (this.currentTrace == null) {
            return;
        }
        this.currentTrace.addListener((DomainObjectListener)this.forDepsListener);
    }

    private void doSetTrace(Trace trace) {
        if (this.currentTrace == trace) {
            return;
        }
        this.removeOldListeners();
        this.currentTrace = trace;
        this.addNewListeners();
    }

    public void coordinatesActivated(DebuggerCoordinates coordinates) {
        if (DebuggerWatchesProvider.sameCoordinates(this.current, coordinates)) {
            this.current = coordinates;
            return;
        }
        this.current = coordinates;
        this.doSetTrace(this.current.getTrace());
        this.setRowsContext(coordinates);
        if (this.current.isAliveAndReadsPresent()) {
            this.readTarget();
        }
        this.reevaluate();
        Swing.runIfSwingOrRunLater(() -> this.watchTableModel.fireTableDataChanged());
    }

    public synchronized void setRowsContext(DebuggerCoordinates coordinates) {
        for (WatchRow row : this.watchTableModel.getModelData()) {
            row.setCoordinates(coordinates);
        }
    }

    public synchronized void readTarget() {
        for (WatchRow row : this.watchTableModel.getModelData()) {
            row.doTargetReads();
        }
    }

    public synchronized void doCheckDepsAndReevaluate() {
        for (WatchRow row : this.watchTableModel.getModelData()) {
            AddressSet reads = row.getReads();
            if (reads != null && !reads.intersects((AddressSetView)this.changed)) continue;
            row.doTargetReads();
            row.reevaluate();
        }
        this.changed.clear();
        Swing.runIfSwingOrRunLater(() -> {
            this.watchTableModel.fireTableDataChanged();
            this.contextChanged();
        });
    }

    public void reevaluate() {
        for (WatchRow row : this.watchTableModel.getModelData()) {
            row.reevaluate();
        }
        this.changed.clear();
    }

    public void writeConfigState(SaveState saveState) {
        List rows = List.copyOf(this.watchTableModel.getModelData());
        String[] expressions = (String[])rows.stream().map(WatchRow::getExpression).toArray(String[]::new);
        String[] types = (String[])rows.stream().map(WatchRow::getTypePath).toArray(String[]::new);
        saveState.putStrings(KEY_EXPRESSION_LIST, expressions);
        saveState.putStrings(KEY_TYPE_LIST, types);
    }

    public void readConfigState(SaveState saveState) {
        String[] types;
        String[] expressions = saveState.getStrings(KEY_EXPRESSION_LIST, new String[0]);
        if (expressions.length != (types = saveState.getStrings(KEY_TYPE_LIST, new String[0])).length) {
            Msg.error((Object)((Object)this), (Object)"Watch provider config error. Unequal number of expressions and types");
            return;
        }
        int len = expressions.length;
        ArrayList<WatchRow> rows = new ArrayList<WatchRow>();
        for (int i = 0; i < len; ++i) {
            WatchRow r = new WatchRow(this, expressions[i]);
            r.setTypePath(types[i]);
            rows.add(r);
        }
        this.watchTableModel.addAll(rows);
    }

    public boolean isEditsEnabled() {
        return this.actionEnableEdits.isSelected();
    }

    public void goToTime(TraceSchedule time) {
        this.traceManager.activateTime(time);
    }

    class WatchValueCellRenderer
    extends AbstractGColumnRenderer<String> {
        WatchValueCellRenderer() {
        }

        public Component getTableCellRendererComponent(GTableCellRenderingData data) {
            super.getTableCellRendererComponent(data);
            WatchRow row = (WatchRow)data.getRowObject();
            if (!row.isKnown()) {
                if (data.isSelected()) {
                    this.setForeground(DebuggerWatchesProvider.this.watchStaleSelColor);
                } else {
                    this.setForeground(DebuggerWatchesProvider.this.watchStaleColor);
                }
            } else if (row.isChanged()) {
                if (data.isSelected()) {
                    this.setForeground(DebuggerWatchesProvider.this.watchChangesSelColor);
                } else {
                    this.setForeground(DebuggerWatchesProvider.this.watchChangesColor);
                }
            }
            return this;
        }

        public String getFilterString(String t, Settings settings) {
            return t;
        }
    }

    class WatchDataTypeEditor
    extends DataTypeTableCellEditor {
        public WatchDataTypeEditor() {
            super(DebuggerWatchesProvider.this.plugin.getTool());
        }

        protected DataType resolveSelection(DataType dataType) {
            if (dataType == null) {
                return null;
            }
            try (UndoableTransaction tid = UndoableTransaction.start((UndoableDomainObject)DebuggerWatchesProvider.this.currentTrace, (String)"Resolve DataType", (boolean)true);){
                DataType dataType2 = DebuggerWatchesProvider.this.currentTrace.getDataTypeManager().resolve(dataType, null);
                return dataType2;
            }
        }
    }

    class ForDepsListener
    extends TraceDomainObjectListener {
        public ForDepsListener() {
            this.listenForUntyped(4, this::objectRestored);
            this.listenFor((TraceChangeType)Trace.TraceMemoryBytesChangeType.CHANGED, this::bytesChanged);
            this.listenFor((TraceChangeType)Trace.TraceMemoryStateChangeType.CHANGED, this::stateChanged);
        }

        private void objectRestored(DomainObjectChangeRecord rec) {
            DebuggerWatchesProvider.this.changed.add((AddressSetView)DebuggerWatchesProvider.this.current.getView().getMemory());
            DebuggerWatchesProvider.this.changeDebouncer.contact(null);
        }

        private void bytesChanged(TraceAddressSpace space, TraceAddressSnapRange range) {
            if (space.getThread() == DebuggerWatchesProvider.this.current.getThread() || space.getThread() == null) {
                DebuggerWatchesProvider.this.changed.add(range.getRange());
                DebuggerWatchesProvider.this.changeDebouncer.contact(null);
            }
        }

        private void stateChanged(TraceAddressSpace space, TraceAddressSnapRange range) {
            if (space.getThread() == DebuggerWatchesProvider.this.current.getThread() || space.getThread() == null) {
                DebuggerWatchesProvider.this.changed.add(range.getRange());
                DebuggerWatchesProvider.this.changeDebouncer.contact(null);
            }
        }
    }

    protected static class WatchTableModel
    extends DefaultEnumeratedColumnTableModel<WatchTableColumns, WatchRow> {
        public WatchTableModel() {
            super("Watches", WatchTableColumns.class);
        }
    }

    protected static enum WatchTableColumns implements DefaultEnumeratedColumnTableModel.EnumeratedTableColumn<WatchTableColumns, WatchRow>
    {
        EXPRESSION("Expression", String.class, WatchRow::getExpression, WatchRow::setExpression),
        ADDRESS("Address", Address.class, WatchRow::getAddress),
        VALUE("Value", String.class, WatchRow::getRawValueString, WatchRow::setRawValueString, WatchRow::isValueEditable),
        TYPE("Type", DataType.class, WatchRow::getDataType, WatchRow::setDataType),
        REPR("Repr", String.class, WatchRow::getValueString),
        ERROR("Error", String.class, WatchRow::getErrorMessage);

        private final String header;
        private final Function<WatchRow, ?> getter;
        private final BiConsumer<WatchRow, Object> setter;
        private final Predicate<WatchRow> editable;
        private final Class<?> cls;

        private <T> WatchTableColumns(String header, Class<T> cls, Function<WatchRow, T> getter, BiConsumer<WatchRow, T> setter, Predicate<WatchRow> editable) {
            this.header = header;
            this.cls = cls;
            this.getter = getter;
            this.setter = setter;
            this.editable = editable;
        }

        private <T> WatchTableColumns(String header, Class<T> cls, Function<WatchRow, T> getter, BiConsumer<WatchRow, T> setter) {
            this(header, cls, getter, setter, null);
        }

        private <T> WatchTableColumns(String header, Class<T> cls, Function<WatchRow, T> getter) {
            this(header, cls, getter, null, null);
        }

        public Class<?> getValueClass() {
            return this.cls;
        }

        public Object getValueOf(WatchRow row) {
            return this.getter.apply(row);
        }

        public String getHeader() {
            return this.header;
        }

        public void setValueOf(WatchRow row, Object value) {
            this.setter.accept(row, value);
        }

        public boolean isEditable(WatchRow row) {
            return this.setter != null && (this.editable == null || this.editable.test(row));
        }
    }
}

