/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.modules;

import com.google.common.collect.Range;
import docking.DialogComponentProvider;
import docking.widgets.model.GAddressRangeField;
import docking.widgets.model.GLifespanField;
import ghidra.app.services.DebuggerStaticMappingService;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.UndoableDomainObject;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.trace.model.DefaultTraceLocation;
import ghidra.trace.model.Trace;
import ghidra.trace.model.TraceLocation;
import ghidra.trace.model.modules.TraceConflictedMappingException;
import ghidra.util.MathUtilities;
import ghidra.util.database.UndoableTransaction;
import ghidra.util.layout.PairLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.math.BigInteger;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

public class DebuggerAddMappingDialog
extends DialogComponentProvider {
    private static final String HEX_BIT64 = "0x" + BigInteger.ONE.shiftLeft(64).toString(16);
    private DebuggerStaticMappingService mappingService;
    private Program program;
    private Trace trace;
    private final JLabel labelProg = new JLabel();
    private final GAddressRangeField fieldProgRange = new GAddressRangeField();
    private final JLabel labelTrace = new JLabel();
    private final GAddressRangeField fieldTraceRange = new GAddressRangeField();
    private final JTextField fieldLength = new JTextField();
    private final GLifespanField fieldSpan = new GLifespanField();

    public DebuggerAddMappingDialog() {
        super("Add Static Mapping", false, false, true, false);
        this.populateComponents();
    }

    protected static void rigFocusAndEnter(Component c, final Runnable runnable) {
        c.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                runnable.run();
            }
        });
        c.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    runnable.run();
                }
            }
        });
    }

    protected void populateComponents() {
        JPanel panel = new JPanel((LayoutManager)new PairLayout(5, 5));
        panel.setBorder(new EmptyBorder(10, 10, 10, 10));
        panel.add(new JLabel("Program: "));
        panel.add(this.labelProg);
        panel.add(new JLabel("Static Range: "));
        panel.add((Component)this.fieldProgRange);
        panel.add(new JLabel("Trace: "));
        panel.add(this.labelTrace);
        panel.add(new JLabel("Dynamic Range: "));
        panel.add((Component)this.fieldTraceRange);
        panel.add(new JLabel("Length: "));
        this.fieldLength.setFont(Font.decode("monospaced"));
        panel.add(this.fieldLength);
        panel.add(new JLabel("Lifespan: "));
        panel.add((Component)this.fieldSpan);
        DebuggerAddMappingDialog.rigFocusAndEnter((Component)this.fieldProgRange, this::progRangeChanged);
        DebuggerAddMappingDialog.rigFocusAndEnter((Component)this.fieldTraceRange, this::traceRangeChanged);
        DebuggerAddMappingDialog.rigFocusAndEnter(this.fieldLength, this::lengthChanged);
        DebuggerAddMappingDialog.rigFocusAndEnter((Component)this.fieldSpan, this::spanChanged);
        this.addWorkPanel(panel);
        this.addApplyButton();
        this.addDismissButton();
        this.setDefaultButton(null);
    }

    public void setMappingService(DebuggerStaticMappingService mappingService) {
        this.mappingService = mappingService;
    }

    protected static void revalidateByLength(GAddressRangeField adjusted, GAddressRangeField other) {
        AddressRange adjRange = adjusted.getRange();
        if (adjRange == null) {
            return;
        }
        long lengthMinus1 = adjRange.getMaxAddress().subtract(adjRange.getMinAddress());
        AddressRange otherRange = other.getRange();
        if (otherRange == null) {
            return;
        }
        long maxLengthMinus1 = otherRange.getAddressSpace().getMaxAddress().subtract(otherRange.getMinAddress());
        if (Long.compareUnsigned(lengthMinus1, maxLengthMinus1) > 0) {
            adjusted.setRange(DebuggerAddMappingDialog.range(adjRange.getMinAddress(), maxLengthMinus1));
        }
    }

    protected void revalidateProgRange() {
        DebuggerAddMappingDialog.revalidateByLength(this.fieldProgRange, this.fieldTraceRange);
    }

    protected void revalidateTraceRange() {
        DebuggerAddMappingDialog.revalidateByLength(this.fieldTraceRange, this.fieldProgRange);
    }

    protected static long lengthMin(long a, long b) {
        if (a == 0L) {
            return b;
        }
        if (b == 0L) {
            return a;
        }
        return MathUtilities.unsignedMin((long)a, (long)b);
    }

    protected static long revalidateLengthByRange(AddressRange range, long length) {
        long maxLength = range.getAddressSpace().getMaxAddress().subtract(range.getMinAddress()) + 1L;
        return DebuggerAddMappingDialog.lengthMin(length, maxLength);
    }

    protected void setFieldLength(long length) {
        if (length == 0L) {
            this.fieldLength.setText(HEX_BIT64);
        } else {
            this.fieldLength.setText("0x" + Long.toHexString(length));
        }
    }

    public long getLength() {
        return DebuggerAddMappingDialog.parseLength(this.fieldLength.getText(), 1L);
    }

    protected void revalidateLength() {
        long length = this.fieldLength.getText().trim().startsWith("-") ? 1L : this.getLength();
        length = DebuggerAddMappingDialog.revalidateLengthByRange(this.fieldProgRange.getRange(), length);
        length = DebuggerAddMappingDialog.revalidateLengthByRange(this.fieldTraceRange.getRange(), length);
        this.setFieldLength(length);
    }

    protected void revalidateSpan() {
    }

    protected static AddressRange range(Address min, long lengthMinus1) {
        return new AddressRangeImpl(min, min.addWrap(lengthMinus1));
    }

    protected void adjustLengthToProgRange() {
        long length = this.fieldProgRange.getRange().getLength();
        this.setFieldLength(length);
    }

    protected void adjustLengthToTraceRange() {
        long length = this.fieldTraceRange.getRange().getLength();
        this.setFieldLength(length);
    }

    protected void adjustRangeToLength(GAddressRangeField field) {
        AddressRange range = field.getRange();
        if (range == null) {
            return;
        }
        Address min = range.getMinAddress();
        field.setRange(DebuggerAddMappingDialog.range(min, this.getLength() - 1L));
    }

    protected void adjustProgRangeToLength() {
        this.adjustRangeToLength(this.fieldProgRange);
    }

    protected void adjustTraceRangeToLength() {
        this.adjustRangeToLength(this.fieldTraceRange);
    }

    protected void progRangeChanged() {
        this.revalidateProgRange();
        this.adjustLengthToProgRange();
        this.adjustTraceRangeToLength();
    }

    protected void traceRangeChanged() {
        this.revalidateTraceRange();
        this.adjustLengthToTraceRange();
        this.adjustProgRangeToLength();
    }

    protected void lengthChanged() {
        this.revalidateLength();
        this.adjustProgRangeToLength();
        this.adjustTraceRangeToLength();
    }

    protected void spanChanged() {
        this.revalidateSpan();
    }

    protected static long parseLength(String text, long defaultVal) {
        BigInteger bi;
        int radix;
        String post;
        if ((text = text.trim()).startsWith("-")) {
            return 0L;
        }
        if (text.startsWith("0x")) {
            post = text.substring(2);
            radix = 16;
        } else {
            post = text;
            radix = 10;
        }
        try {
            bi = new BigInteger(post, radix);
        }
        catch (NumberFormatException e) {
            return defaultVal;
        }
        if (bi.equals(BigInteger.ZERO)) {
            return 1L;
        }
        if (bi.bitLength() > 64) {
            return 0L;
        }
        return bi.longValue();
    }

    protected void applyCallback() {
        DefaultTraceLocation from = new DefaultTraceLocation(this.trace, null, this.fieldSpan.getLifespan(), this.fieldTraceRange.getRange().getMinAddress());
        ProgramLocation to = new ProgramLocation(this.program, this.fieldProgRange.getRange().getMinAddress());
        try (UndoableTransaction tid = UndoableTransaction.start((UndoableDomainObject)this.trace, (String)"Add Static Mapping", (boolean)false);){
            this.mappingService.addMapping((TraceLocation)from, to, this.getLength(), true);
            tid.commit();
        }
        catch (TraceConflictedMappingException e) {
            throw new AssertionError((Object)e);
        }
    }

    public void setValues(Program program, Trace trace, Address progStart, Address traceStart, long length, Range<Long> lifespan) throws AddressOverflowException {
        this.program = program;
        this.trace = trace;
        this.fieldProgRange.setAddressFactory(program.getAddressFactory());
        this.fieldProgRange.setRange(DebuggerAddMappingDialog.range(progStart, length - 1L));
        this.fieldTraceRange.setAddressFactory(trace.getBaseAddressFactory());
        this.fieldTraceRange.setRange(DebuggerAddMappingDialog.range(traceStart, length - 1L));
        this.setFieldLength(length);
        this.fieldSpan.setLifespan(lifespan);
    }

    protected void setEnabled(boolean enabled) {
        this.applyButton.setEnabled(enabled);
        this.fieldProgRange.setEnabled(enabled);
        this.fieldTraceRange.setEnabled(enabled);
        this.fieldLength.setEnabled(enabled);
        this.fieldSpan.setEnabled(enabled);
    }

    public void setTrace(Trace trace) {
        this.trace = trace;
        if (trace != null) {
            this.labelTrace.setText(trace.getName());
            this.fieldTraceRange.setAddressFactory(trace.getBaseAddressFactory());
        } else {
            this.labelTrace.setText("[No Trace]");
            this.fieldTraceRange.setAddressFactory(null);
        }
        if (this.program != null && trace != null) {
            this.traceRangeChanged();
            this.setEnabled(true);
        } else {
            this.setEnabled(false);
        }
    }

    public void setProgram(Program program) {
        this.program = program;
        if (program != null) {
            DomainFile df = program.getDomainFile();
            String name = df != null ? df.getName() : program.getName();
            this.labelProg.setText(name);
            this.fieldProgRange.setAddressFactory(program.getAddressFactory());
        } else {
            this.labelProg.setText("[No Program]");
            this.fieldProgRange.setAddressFactory(null);
        }
        if (program != null && this.trace != null) {
            this.progRangeChanged();
            this.setEnabled(true);
        } else {
            this.setEnabled(false);
        }
    }
}

