/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.memview;

import docking.widgets.table.AbstractSortedTableModel;
import ghidra.app.plugin.core.debug.gui.memview.MemoryBox;
import ghidra.app.plugin.core.debug.gui.memview.MemviewProvider;
import ghidra.program.model.address.Address;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class MemviewMapModel
extends AbstractSortedTableModel<MemoryBox> {
    static final byte NAME = 0;
    static final byte ASTART = 1;
    static final byte ASTOP = 2;
    static final byte TSTART = 3;
    static final byte TSTOP = 4;
    static final String NAME_COL = "Name";
    static final String ASTART_COL = "Start Address";
    static final String ASTOP_COL = "End Address";
    static final String TSTART_COL = "Start Time";
    static final String TSTOP_COL = "End Time";
    private List<MemoryBox> memList = new ArrayList<MemoryBox>();
    private Map<String, MemoryBox> memMap = new HashMap<String, MemoryBox>();
    private MemviewProvider provider;
    private static final String[] COLUMN_NAMES = new String[]{"Name", "Start Address", "End Address", "Start Time", "End Time"};

    public MemviewMapModel(MemviewProvider provider) {
        super(1);
        this.provider = provider;
    }

    public List<MemoryBox> getBoxes() {
        return this.memList;
    }

    public void addBoxes(Collection<MemoryBox> boxes) {
        if (this.memList == null) {
            this.memList = new ArrayList<MemoryBox>();
        }
        for (MemoryBox b : boxes) {
            if (this.memMap.containsKey(b.getId())) {
                MemoryBox mb = this.memMap.get(b.getId());
                this.memList.remove(mb);
            }
            this.memList.add(b);
            this.memMap.put(b.getId(), b);
        }
        this.fireTableDataChanged();
    }

    public void setBoxes(Collection<MemoryBox> boxes) {
        this.memList = new ArrayList<MemoryBox>();
        for (MemoryBox b : boxes) {
            this.memList.add(b);
            this.memMap.put(b.getId(), b);
        }
        this.fireTableDataChanged();
    }

    public void reset() {
        this.memList = new ArrayList<MemoryBox>();
        this.memMap.clear();
        this.fireTableDataChanged();
    }

    void update() {
    }

    public boolean isSortable(int columnIndex) {
        return true;
    }

    public String getName() {
        return "Memory vs Time Map";
    }

    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    public String getColumnName(int column) {
        if (column < 0 || column >= COLUMN_NAMES.length) {
            return "UNKNOWN";
        }
        return COLUMN_NAMES[column];
    }

    public int findColumn(String columnName) {
        for (int i = 0; i < COLUMN_NAMES.length; ++i) {
            if (!COLUMN_NAMES[i].equals(columnName)) continue;
            return i;
        }
        return 0;
    }

    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex == 1 || columnIndex == 2) {
            return Address.class;
        }
        return String.class;
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    public int getRowCount() {
        return this.memList.size();
    }

    public MemoryBox getBoxAt(int rowIndex) {
        if (this.memList == null) {
            return null;
        }
        if (rowIndex < 0 || rowIndex >= this.memList.size()) {
            return null;
        }
        MemoryBox box = this.memList.get(rowIndex);
        try {
            box.getStart();
        }
        catch (ConcurrentModificationException e) {
            this.update();
        }
        return this.memList.get(rowIndex);
    }

    public int getIndexForBox(MemoryBox box) {
        return this.memList.indexOf(box);
    }

    public Object getColumnValueForRow(MemoryBox box, int columnIndex) {
        try {
            switch (columnIndex) {
                case 0: {
                    return box.getId();
                }
                case 1: {
                    return box.getRange().getMinAddress();
                }
                case 2: {
                    return box.getRange().getMaxAddress();
                }
                case 3: {
                    return Long.toString(box.getStart());
                }
                case 4: {
                    long end = box.getEnd();
                    if (end == Long.MAX_VALUE) {
                        return "+\u221e\u2025";
                    }
                    return Long.toString(end);
                }
            }
            return "UNKNOWN";
        }
        catch (ConcurrentModificationException e) {
            this.update();
            return null;
        }
    }

    public List<MemoryBox> getModelData() {
        return this.memList;
    }

    protected Comparator<MemoryBox> createSortComparator(int columnIndex) {
        return new MemoryMapComparator(columnIndex);
    }

    private class MemoryMapComparator
    implements Comparator<MemoryBox> {
        private final int sortColumn;

        public MemoryMapComparator(int sortColumn) {
            this.sortColumn = sortColumn;
        }

        @Override
        public int compare(MemoryBox b1, MemoryBox b2) {
            switch (this.sortColumn) {
                case 0: {
                    return b1.getId().compareToIgnoreCase(b2.getId());
                }
                case 1: {
                    return (int)(b1.getStartAddress() - b2.getStartAddress());
                }
                case 2: {
                    return (int)(b1.getStopAddress() - b2.getStopAddress());
                }
                case 3: {
                    return (int)(b1.getStartTime() - b2.getStartTime());
                }
                case 4: {
                    return (int)(b1.getStopTime() - b2.getStopTime());
                }
            }
            return 0;
        }
    }
}

