/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.listing;

import ghidra.app.util.viewer.listingpanel.ListingBackgroundColorModel;
import ghidra.app.util.viewer.listingpanel.ListingPanel;
import ghidra.app.util.viewer.util.AddressIndexMap;
import ghidra.framework.options.AutoOptions;
import ghidra.framework.options.annotation.AutoOptionConsumed;
import ghidra.framework.plugintool.Plugin;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.trace.model.TraceAddressSnapRange;
import ghidra.trace.model.memory.TraceMemoryManager;
import ghidra.trace.model.memory.TraceMemoryRegion;
import ghidra.trace.model.memory.TraceMemoryState;
import ghidra.trace.model.program.TraceProgramView;
import ghidra.util.ColorUtils;
import java.awt.Color;
import java.math.BigInteger;
import java.util.Map;

public class MemoryStateListingBackgroundColorModel
implements ListingBackgroundColorModel {
    private Color defaultBackgroundColor = Color.WHITE;
    private AddressIndexMap addressIndexMap;
    private TraceProgramView view;
    private TraceMemoryManager memory;
    @AutoOptionConsumed(name={"Colors.Error Memory"})
    private Color errorColor;
    @AutoOptionConsumed(name={"Colors.Stale Memory"})
    private Color unknownColor;
    private Color unknownBlendedColor;
    private final AutoOptions.Wiring autoOptionsWiring;

    public MemoryStateListingBackgroundColorModel(Plugin plugin, ListingPanel listingPanel) {
        this.autoOptionsWiring = AutoOptions.wireOptions((Plugin)plugin, (Object)this);
        this.modelDataChanged(listingPanel);
    }

    public Color getBackgroundColor(BigInteger index) {
        if (this.view == null) {
            return this.defaultBackgroundColor;
        }
        Address address = this.addressIndexMap.getAddress(index);
        if (address == null) {
            return this.defaultBackgroundColor;
        }
        Map.Entry state = this.memory.getViewState(this.view.getSnap(), address);
        if (state == null) {
            return this.defaultBackgroundColor;
        }
        switch ((TraceMemoryState)state.getValue()) {
            case UNKNOWN: {
                return this.getUnknownColor(address);
            }
            case ERROR: {
                return this.errorColor;
            }
        }
        return this.defaultBackgroundColor;
    }

    @AutoOptionConsumed(name={"Colors.Stale Memory"})
    protected void setUnknownColor(Color unknownColor) {
        this.computeUnknownBlendedColor(unknownColor, this.defaultBackgroundColor);
    }

    protected Color getUnknownColor(Address address) {
        Map.Entry ent = this.memory.getViewMostRecentStateEntry(this.view.getSnap(), address);
        if (ent == null || ent.getValue() != TraceMemoryState.KNOWN) {
            return this.unknownColor;
        }
        TraceMemoryRegion region = this.memory.getRegionContaining(((TraceAddressSnapRange)ent.getKey()).getY1().longValue(), address);
        if (region != null && !region.isWrite()) {
            return this.unknownBlendedColor;
        }
        return this.unknownColor;
    }

    public Color getDefaultBackgroundColor() {
        return this.defaultBackgroundColor;
    }

    protected synchronized void computeUnknownBlendedColor(Color unkCol, Color defBg) {
        this.unknownBlendedColor = unkCol == null ? defBg : (defBg == null ? unkCol : ColorUtils.blend((Color)unkCol, (Color)defBg, (float)0.1f));
    }

    public void setDefaultBackgroundColor(Color c) {
        this.defaultBackgroundColor = c;
        this.computeUnknownBlendedColor(this.unknownColor, c);
    }

    public void modelDataChanged(ListingPanel listingPanel) {
        this.addressIndexMap = listingPanel.getAddressIndexMap();
        Program program = listingPanel.getProgram();
        if (!(program instanceof TraceProgramView)) {
            this.view = null;
            this.memory = null;
            return;
        }
        this.view = (TraceProgramView)program;
        this.memory = this.view.getTrace().getMemoryManager();
    }
}

