/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.console;

import docking.widgets.table.GTableCellRenderingData;
import ghidra.app.plugin.core.debug.gui.console.DebuggerConsoleProvider;
import ghidra.docking.settings.Settings;
import ghidra.util.table.column.AbstractGhidraColumnRenderer;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;

public class ConsoleActionsCellRenderer
extends AbstractGhidraColumnRenderer<DebuggerConsoleProvider.ActionList> {
    protected final JPanel box = new JPanel();
    protected final List<JButton> buttonCache = new ArrayList<JButton>();

    static void configureBox(JPanel box) {
        box.setLayout(new BoxLayout(box, 0));
        box.setOpaque(true);
        box.setAlignmentX(0.5f);
    }

    static void ensureCacheSize(List<JButton> buttonCache, int size, Consumer<JButton> extraConfig) {
        int diff = size - buttonCache.size();
        for (int i = 0; i < diff; ++i) {
            JButton button = new JButton();
            button.setMinimumSize(DebuggerConsoleProvider.ACTION_BUTTON_DIM);
            button.setMaximumSize(DebuggerConsoleProvider.ACTION_BUTTON_DIM);
            extraConfig.accept(button);
            buttonCache.add(button);
        }
    }

    static void populateBox(JPanel box, List<JButton> buttonCache, DebuggerConsoleProvider.ActionList value, Consumer<JButton> extraConfig) {
        box.removeAll();
        ConsoleActionsCellRenderer.ensureCacheSize(buttonCache, value.size(), extraConfig);
        int i = 0;
        for (DebuggerConsoleProvider.BoundAction a : value) {
            JButton button = buttonCache.get(i);
            button.setToolTipText(a.getTooltipText());
            button.setIcon(a.getIcon());
            button.setEnabled(a.isEnabled());
            box.add(button);
            ++i;
        }
    }

    public ConsoleActionsCellRenderer() {
        ConsoleActionsCellRenderer.configureBox(this.box);
    }

    public String getFilterString(DebuggerConsoleProvider.ActionList t, Settings settings) {
        return t.stream().map(a -> a.getName()).collect(Collectors.joining(" "));
    }

    public Component getTableCellRendererComponent(GTableCellRenderingData data) {
        super.getTableCellRendererComponent(data);
        this.box.setBackground(this.getBackground());
        DebuggerConsoleProvider.ActionList value = (DebuggerConsoleProvider.ActionList)data.getValue();
        ConsoleActionsCellRenderer.populateBox(this.box, this.buttonCache, value, button -> {});
        return this.box;
    }
}

